/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.registry.commands.subcommands;

import com.sofodev.armorplus.api.caps.abilities.AbilityData;
import com.sofodev.armorplus.api.caps.abilities.AbilityDataHandler;
import com.sofodev.armorplus.api.caps.abilities.ImplementedAbilities;
import com.sofodev.armorplus.common.registry.commands.subcommands.CommandSubBase;
import com.sofodev.armorplus.common.util.TextUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;

public class CommandAbilities
extends CommandSubBase {
    public CommandAbilities() {
        super("abilities");
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender.func_70003_b(this.func_82362_a(), this.func_71517_b());
    }

    public int func_82362_a() {
        return 4;
    }

    @Override
    public String func_71518_a(ICommandSender sender) {
        return super.func_71518_a(sender);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandAbilities.func_71530_a((String[])args, (String[])new String[]{"list", "limit", "add", "remove", "clear"});
        }
        if (args.length == 2 && ("add".equals(args[0]) || "remove".equals(args[0]))) {
            List abilities = ImplementedAbilities.ABILITY_REGISTRY.getEntries().stream().map(Map.Entry::getKey).collect(Collectors.toList());
            return CommandAbilities.func_175762_a((String[])args, abilities);
        }
        if (args.length == 3 && "add".equals(args[0])) {
            return CommandAbilities.func_71530_a((String[])args, (String[])new String[]{"hide"});
        }
        if (args.length == 2 && "limit".equals(args[0])) {
            return CommandAbilities.func_71530_a((String[])args, (String[])new String[]{"set"});
        }
        return Collections.emptyList();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        if (!(sender.func_174793_f() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)sender.func_174793_f();
        ItemStack stack = player.func_184614_ca();
        AbilityDataHandler.IAbilityHandler handler = AbilityDataHandler.getHandler(stack);
        if (handler == null) {
            this.send(player, TextUtils.error("commands.armorplus.abilities.wrong_item", new Object[0]));
        } else if (args.length > 0) {
            String argOne = args[0];
            int abilitySize = handler.getAbilities().size();
            byte limit = handler.getLimit();
            switch (argOne) {
                case "show": 
                case "display": 
                case "list": {
                    this.send(player, "commands.armorplus.abilities.show", handler.getAbilities());
                    break;
                }
                case "limit": {
                    this.limitCMD(handler, player, abilitySize, limit, args);
                    break;
                }
                case "add": {
                    this.addCMD(handler, player, stack, abilitySize, limit, args);
                    break;
                }
                case "clear": {
                    this.clearCMD(handler, player);
                    break;
                }
                case "remove": {
                    this.removeCMD(handler, player, args);
                    break;
                }
                default: {
                    this.send(player, TextUtils.error("commands.armorplus.abilities.usage", new Object[0]));
                    break;
                }
            }
        } else {
            this.send(player, TextUtils.error("commands.armorplus.abilities.usage", new Object[0]));
        }
    }

    private void clearCMD(AbilityDataHandler.IAbilityHandler handler, EntityPlayer player) {
        if (AbilityData.hasAbilities(handler)) {
            handler.getAbilities().clear();
            this.send(player, TextUtils.success("commands.armorplus.abilities.clear.success", new Object[0]));
        } else {
            this.send(player, TextUtils.error("commands.armorplus.abilities.clear.fail", new Object[0]));
        }
    }

    private void limitCMD(AbilityDataHandler.IAbilityHandler handler, EntityPlayer player, int abilitySize, byte limit, String[] args) {
        if (args.length == 2) {
            this.send(player, "commands.armorplus.abilities.limit", abilitySize, limit);
        } else if (args.length > 2 && args[1].equals("set")) {
            if (args.length > 3) {
                byte wantedLimit = Byte.parseByte(args[2]);
                handler.setLimit(wantedLimit);
                this.send(player, TextUtils.success("commands.armorplus.abilities.limit.set", abilitySize, limit));
            } else {
                this.send(player, TextUtils.error("commands.armorplus.abilities.limit.set.usage", new Object[0]));
            }
        } else {
            this.send(player, TextUtils.error("commands.armorplus.abilities.limit.set.usage", new Object[0]));
        }
    }

    private void addCMD(AbilityDataHandler.IAbilityHandler handler, EntityPlayer player, ItemStack stack, int abilitySize, byte limit, String[] args) {
        if (args.length <= 1) {
            return;
        }
        ResourceLocation id = new ResourceLocation(args[1]);
        AbilityData data = AbilityData.getData(id);
        if (!AbilityData.contains(handler, data)) {
            if (AbilityData.canProvide(stack, data)) {
                if (args.length == 2) {
                    this.addAbility(handler, player, data, false);
                } else if (args.length == 3) {
                    if (args[2].equals("hide")) {
                        this.addAbility(handler, player, data, true);
                    } else {
                        this.send(player, TextUtils.error("commands.armorplus.abilities.add.hide.usage", new Object[0]));
                    }
                }
            } else {
                this.send(player, TextUtils.error("commands.armorplus.abilities.add.incorrect_ability", data.getName()));
            }
        } else {
            this.send(player, TextUtils.error("commands.armorplus.abilities.add.fail.already_there", abilitySize, limit));
        }
    }

    private void addAbility(AbilityDataHandler.IAbilityHandler handler, EntityPlayer player, AbilityData data, boolean hide) {
        int abilitySize = handler.getAbilities().size();
        byte limit = handler.getLimit();
        if (AbilityData.hasRoomForAbilities(handler)) {
            if (!this.isEmpty(data)) {
                handler.addAbility(data);
                if (!hide) {
                    this.send(player, TextUtils.success("commands.armorplus.abilities.add.success", data.getName()));
                }
            }
        } else if (!hide) {
            this.send(player, TextUtils.error("commands.armorplus.abilities.add.fail", limit, abilitySize, limit));
        }
    }

    private void removeCMD(AbilityDataHandler.IAbilityHandler handler, EntityPlayer player, String[] args) {
        if (args.length > 1) {
            ResourceLocation id = new ResourceLocation(args[1]);
            AbilityData data = AbilityData.getData(id);
            if (AbilityData.hasAbilities(handler) && AbilityData.contains(handler, data)) {
                handler.removeAbility(data);
            } else {
                this.send(player, TextUtils.error("commands.armorplus.abilities.remove.fail", data.getName()));
            }
        } else {
            this.send(player, TextUtils.error("commands.armorplus.abilities.remove.usage", new Object[0]));
        }
    }

    private boolean isEmpty(AbilityData data) {
        return Objects.equals(data.getRegistryName(), new ResourceLocation("armorplus:empty"));
    }

    private void send(EntityPlayer player, String key, Object ... args) {
        this.send(player, (ITextComponent)TextUtils.translate(key, args));
    }

    private void send(EntityPlayer player, ITextComponent component) {
        player.func_145747_a(component);
    }
}

