/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.registry.entities.mobs.dungeon.skeletalking;

import com.google.common.base.Predicate;
import com.sofodev.armorplus.common.config.ModConfig;
import com.sofodev.armorplus.common.registry.ModItems;
import com.sofodev.armorplus.common.registry.entities.mobs.dungeon.base.BossInfoServerDungeon;
import com.sofodev.armorplus.common.registry.entities.mobs.dungeon.base.EntityAIRangedDungeonAttack;
import com.sofodev.armorplus.common.registry.entities.mobs.dungeon.skeletalking.projectile.EntityWitherMinion;
import com.sofodev.armorplus.common.util.TextUtils;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntitySkeletalKing
extends EntityWitherSkeleton
implements IRangedAttackMob {
    public static final Predicate<Entity> ANY_ENTITY = entity -> entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_190631_cK() && !(entity instanceof EntityWitherSkeleton);
    private final BossInfoServerDungeon bossInfo;

    public EntitySkeletalKing(World worldIn) {
        super(worldIn);
        this.func_70105_a(this.field_70130_N * 7.0f, this.field_70131_O * 7.0f);
        this.bossInfo = new BossInfoServerDungeon(this.func_145748_c_(), BossInfoServerDungeon.BossInfoDungeonType.SKELETAL_KING);
        this.func_110163_bv();
        this.field_70178_ae = true;
    }

    public void func_70071_h_() {
        if (this.func_70644_a(MobEffects.field_82731_v)) {
            this.func_184589_d(MobEffects.field_82731_v);
        }
        if (ModConfig.EntitiesConfig.skeletal_king.enableResistance && !this.func_70644_a(MobEffects.field_76429_m)) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 240, ModConfig.EntitiesConfig.skeletal_king.resistanceAmplifier));
        }
        super.func_70071_h_();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIRangedDungeonAttack(this, EntityAIRangedDungeonAttack.EntityAIType.WITHER));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 20.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 0, false, true, ANY_ENTITY));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ModConfig.EntitiesConfig.skeletal_king.bossHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(ModConfig.EntitiesConfig.skeletal_king.movementSpeed);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(ModConfig.EntitiesConfig.skeletal_king.armor);
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    private void launchWitherMinionsToEntity(int pos, EntityLivingBase entity) {
        this.launchWitherMinions(pos, entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e() * 0.5, entity.field_70161_v);
    }

    private void launchWitherMinions(int pos, double x, double y, double z) {
        this.field_70170_p.func_180498_a(null, 1024, new BlockPos((Entity)this), 0);
        double headingX = this.getHeadX(pos);
        double headingY = this.getHeadY(pos);
        double headingZ = this.getHeadZ(pos);
        double estimatedX = x - headingX;
        double estimatedY = y - headingY;
        double estimatedZ = z - headingZ;
        EntityWitherMinion witherMinion = new EntityWitherMinion(this.field_70170_p, (EntityLivingBase)this, estimatedX, estimatedY, estimatedZ);
        witherMinion.field_70163_u = headingY;
        witherMinion.field_70165_t = headingX;
        witherMinion.field_70161_v = headingZ;
        this.field_70170_p.func_72838_d((Entity)witherMinion);
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        this.launchWitherMinionsToEntity(0, target);
    }

    private double getHeadX(int xPos) {
        if (xPos <= 0) {
            return this.field_70165_t;
        }
        float f = (this.field_70761_aq + (float)(180 * (xPos - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.func_76134_b((float)f);
        return this.field_70165_t + (double)f1 * 1.3;
    }

    private double getHeadY(int yPos) {
        return yPos <= 0 ? this.field_70163_u + 3.0 : this.field_70163_u + 2.2;
    }

    private double getHeadZ(int zPos) {
        if (zPos <= 0) {
            return this.field_70161_v;
        }
        float f = (this.field_70761_aq + (float)(180 * (zPos - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.func_76126_a((float)f);
        return this.field_70161_v + (double)f1 * 1.3;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            String[] names;
            for (String name : names = new String[]{"D", "E", "A", "T", "H"}) {
                EntityBlaze split = new EntityBlaze(this.field_70170_p);
                split.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                split.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)this)), null);
                this.field_70170_p.func_72838_d((Entity)split);
                split.func_96094_a(TextFormatting.GOLD + "" + TextFormatting.BOLD + name);
                split.func_174805_g(true);
                split.func_82142_c(false);
                split.func_184224_h(false);
                split.func_98053_h(true);
                split.field_98038_p = true;
            }
            if (ModConfig.EntitiesConfig.mob_drops.skeletal_king.skeletalKingDrop) {
                this.func_145778_a(Items.field_151156_bN, 2 + this.field_70146_Z.nextInt(1), 5.0f);
                this.func_70099_a(new ItemStack((Item)ModItems.materials, 1 + this.field_70146_Z.nextInt(1), 2), 5.0f);
            }
        }
    }

    protected void func_70609_aI() {
        super.func_70609_aI();
    }

    private static ITextComponent setDialog(ITextComponent parent, String ... appended) {
        ITextComponent copy = parent.func_150259_f();
        for (String part : appended) {
            copy.func_150258_a(EntitySkeletalKing.dialog(part, new Object[0]));
        }
        return copy;
    }

    private static String dialog(String part, Object ... args) {
        return "\n" + TextUtils.translatedText(TextFormatting.ITALIC, "dialogs.armorplus.skeletal_king." + part, args);
    }

    public static void registerFixesSkeletalKing(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntitySkeletalKing.class);
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        if (!this.func_184614_ca().func_190926_b()) {
            this.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
        }
        if (!this.func_184592_cb().func_190926_b()) {
            this.func_184611_a(EnumHand.OFF_HAND, ItemStack.field_190927_a);
        }
        return super.func_180482_a(difficulty, livingdata);
    }

    public Iterable<ItemStack> func_184209_aF() {
        return Collections.emptyList();
    }

    public Iterable<ItemStack> func_184214_aD() {
        return Collections.emptyList();
    }
}

