/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.registry.items;

import com.sofodev.armorplus.common.config.ModConfig;
import com.sofodev.armorplus.common.registry.ModDimensions;
import com.sofodev.armorplus.common.registry.entities.mobs.dungeon.skeletalking.EntitySkeletalKing;
import com.sofodev.armorplus.common.registry.items.base.ItemBase;
import com.sofodev.armorplus.common.util.TextUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;

public class ItemCombinedMap
extends ItemBase {
    public final Variants variant;

    public ItemCombinedMap(Variants variant) {
        super(variant.getName());
        this.variant = variant;
        this.func_77656_e(1);
    }

    public DimensionType getDimension() {
        return this.variant.getType();
    }

    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        if (ModConfig.MainConfig.maps.allowSpawnOfBosses && this.variant == Variants.MAP_OF_SACRIFICE && !world.field_72995_K) {
            EntitySkeletalKing king = new EntitySkeletalKing(world);
            king.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            king.func_180482_a(world.func_175649_E(new BlockPos((Entity)player)), null);
            world.func_72838_d((Entity)king);
            king.field_98038_p = true;
            heldStack.func_77972_a(2, (EntityLivingBase)player);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)heldStack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (this.variant == Variants.MAP_OF_SACRIFICE) {
            tooltip.add(String.format("%s%s", TextFormatting.GREEN, TextUtils.translatedText("item.armorplus.map_of_sacrifice.summon", new Object[0])));
            tooltip.add(String.format("%s%s", TextFormatting.BLUE, TextUtils.translatedText("item.armorplus.map_of_sacrifice.usage", new Object[0])));
            tooltip.add(String.format("%s(%s %s%s)%s - %s(%s %s%s)", TextFormatting.RED, TextUtils.translatedText("item.armorplus.map_of_sacrifice.health", new Object[0]), ModConfig.EntitiesConfig.skeletal_king.bossHealth, TextFormatting.RED, TextFormatting.RESET, TextFormatting.AQUA, TextUtils.translatedText("item.armorplus.map_of_sacrifice.armor", new Object[0]), ModConfig.EntitiesConfig.skeletal_king.armor, TextFormatting.AQUA));
            tooltip.add(String.format("%s%s%s %s", TextFormatting.GRAY, TextFormatting.ITALIC, TextUtils.translatedText("item.armorplus.map_of_sacrifice.allowed", new Object[0]), ModConfig.MainConfig.maps.allowSpawnOfBosses));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public static enum Variants {
        MAP(null),
        MAP_OF_OVERWORLD(DimensionType.OVERWORLD),
        MAP_OF_THE_NETHER(DimensionType.NETHER),
        MAP_OF_THE_END(DimensionType.THE_END),
        MAP_OF_SACRIFICE(null),
        MAP_OF_THE_REALM(ModDimensions.REALM),
        MAP_OF_ARENA(ModDimensions.ARENA),
        MAP_OF_THE_SHAPER(null),
        MAP_OF_THE_ELDER(null);

        private final DimensionType type;

        private Variants(DimensionType type) {
            this.type = type;
        }

        public DimensionType getType() {
            return this.type;
        }

        public String getName() {
            return this.name().toLowerCase();
        }
    }
}

