/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.registry.items.dev;

import com.sofodev.armorplus.common.registry.items.base.ItemBase;
import com.sofodev.armorplus.common.util.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSpawnStructure
extends ItemBase {
    private final String itemName;
    private final ResourceLocation structureLocation;

    public ItemSpawnStructure(String itemName, ResourceLocation structureLocation) {
        super(itemName);
        this.itemName = itemName;
        this.structureLocation = structureLocation;
    }

    public String func_77653_i(ItemStack stack) {
        switch (this.itemName) {
            case "ender_dungeon_floor_1_spawn_item": {
                return "Structure Spawn: Ender Dungeon Floor 1 (ArmorPlus)";
            }
            case "tower_spawn_item": {
                return "Structure Spawn: Nether Tower (ArmorPlus)";
            }
            case "dungeon_placer_1": {
                return "Structure Spawn: Skeletal King Dungeon (ArmorPlus)";
            }
            case "dungeon_placer_2": {
                return "Structure Spawn: Guardian Overlord Dungeon (ArmorPlus)";
            }
            case "dungeon_placer_3": {
                return "Structure Spawn: Demonic Dragon Dungeon (ArmorPlus)";
            }
        }
        return "Invalid Item";
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!(world instanceof WorldServer)) {
            return EnumActionResult.PASS;
        }
        WorldServer serverworld = (WorldServer)world;
        PlacementSettings settings = new PlacementSettings();
        if (facing == EnumFacing.EAST) {
            settings.func_186220_a(Rotation.NONE);
        } else if (facing == EnumFacing.SOUTH) {
            settings.func_186220_a(Rotation.CLOCKWISE_90);
        } else if (facing == EnumFacing.WEST) {
            settings.func_186220_a(Rotation.CLOCKWISE_180);
        } else if (facing == EnumFacing.NORTH) {
            settings.func_186220_a(Rotation.COUNTERCLOCKWISE_90);
        }
        MinecraftServer server = serverworld.func_73046_m();
        Template template = serverworld.func_72860_G().func_186340_h().func_186237_a(server, this.structureLocation);
        template.func_186252_a("sokratis12GR");
        template.func_186253_b((World)serverworld, pos, settings);
        return EnumActionResult.SUCCESS;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        super.initModel(Utils.setRL("tower_spawn_item"), (Object)0);
    }
}

