/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.thedragonlib.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class ItemStackUtils {
    public static ItemStack getTICItemStack(String name, int meta) {
        return ItemStackUtils.getItemStack("tconstruct", name, meta);
    }

    public static ItemStack getAPItemStack(String name, int meta) {
        return ItemStackUtils.getItemStack("armorplus", name, meta);
    }

    public static ItemStack getAPItemStack(String name) {
        return ItemStackUtils.getAPItemStack(name, 0);
    }

    public static ItemStack getItemStack(String modid, String itemName, int meta) {
        return ItemStackUtils.getItemStack(Item.func_111206_d((String)(modid + ":" + itemName)), meta);
    }

    public static ItemStack getItemStack(String modid, String itemName) {
        return ItemStackUtils.getItemStack(modid, itemName, 0);
    }

    public static ItemStack getItemStack(Object type, int amount, int meta) {
        if (type instanceof String) {
            return new ItemStack(Objects.requireNonNull(Item.func_111206_d((String)((String)type))), amount, meta);
        }
        if (type instanceof Block) {
            return new ItemStack((Block)type, amount, meta);
        }
        if (type instanceof Item) {
            return new ItemStack((Item)type, amount, meta);
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getItemStack(Object type, int meta) {
        if (type instanceof String) {
            return ItemStackUtils.getItemStack(Item.func_111206_d((String)((String)type)), 1, meta);
        }
        if (type instanceof Block) {
            return ItemStackUtils.getItemStack(type, 1, meta);
        }
        if (type instanceof Item) {
            return ItemStackUtils.getItemStack(type, 1, meta);
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getItemStack(Object type) {
        if (type instanceof String) {
            return ItemStackUtils.getItemStack(Item.func_111206_d((String)((String)type)), 0);
        }
        if (type instanceof Block) {
            return ItemStackUtils.getItemStack(type, 0);
        }
        if (type instanceof Item) {
            return ItemStackUtils.getItemStack(type, 0);
        }
        if (type instanceof ItemStack) {
            return (ItemStack)type;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getEmptyStack() {
        return ItemStack.field_190927_a;
    }

    public static Item getItem(Object type) {
        if (type instanceof String) {
            return Item.func_111206_d((String)((String)type));
        }
        if (type instanceof Block) {
            return Item.func_150898_a((Block)((Block)type));
        }
        if (type instanceof ItemStack) {
            return ((ItemStack)type).func_77973_b();
        }
        return ItemStack.field_190927_a.func_77973_b();
    }

    public static Item getItem(String modName, String itemName) {
        return Item.func_111206_d((String)(modName + ":" + itemName));
    }

    public static Item getEmptyItem() {
        return ItemStack.field_190927_a.func_77973_b();
    }

    public static ItemStack validateCopy(ItemStack stack) {
        return ItemStackUtils.isValid(stack) ? stack.func_77946_l() : ItemStackUtils.getNull();
    }

    public static ItemStack validateCheck(ItemStack stack) {
        return ItemStackUtils.isValid(stack) ? stack : ItemStackUtils.getNull();
    }

    public static boolean isValid(ItemStack stack) {
        return stack != null && !stack.func_190926_b();
    }

    public static ItemStack getNull() {
        return ItemStack.field_190927_a;
    }

    public static int getStackSize(ItemStack stack) {
        return !ItemStackUtils.isValid(stack) ? 0 : stack.func_190916_E();
    }

    public static ItemStack setStackSize(ItemStack stack, int size) {
        return ItemStackUtils.setStackSize(stack, size, false);
    }

    public static ItemStack setStackSize(ItemStack stack, int size, boolean containerOnEmpty) {
        if (size <= 0) {
            return ItemStackUtils.isValid(stack) && containerOnEmpty ? stack.func_77973_b().getContainerItem(stack) : ItemStackUtils.getNull();
        }
        stack.func_190920_e(size);
        return stack;
    }

    public static ItemStack addStackSize(ItemStack stack, int size) {
        return ItemStackUtils.addStackSize(stack, size, false);
    }

    public static ItemStack addStackSize(ItemStack stack, int size, boolean containerOnEmpty) {
        return ItemStackUtils.setStackSize(stack, ItemStackUtils.getStackSize(stack) + size, containerOnEmpty);
    }

    public static boolean isIInvEmpty(NonNullList<ItemStack> slots) {
        return slots.stream().noneMatch(ItemStackUtils::isValid);
    }

    public static NonNullList<ItemStack> createSlots(int size) {
        return NonNullList.func_191197_a((int)size, (Object)ItemStackUtils.getNull());
    }

    public static NonNullList<ItemStack> getItemStacks(Item ... items) {
        NonNullList list = NonNullList.func_191196_a();
        Arrays.stream(items).map(ItemStackUtils::getItemStack).forEachOrdered(arg_0 -> list.add(arg_0));
        return list;
    }

    public static NonNullList<ItemStack> getItemStacks(ItemStack ... itemStacks) {
        NonNullList list = NonNullList.func_191196_a();
        Collections.addAll(list, itemStacks);
        return list;
    }
}

