/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.util.GolemConfigSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public final class EntityCoalGolem
extends GolemBase {
    public static final String ALLOW_SPECIAL = "Allow Special: Blindness";

    public EntityCoalGolem(World world) {
        super(world);
        this.setLootTableLoc("golem_coal");
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.28);
        this.addHealItem(new ItemStack(Items.field_151044_h, 1, Short.MAX_VALUE), 0.25);
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityCoalGolem.makeTexture("golems", "golem_coal");
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            int BLIND_CHANCE = 4;
            GolemConfigSet cfg = EntityCoalGolem.getConfig(this);
            if (cfg.getBoolean(ALLOW_SPECIAL) && entity instanceof EntityLivingBase && this.field_70146_Z.nextInt(4) == 0) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76440_q, 20 * (3 + this.field_70146_Z.nextInt(5)), 0));
            }
            return true;
        }
        return false;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70027_ad()) {
            this.func_70015_d(2);
        }
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187902_gb;
    }

    @Override
    public List<String> addSpecialDesc(List<String> list) {
        if (EntityCoalGolem.getConfig(this).getBoolean(ALLOW_SPECIAL)) {
            list.add(TextFormatting.GRAY + EntityCoalGolem.trans("entitytip.blinds_creatures", new Object[0]));
        }
        return list;
    }
}

