/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.events.EndGolemTeleportEvent;
import com.golems.util.GolemConfigSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityEndstoneGolem
extends GolemBase {
    public static final String ALLOW_SPECIAL = "Allow Special: Teleporting";
    public static final String ALLOW_WATER_HURT = "Can Take Water Damage";
    @Deprecated
    protected int teleportDelay;
    protected double range;
    protected boolean allowTeleport;
    protected boolean isHurtByWater;
    protected boolean hasAmbientParticles;
    protected int ticksBetweenIdleTeleports = 200;
    protected int chanceToTeleportWhenHurt = 15;

    public EntityEndstoneGolem(World world) {
        this(world, 32.0, true);
        GolemConfigSet cfg = EntityEndstoneGolem.getConfig(this);
        this.setLootTableLoc("golem_end_stone");
        this.isHurtByWater = cfg.getBoolean(ALLOW_WATER_HURT);
        this.allowTeleport = cfg.getBoolean(ALLOW_SPECIAL);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
    }

    public EntityEndstoneGolem(World world, double teleportRange, boolean ambientParticles) {
        super(world);
        this.range = teleportRange;
        this.isHurtByWater = false;
        this.hasAmbientParticles = ambientParticles;
        this.allowTeleport = true;
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityEndstoneGolem.makeTexture("golems", "golem_end_stone");
    }

    public void func_70619_bc() {
        super.func_70619_bc();
        if (this.func_70643_av() != null) {
            this.func_70625_a((Entity)this.func_70643_av(), 100.0f, 100.0f);
            if (this.func_70643_av().func_70068_e((Entity)this) > 25.0 && (this.field_70146_Z.nextInt(30) == 0 || this.func_70643_av().func_70643_av() == this)) {
                this.teleportToEntity((Entity)this.func_70643_av());
            }
        } else if (this.field_70146_Z.nextInt(this.ticksBetweenIdleTeleports) == 0) {
            this.teleportRandomly();
        }
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K && this.hasAmbientParticles) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, new int[0]);
            }
        }
        this.field_70703_bu = false;
        super.func_70636_d();
    }

    public boolean func_70097_a(DamageSource src, float amnt) {
        block5: {
            block4: {
                if (this.func_180431_b(src)) {
                    return false;
                }
                if (!(src instanceof EntityDamageSourceIndirect)) break block4;
                if (src.func_76346_g() instanceof EntityLivingBase && this.teleportToEntity(src.func_76346_g())) {
                    this.func_70604_c((EntityLivingBase)src.func_76346_g());
                    return super.func_70097_a(src, amnt);
                }
                for (int i = 0; i < 32; ++i) {
                    if (!this.teleportRandomly()) continue;
                    return false;
                }
                break block5;
            }
            if (this.field_70146_Z.nextInt(this.chanceToTeleportWhenHurt) != 0 && (this.func_70643_av() != null || !this.field_70146_Z.nextBoolean()) && (!this.isHurtByWater || src != DamageSource.field_76369_e)) break block5;
            for (int i = 0; i < 16 && !this.teleportRandomly(); ++i) {
            }
        }
        return super.func_70097_a(src, amnt);
    }

    protected boolean teleportRandomly() {
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * this.range;
        double d1 = this.field_70163_u + (this.field_70146_Z.nextDouble() - 0.5) * this.range * 0.5;
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * this.range;
        return this.teleportTo(d0, d1, d2);
    }

    protected boolean teleportToEntity(Entity entity) {
        Vec3d vec3d = new Vec3d(this.field_70165_t - entity.field_70165_t, this.func_174813_aQ().field_72338_b + (double)(this.field_70131_O / 2.0f) - entity.field_70163_u + (double)entity.func_70047_e(), this.field_70161_v - entity.field_70161_v);
        vec3d = vec3d.func_72432_b();
        double d0 = 16.0;
        double d1 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72450_a * 16.0;
        double d2 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - vec3d.field_72448_b * 16.0;
        double d3 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72449_c * 16.0;
        return this.teleportTo(d1, d2, d3);
    }

    protected boolean teleportTo(double x, double y, double z) {
        EndGolemTeleportEvent event = new EndGolemTeleportEvent(this, x, y, z, 0.0f);
        if (!this.allowTeleport || MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        boolean flag = this.func_184595_k(event.getTargetX(), event.getTargetY(), event.getTargetZ());
        if (flag) {
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        return flag;
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187902_gb;
    }

    @Override
    public List<String> addSpecialDesc(List<String> list) {
        if (((Object)((Object)this)).getClass() == EntityEndstoneGolem.class && EntityEndstoneGolem.getConfig(this).getBoolean(ALLOW_SPECIAL)) {
            list.add(TextFormatting.DARK_AQUA + EntityEndstoneGolem.trans("entitytip.can_teleport", new Object[0]));
        }
        return list;
    }
}

