/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.blocks.BlockUtilityGlow;
import com.golems.entity.GolemBase;
import com.golems.entity.ai.EntityAIUtilityBlock;
import com.golems.main.GolemItems;
import com.golems.util.GolemLookup;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class EntityGlowstoneGolem
extends GolemBase {
    public static final String ALLOW_SPECIAL = "Allow Special: Emit Light";
    public static final String FREQUENCY = "Light Frequency";
    private boolean allowSpecial;
    private final float brightness;

    public EntityGlowstoneGolem(World world) {
        this(world, 1.0f, GolemLookup.getConfig(EntityGlowstoneGolem.class).getInt(FREQUENCY), GolemLookup.getConfig(EntityGlowstoneGolem.class).getBoolean(ALLOW_SPECIAL));
        this.field_70178_ae = true;
        this.setCanTakeFallDamage(true);
        this.setCanSwim(true);
        this.setLootTableLoc("golem_glowstone");
        this.addHealItem(new ItemStack(Items.field_151114_aO), 0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
    }

    public EntityGlowstoneGolem(World world, float lightLevel, int freq, boolean allowed) {
        super(world);
        this.allowSpecial = allowed;
        int lightInt = (int)(lightLevel * 15.0f);
        this.brightness = lightLevel;
        IBlockState state = GolemItems.blockLightSource.func_176223_P().func_177226_a((IProperty)BlockUtilityGlow.LIGHT_LEVEL, (Comparable)Integer.valueOf(lightInt));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIUtilityBlock(this, state, freq, allowed));
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityGlowstoneGolem.makeTexture("golems", "golem_glowstone");
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187569_bQ;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187561_bM;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return (int)(1.572888E7f * this.brightness);
    }

    public float func_70013_c() {
        return this.brightness;
    }

    @Override
    public boolean isProvidingLight() {
        return true;
    }

    @Override
    public List<String> addSpecialDesc(List<String> list) {
        if (this.allowSpecial) {
            list.add(TextFormatting.RED + EntityGlowstoneGolem.trans("entitytip.lights_area", new Object[0]));
        }
        return list;
    }
}

