/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.blocks.BlockUtilityPower;
import com.golems.entity.GolemBase;
import com.golems.entity.ai.EntityAIUtilityBlock;
import com.golems.main.GolemItems;
import com.golems.util.GolemLookup;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class EntityRedstoneGolem
extends GolemBase {
    public static final String ALLOW_SPECIAL = "Allow Special: Redstone Power";
    public static final int DEF_FREQ = 2;

    public EntityRedstoneGolem(World world) {
        this(world, GolemLookup.getConfig(EntityRedstoneGolem.class).getBoolean(ALLOW_SPECIAL), 15, 2);
        this.setLootTableLoc("golem_redstone");
        this.addHealItem(new ItemStack(Items.field_151137_ax), 0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
    }

    public EntityRedstoneGolem(World world, boolean allowSpecial, int power, int frequency) {
        super(world);
        IBlockState state = GolemItems.blockPowerSource.func_176223_P().func_177226_a((IProperty)BlockUtilityPower.POWER_LEVEL, (Comparable)Integer.valueOf(power));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIUtilityBlock(this, state, frequency, allowSpecial));
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityRedstoneGolem.makeTexture("golems", "golem_redstone");
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187902_gb;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return super.func_70070_b() + 64;
    }

    @Override
    public boolean isProvidingPower() {
        return true;
    }

    @Override
    public List<String> addSpecialDesc(List<String> list) {
        if (((Object)((Object)this)).getClass() == EntityRedstoneGolem.class && EntityRedstoneGolem.getConfig(this).getBoolean(ALLOW_SPECIAL)) {
            list.add(TextFormatting.RED + EntityRedstoneGolem.trans("entitytip.emits_redstone_signal", new Object[0]));
        }
        return list;
    }
}

