/*
 * Decompiled with CFR 0.152.
 */
package com.golems.events.handlers;

import com.golems.blocks.BlockGolemHead;
import com.golems.entity.EntityBookshelfGolem;
import com.golems.entity.EntityClayGolem;
import com.golems.entity.EntityCraftingGolem;
import com.golems.entity.EntityFurnaceGolem;
import com.golems.entity.EntityGlowstoneGolem;
import com.golems.entity.EntityHardenedClayGolem;
import com.golems.entity.EntityIceGolem;
import com.golems.entity.EntityLeafGolem;
import com.golems.entity.EntityObsidianGolem;
import com.golems.entity.EntityQuartzGolem;
import com.golems.entity.EntitySlimeGolem;
import com.golems.entity.EntityStainedClayGolem;
import com.golems.entity.EntityWoodenGolem;
import com.golems.entity.EntityWoolGolem;
import com.golems.entity.GolemBase;
import com.golems.entity.GolemColorizedMultiTextured;
import com.golems.entity.GolemMultiTextured;
import com.golems.items.ItemBedrockGolem;
import com.golems.main.Config;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.Village;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDesert;
import net.minecraft.world.biome.BiomeJungle;
import net.minecraft.world.biome.BiomeMesa;
import net.minecraft.world.biome.BiomePlains;
import net.minecraft.world.biome.BiomeSavanna;
import net.minecraft.world.biome.BiomeSnow;
import net.minecraft.world.biome.BiomeSwamp;
import net.minecraft.world.biome.BiomeTaiga;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class GolemCommonEventHandler {
    @SubscribeEvent
    public void onPopulateChunk(PopulateChunkEvent.Post event) {
        GolemBase golemInstance;
        BlockPos spawn;
        Biome biome;
        Class<? extends GolemBase> golemClazz;
        BlockPos pos;
        Village village;
        int GOLEM_CHANCE = Config.getVillageGolemSpawnChance();
        int DIMID = event.getWorld().field_73011_w.getDimension();
        if (DIMID == 0 && GOLEM_CHANCE > 0 && event.isHasVillageGenerated() && event.getRand().nextInt(100) < GOLEM_CHANCE && (village = event.getWorld().field_72982_D.func_176056_a(pos = new BlockPos(event.getChunkX() * 16, 100, event.getChunkZ() * 16), 32)) != null && (golemClazz = GolemCommonEventHandler.getGolemForBiome(biome = event.getWorld().func_180494_b(pos), event.getRand())) != null && (spawn = GolemCommonEventHandler.getSafeSpawnPos((EntityLivingBase)(golemInstance = (GolemBase)EntityList.func_191304_a(golemClazz, (World)event.getWorld())), pos.func_177982_a(8, 0, 8))) != null) {
            golemInstance.func_70107_b(spawn.func_177958_n(), spawn.func_177956_o(), spawn.func_177952_p());
            golemInstance.func_70849_f(false);
            event.getWorld().func_72838_d((Entity)golemInstance);
            if (golemInstance instanceof GolemMultiTextured) {
                byte texture = (byte)event.getRand().nextInt(((GolemMultiTextured)golemInstance).getNumTextures());
                ((GolemMultiTextured)golemInstance).setTextureNum(texture);
            } else if (golemInstance instanceof GolemColorizedMultiTextured) {
                byte texture = (byte)event.getRand().nextInt(((GolemColorizedMultiTextured)golemInstance).getColorArray().length);
                ((GolemColorizedMultiTextured)golemInstance).setTextureNum(texture);
            }
        }
    }

    private static BlockPos getSafeSpawnPos(EntityLivingBase entity, BlockPos near) {
        int radius = 6;
        int maxTries = 24;
        for (int i = 0; i < 24; ++i) {
            int x = near.func_177958_n() + entity.func_130014_f_().field_73012_v.nextInt(12) - 6;
            int z = near.func_177952_p() + entity.func_130014_f_().field_73012_v.nextInt(12) - 6;
            int y = entity.func_130014_f_().func_189649_b(x, z) + 16;
            BlockPos testing = new BlockPos(x, y, z);
            while (entity.func_130014_f_().func_175623_d(testing) && testing.func_177956_o() > 0) {
                testing = testing.func_177979_c(1);
            }
            IBlockState iblockstate = entity.func_130014_f_().func_180495_p(testing);
            if (!iblockstate.func_189884_a((Entity)entity)) continue;
            return testing.func_177981_b(1);
        }
        return null;
    }

    @Nullable
    private static Class<? extends GolemBase> getGolemForBiome(Biome biome, Random rand) {
        ArrayList<Class<GolemBase>> options = new ArrayList<Class<GolemBase>>();
        if (biome instanceof BiomeDesert) {
            options.addAll(Config.getDesertGolems());
        } else if (biome instanceof BiomePlains || biome instanceof BiomeSavanna || biome instanceof BiomeTaiga) {
            options.addAll(Config.getPlainsGolems());
        } else if (biome instanceof BiomeMesa) {
            options.add(EntityHardenedClayGolem.class);
            options.add(EntityStainedClayGolem.class);
        } else if (biome instanceof BiomeJungle) {
            options.add(EntityWoodenGolem.class);
            options.add(EntityLeafGolem.class);
        } else if (biome instanceof BiomeSnow) {
            options.add(EntityIceGolem.class);
            options.add(EntityWoolGolem.class);
            options.add(EntityQuartzGolem.class);
        } else if (biome instanceof BiomeSwamp) {
            options.add(EntityWoodenGolem.class);
            options.add(EntitySlimeGolem.class);
            options.add(EntityLeafGolem.class);
            options.add(EntityClayGolem.class);
        }
        int clay = 3;
        int crafting = 3;
        int obsidian = 6;
        int glowstone = 5;
        int books = 4;
        if (rand.nextInt(3) == 0) {
            options.add(EntityClayGolem.class);
        }
        if (rand.nextInt(3) == 0) {
            options.add(EntityCraftingGolem.class);
        }
        if (rand.nextInt(6) == 0) {
            options.add(EntityObsidianGolem.class);
        }
        if (rand.nextInt(5) == 0) {
            options.add(EntityGlowstoneGolem.class);
        }
        if (rand.nextInt(4) == 0) {
            options.add(EntityBookshelfGolem.class);
        }
        return options.isEmpty() ? null : (Class)options.get(rand.nextInt(options.size()));
    }

    @SubscribeEvent
    public void onPlayerPlaceBlock(PlayerInteractEvent.RightClickBlock event) {
        Block heldBlock;
        ItemStack stack = event.getItemStack();
        if (Config.doesPumpkinBuildGolem() && !event.isCanceled() && !stack.func_190926_b() && stack.func_77973_b() instanceof ItemBlock && (heldBlock = ((ItemBlock)stack.func_77973_b()).func_179223_d()) instanceof BlockPumpkin) {
            BlockPos pumpkinPos = event.getPos();
            Block clicked = event.getWorld().func_180495_p(pumpkinPos).func_177230_c();
            if (!clicked.func_176200_f((IBlockAccess)event.getWorld(), pumpkinPos)) {
                pumpkinPos = pumpkinPos.func_177972_a(event.getFace());
            }
            if (event.getEntityPlayer().func_175151_a(pumpkinPos, event.getFace(), stack)) {
                IBlockState pumpkin = heldBlock.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)event.getEntityPlayer().func_174811_aO().func_176734_d());
                if (event.getWorld().func_175656_a(pumpkinPos, pumpkin)) {
                    event.setCanceled(true);
                    BlockGolemHead.trySpawnGolem(event.getWorld(), pumpkinPos);
                    if (!event.getEntityPlayer().func_184812_l_()) {
                        event.getItemStack().func_190918_g(1);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        EntityIronGolem golem;
        if (Config.enableHealGolems() && event.getTarget() instanceof EntityIronGolem && new ItemStack(Blocks.field_150339_S).func_77969_a(event.getItemStack()) && (golem = (EntityIronGolem)event.getTarget()).func_110143_aJ() < golem.func_110138_aP()) {
            golem.func_70691_i(golem.func_110138_aP() * 0.25f);
            event.getItemStack().func_190918_g(1);
            if (golem.func_70638_az() == event.getEntityPlayer()) {
                golem.func_70604_c(null);
                golem.func_70624_b(null);
            }
            ItemBedrockGolem.spawnParticles(golem.func_130014_f_(), golem.field_70165_t, golem.field_70163_u + (double)golem.field_70131_O / 2.0, golem.field_70161_v, 0.12, EnumParticleTypes.VILLAGER_HAPPY, 20);
            golem.func_184185_a(SoundEvents.field_187845_fY, 0.85f, 1.1f + golem.func_70681_au().nextFloat() * 0.2f);
        }
    }

    @SubscribeEvent
    public void onTargetEvent(LivingSetAttackTargetEvent event) {
        if (event.getEntityLiving() instanceof EntityLiving && event.getTarget() instanceof EntityFurnaceGolem && !((EntityFurnaceGolem)event.getTarget()).hasFuel()) {
            ((EntityLiving)event.getEntityLiving()).func_70624_b(null);
        }
    }
}

