/*
 * Decompiled with CFR 0.152.
 */
package com.golems.gui;

import com.golems.entity.GolemBase;
import com.golems.gui.GolemBookEntry;
import com.golems.main.GolemItems;
import com.golems.proxies.CommonProxy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class GuiGolemBook
extends GuiScreen {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("golems", "textures/gui/info_book.png");
    protected static final ResourceLocation CONTENTS = new ResourceLocation("golems", "textures/gui/info_book_contents.png");
    protected static final int BOOK_HEIGHT = 164;
    protected static final int BOOK_WIDTH = 256;
    protected static final int DEF_SEP = 5;
    protected static final int SCR_OFFSET_Y = 16;
    protected static final int ARROW_WIDTH = 18;
    protected static final int ARROW_HEIGHT = 15;
    protected static final int SUPP_WIDTH = 100;
    protected static final int SUPP_HEIGHT = 50;
    private GuiButton buttonDone;
    private BlockButton buttonBlockLeft;
    private BlockButton buttonBlockRight;
    private NextPageButton buttonNextPage;
    private NextPageButton buttonPreviousPage;
    private GolemEntryButton[] tableOfContents;
    protected int curPage;
    protected int totalPages;
    protected long ticksOpen;
    public static final List<GolemBookEntry> GOLEMS = new ArrayList<GolemBookEntry>();
    private static final List<GolemBookEntry> ALPHABETICAL = new ArrayList<GolemBookEntry>();
    private final EntityPlayer player;
    private final ItemStack book;
    private static final int idDone = 0;
    private static final int idNextPage = 1;
    private static final int idPrevPage = 2;
    private static final int idBlockLeft = 3;
    private static final int idBlockRight = 4;
    private static final int idTableContents = 5;
    private static final float GOLEM_BLOCK_SCALE = 1.6f;
    private static final int MARGIN = 12;
    private static final int NUM_PAGES_INTRO = 6;
    private static final int NUM_CONTENTS_ENTRIES = 5;
    protected static final int CONTENTS_W = 106;
    protected static final int CONTENTS_H = 110;
    protected static final int SCROLL_STARTX = 12;
    protected static final int SCROLL_STARTY = 24;
    protected static final int SCROLL_W = 12;
    protected static final int SCROLL_H = 15;
    protected static final int ENTRY_W = 88;
    protected static final int ENTRY_H = 22;
    private float currentScroll;
    private boolean isScrolling;
    private static final ItemStack[] ingredientsSpell = new ItemStack[]{new ItemStack(Items.field_151121_aF), new ItemStack(Items.field_151008_G), new ItemStack(Items.field_151137_ax), new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLACK.func_176767_b())};
    private static final ItemStack outputSpell = new ItemStack(GolemItems.golemPaper);
    private static final ItemStack[] ingredientsHead = new ItemStack[]{new ItemStack(Blocks.field_150423_aK), new ItemStack(GolemItems.golemPaper)};
    private static final ItemStack outputHead = new ItemStack(GolemItems.golemHead);

    public GuiGolemBook(EntityPlayer playerIn, ItemStack itemIn) {
        if (GOLEMS.isEmpty()) {
            GuiGolemBook.initGolemBookEntries(playerIn.func_130014_f_());
        }
        this.player = playerIn;
        this.book = itemIn;
        this.curPage = 0;
        this.totalPages = 6 + GOLEMS.size();
        this.currentScroll = 0.0f;
        this.isScrolling = false;
        this.tableOfContents = new GolemEntryButton[5];
        this.ticksOpen = 0L;
    }

    private static final void initGolemBookEntries(World world) {
        GOLEMS.clear();
        for (GolemBase golem : CommonProxy.DUMMY_GOLEMS) {
            if (!GolemBase.getConfig(golem).canSpawn()) continue;
            GOLEMS.add(new GolemBookEntry(golem));
        }
        Collections.sort(GOLEMS, (g1, g2) -> Float.compare(g1.getAttack(), g2.getAttack()));
        ALPHABETICAL.clear();
        ALPHABETICAL.addAll(GOLEMS);
        Collections.sort(ALPHABETICAL, (g1, g2) -> g1.getGolemName().compareTo(g2.getGolemName()));
    }

    public void func_73876_c() {
        ++this.ticksOpen;
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        int doneW = 98;
        int doneH = 20;
        int doneX = (this.field_146294_l - 98) / 2;
        int doneY = 188;
        this.buttonDone = this.func_189646_b(new GuiButton(0, doneX, 188, 98, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        int arrowX = (this.field_146294_l - 256) / 2;
        int arrowY = 158;
        this.buttonPreviousPage = (NextPageButton)this.func_189646_b(new NextPageButton(2, arrowX + 18, 158, false));
        this.buttonNextPage = (NextPageButton)this.func_189646_b(new NextPageButton(1, arrowX + 256 - 36, 158, true));
        int blockX = (this.field_146294_l - 256) / 2 + 12 + 4;
        int blockY = 28;
        this.buttonBlockLeft = (BlockButton)this.func_189646_b(new BlockButton(3, this, new Block[0], blockX, blockY, 1.6f));
        blockX = this.field_146294_l / 2 + 12;
        this.buttonBlockRight = (BlockButton)this.func_189646_b(new BlockButton(4, this, new Block[0], blockX, blockY, 1.6f));
        for (int i = 0; i < 5; ++i) {
            this.tableOfContents[i] = (GolemEntryButton)this.func_189646_b(new GolemEntryButton(5 + i, this, ALPHABETICAL.get(i), this.field_146294_l / 2 + 12, 40 + 22 * i));
        }
        this.updateButtons();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        int bookX = (this.field_146294_l - 256) / 2;
        int bookY = 16;
        this.func_73729_b(bookX, bookY, 0, 0, 256, 164);
        this.drawPageAt(bookX + 1, bookY, this.curPage);
        this.drawPageAt(bookX + 128 - 2, bookY, this.curPage + 1);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (GuiGolemBook.isPageGolemEntry(this.curPage, this.totalPages) && this.buttonBlockLeft.func_146115_a()) {
            this.buttonBlockLeft.drawHoveringCaption(mouseX, mouseY);
        }
        if (GuiGolemBook.isPageGolemEntry(this.curPage + 1, this.totalPages) && this.buttonBlockRight.func_146115_a()) {
            this.buttonBlockRight.drawHoveringCaption(mouseX, mouseY);
        }
    }

    private void drawPageAt(int cornerX, int cornerY, int pageNum) {
        this.drawPageNum(cornerX, cornerY, pageNum + 1);
        switch (pageNum) {
            case 0: {
                String title = GuiGolemBook.trans("item.info_book.name", new Object[0]);
                String body = GuiGolemBook.trans("golembook.intro1", new Object[0]) + "\n" + GuiGolemBook.trans("golembook.intro2", new Object[0]);
                this.drawBasicPage(cornerX, cornerY, title, body);
                return;
            }
            case 1: {
                String title = GuiGolemBook.trans("golembook.contents.title", new Object[0]);
                this.drawBasicPage(cornerX, cornerY, title, "");
                this.field_146297_k.func_110434_K().func_110577_a(CONTENTS);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int startX = cornerX + 12 + 1;
                int startY = cornerY + 24 - 1;
                this.func_73729_b(startX, startY, 0, 0, 106, 112);
                startX = GuiGolemBook.getScrollX(this.field_146294_l) - 2;
                startY = GuiGolemBook.getScrollY(this.currentScroll);
                this.func_73729_b(startX, startY, this.isScrolling ? 17 : 0, 115, 12, 15);
                if (this.isScrolling) {
                    GolemBookEntry[] visibleArray = GuiGolemBook.getGolemEntriesForScroll(this.currentScroll);
                    int l = this.tableOfContents.length;
                    for (int i = 0; i < l; ++i) {
                        this.tableOfContents[i].setEntry(visibleArray[i]);
                    }
                }
                return;
            }
            case 2: {
                String title = TextFormatting.func_110646_a((String)GuiGolemBook.trans("item.golem_paper.name", new Object[0]));
                String body = "\n\n\n\n" + I18n.func_135052_a((String)"golembook.recipe_spell.recipe", (Object[])new Object[]{title, GuiGolemBook.trans("item.paper.name", new Object[0]), GuiGolemBook.trans("item.feather.name", new Object[0]), GuiGolemBook.trans("item.dyePowder.black.name", new Object[0]), GuiGolemBook.trans("item.redstone.name", new Object[0])});
                this.drawBasicPage(cornerX, cornerY, title, body);
                this.draw2x2GridAt(cornerX + 24, cornerY + 24, ingredientsSpell, outputSpell);
                return;
            }
            case 3: {
                String title = GuiGolemBook.trans("tile.golem_head.name", new Object[0]);
                String body = "\n\n\n\n" + TextFormatting.func_110646_a((String)GuiGolemBook.trans("golembook.recipe_head.recipe", title, GuiGolemBook.trans("item.golem_paper.name", new Object[0]), GuiGolemBook.trans("tile.pumpkin.name", new Object[0])));
                this.drawBasicPage(cornerX, cornerY, title, body);
                this.draw2x2GridAt(cornerX + 24, cornerY + 24, ingredientsHead, outputHead);
                return;
            }
            case 4: {
                String title = GuiGolemBook.trans("golembook.build_golem.title", new Object[0]);
                String body = GuiGolemBook.trans("golembook.build_golem.howto1", new Object[0]) + " " + GuiGolemBook.trans("golembook.build_golem.howto2", new Object[0]) + "\n\n" + I18n.func_135052_a((String)"golembook.build_golem.howto3", (Object[])new Object[]{GuiGolemBook.trans("tile.golem_head.name", new Object[0])});
                this.drawBasicPage(cornerX, cornerY, title, body);
                return;
            }
            case 5: {
                Block golemBody = Blocks.field_150339_S;
                Block golemHead = GolemItems.golemHead;
                float scale = 2.0f;
                int blockW = (int)(8.0f * scale);
                int startX = cornerX + 32;
                int startY = cornerY + blockW;
                this.drawBlock(golemHead, startX, startY, scale);
                this.drawBlock(golemBody, startX, startY += blockW * 4, scale);
                this.drawBlock(golemBody, startX += blockW * 2, startY -= blockW * 5 / 2, scale);
                this.drawBlock(golemBody, startX -= blockW * 2, startY += blockW / 2, scale);
                this.drawBlock(golemBody, startX -= blockW * 2, startY += blockW / 2, scale);
                return;
            }
        }
        if (GuiGolemBook.isPageGolemEntry(pageNum, this.totalPages)) {
            GolemBookEntry entry = GuiGolemBook.getGolemEntryForPage(pageNum);
            this.drawGolemEntry(cornerX, cornerY, entry);
        }
    }

    private void drawPageNum(int cornerX, int cornerY, int pageNum) {
        boolean isLeft = pageNum % 2 == 1;
        int numX = isLeft ? this.field_146294_l / 2 - 12 : this.field_146294_l / 2 + 12;
        int numY = cornerY + 164 - 22;
        String pageNumLeft = String.valueOf(pageNum);
        int sWidth = isLeft ? this.field_146289_q.func_78256_a(pageNumLeft) : 0;
        this.field_146289_q.func_78276_b(pageNumLeft, numX - sWidth, numY, 0);
    }

    protected void drawBlock(Block blockIn, int cornerX, int cornerY, float scale) {
        Block block = blockIn != Blocks.field_150350_a ? blockIn : Blocks.field_180401_cv;
        float blockX = cornerX + 12 + 4;
        float blockY = cornerY + 12;
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        RenderHelper.func_74520_c();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        this.field_146296_j.func_175042_a(new ItemStack(block), (int)(blockX / scale), (int)(blockY / scale));
        GlStateManager.func_179121_F();
    }

    private void drawGolemEntry(int cornerX, int cornerY, GolemBookEntry entry) {
        int nameX = cornerX + 48;
        int nameY = cornerY + 12;
        String golemName = entry.getGolemName();
        this.field_146289_q.func_78279_b(golemName, nameX, nameY, 68, 0);
        int statsX = cornerX + 12;
        int statsY = nameY + 24;
        String stats = entry.getDescriptionPage();
        this.field_146289_q.func_78279_b(stats, statsX, statsY, 104, 0);
        if (entry.hasImage()) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float scale = 0.9f;
            int imgX = cornerX + 64 - (int)(100.0f * scale / 2.0f);
            int imgY = cornerY + 164 - (int)(50.0f * scale) - 24;
            this.field_146297_k.func_110434_K().func_110577_a(entry.getImageResource());
            int w = (int)(100.0f * scale);
            int h = (int)(50.0f * scale);
            GuiGolemBook.func_146110_a((int)imgX, (int)imgY, (float)0.0f, (float)0.0f, (int)w, (int)h, (float)w, (float)h);
        }
    }

    private void drawBasicPage(int cornerX, int cornerY, String title, String body) {
        int maxWidth = 104;
        int titleX = cornerX + 12 + 4;
        int titleY = cornerY + 12;
        int sWidth = this.field_146289_q.func_78256_a(title);
        if (sWidth > 104) {
            this.field_146289_q.func_78279_b(title, titleX, titleY, 104, 0);
        } else {
            this.field_146289_q.func_78276_b(title, titleX + (104 - sWidth) / 2, titleY, 0);
        }
        int bodyX = titleX;
        int bodyY = titleY + 24;
        this.field_146289_q.func_78279_b(body, bodyX, bodyY, 104, 0);
    }

    private void draw2x2GridAt(int startX, int startY, ItemStack[] ingredients, ItemStack result) {
        float posY;
        float posX;
        int frameWidth = 3;
        float scale = 1.0f;
        int gridW = 84;
        int gridH = 46;
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(startX, startY, 172, 169, 84, 46);
        GlStateManager.func_179091_B();
        RenderHelper.func_74520_c();
        int iconW = 15;
        switch (ingredients.length) {
            case 4: {
                posX = (float)(startX + iconW) + 9.0f;
                posY = (float)(startY + iconW) + 9.0f;
                this.field_146296_j.func_175042_a(ingredients[3], (int)(posX / 1.0f), (int)(posY / 1.0f));
            }
            case 3: {
                posX = (float)startX + 6.0f;
                posY = (float)(startY + iconW) + 9.0f;
                this.field_146296_j.func_175042_a(ingredients[2], (int)(posX / 1.0f), (int)(posY / 1.0f));
            }
            case 2: {
                posX = (float)(startX + iconW) + 9.0f;
                posY = (float)startY + 6.0f;
                this.field_146296_j.func_175042_a(ingredients[1], (int)(posX / 1.0f), (int)(posY / 1.0f));
            }
            case 1: {
                posX = (float)startX + 6.0f;
                posY = (float)startY + 6.0f;
                this.field_146296_j.func_175042_a(ingredients[0], (int)(posX / 1.0f), (int)(posY / 1.0f));
            }
        }
        posX = (float)(startX + 84) - 16.0f - 6.0f;
        posY = (float)startY + 16.0f;
        this.field_146296_j.func_175042_a(result, (int)(posX / 1.0f), (int)(posY / 1.0f));
        GlStateManager.func_179121_F();
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (GuiGolemBook.isPageTableContents(this.curPage)) {
            int mouseYCentered = mouseY - 7;
            if (this.isMouseOverScroll(mouseX, mouseYCentered)) {
                this.isScrolling = true;
                if (mouseYCentered < 150 && mouseYCentered >= 40) {
                    this.currentScroll = GuiGolemBook.getScrollFloat(mouseY - 7);
                }
            } else {
                this.isScrolling = false;
            }
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.isScrolling = false;
    }

    public void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        switch (button.field_146127_k) {
            case 0: {
                this.field_146297_k.func_147108_a((GuiScreen)null);
                return;
            }
            case 1: {
                this.curPage += 2;
                break;
            }
            case 2: {
                this.curPage -= 2;
                break;
            }
            default: {
                GolemBookEntry entry;
                int index;
                if (button.field_146127_k < 5 || button.field_146127_k >= 10 || !(button instanceof GolemEntryButton) || (index = GOLEMS.indexOf(entry = ((GolemEntryButton)button).entry)) < 0 || index > GOLEMS.size()) break;
                int page = index + 6;
                this.curPage = page = Math.floorDiv(page, 2) * 2;
            }
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.buttonBlockLeft.field_146125_m = GuiGolemBook.isPageGolemEntry(this.curPage, this.totalPages);
        this.buttonBlockRight.field_146125_m = GuiGolemBook.isPageGolemEntry(this.curPage + 1, this.totalPages);
        this.buttonPreviousPage.field_146125_m = this.curPage > 0;
        this.buttonNextPage.field_146125_m = this.curPage + 2 < this.totalPages;
        boolean tableContentsVisible = GuiGolemBook.isPageTableContents(this.curPage);
        for (GolemEntryButton b : this.tableOfContents) {
            b.field_146125_m = tableContentsVisible;
        }
        if (GuiGolemBook.isPageGolemEntry(this.curPage, this.totalPages)) {
            this.buttonBlockLeft.field_146125_m = true;
            this.buttonBlockLeft.updateBlocks(GuiGolemBook.getGolemEntryForPage(this.curPage).getBlocks());
        } else {
            this.buttonBlockLeft.field_146125_m = false;
        }
        if (GuiGolemBook.isPageGolemEntry(this.curPage + 1, this.totalPages)) {
            this.buttonBlockRight.field_146125_m = true;
            this.buttonBlockRight.updateBlocks(GuiGolemBook.getGolemEntryForPage(this.curPage + 1).getBlocks());
        } else {
            this.buttonBlockRight.field_146125_m = false;
        }
    }

    private boolean isMouseOverScroll(int mouseX, int mouseY) {
        int scrollStartX = GuiGolemBook.getScrollX(this.field_146294_l);
        int scrollStartY = 40;
        return mouseX >= scrollStartX && mouseY >= scrollStartY && mouseX < scrollStartX + 12 && mouseY < scrollStartY + 110 - 7;
    }

    private static int getScrollX(int screenWidth) {
        return screenWidth / 2 + 12 + 106 - 12;
    }

    private static int getScrollY(float scroll) {
        float f = Math.max(0.0f, Math.min(1.0f, scroll));
        return 40 + (int)(f * 95.0f);
    }

    private static float getScrollFloat(int currentY) {
        int minY = 40;
        int maxY = 135;
        float f = Math.max(40, Math.min(135, currentY)) - 40;
        return f / 95.0f;
    }

    private static boolean isPageGolemEntry(int page, int total) {
        return page >= 6 && page < total;
    }

    private static boolean isPageTableContents(int page) {
        return page >= 0 && page < 2;
    }

    private static GolemBookEntry getGolemEntryForPage(int page) {
        return GOLEMS.get(page - 6);
    }

    private static GolemBookEntry[] getGolemEntriesForScroll(float scrollIn) {
        float scroll = MathHelper.func_76131_a((float)scrollIn, (float)0.0f, (float)1.0f);
        int i = (int)(scroll * (float)(ALPHABETICAL.size() - 5));
        return ALPHABETICAL.subList(i, i + 5).toArray(new GolemBookEntry[5]);
    }

    protected static String trans(String s, Object ... strings) {
        return I18n.func_135052_a((String)s, (Object[])strings);
    }

    protected static class NextPageButton
    extends GuiButton {
        protected static final int TEXTURE_STARTY = 169;
        private final boolean isForward;

        public NextPageButton(int buttonId, int x, int y, boolean isForwardIn) {
            super(buttonId, x, y, 18, 15, "");
            this.isForward = isForwardIn;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean mouseOver = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(TEXTURE);
                int tx = 0;
                int ty = 169;
                if (mouseOver) {
                    tx += 23;
                }
                if (!this.isForward) {
                    ty += 15;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, tx, ty, 18, 15);
            }
        }
    }

    protected static class GolemEntryButton
    extends GuiButton {
        private final GuiGolemBook gui;
        private GolemBookEntry entry;

        public GolemEntryButton(int buttonId, GuiGolemBook guiIn, GolemBookEntry entryIn, int x, int y) {
            super(buttonId, x, y, 88, 22, "");
            this.gui = guiIn;
            this.entry = entryIn;
        }

        public void setEntry(GolemBookEntry toSet) {
            this.entry = toSet;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                mc.func_110434_K().func_110577_a(CONTENTS);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, 111, this.field_146123_n ? 27 : 0, 88, 22);
                this.gui.drawBlock(this.entry.getBlock(0), this.field_146128_h - 12 - 2, this.field_146129_i - 9, 1.0f);
                GlStateManager.func_179094_E();
                String name = this.entry.getGolemName();
                int wrap = this.field_146120_f - 20;
                float scale = 1.0f;
                int nameH = this.gui.field_146289_q.func_78267_b(name, wrap);
                if (nameH > this.field_146121_g) {
                    scale = 0.7f;
                    nameH = (int)(scale * (float)this.gui.field_146289_q.func_78267_b(name, (int)((float)wrap / scale)));
                }
                int nameX = this.field_146128_h + 20;
                int nameY = this.field_146129_i + (this.field_146121_g - nameH) / 2 + 1;
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                this.gui.field_146289_q.func_78279_b(name, (int)((float)nameX / scale), (int)((float)nameY / scale), (int)((float)wrap / scale), 0);
                GlStateManager.func_179121_F();
            }
        }
    }

    protected static class BlockButton
    extends GuiButton {
        private float scale;
        private Block[] blocks;
        private Block currentBlock;
        private final GuiGolemBook gui;

        public BlockButton(int buttonId, GuiGolemBook guiIn, Block[] blockValues, int x, int y, float scaleIn) {
            super(buttonId, x, y, (int)(scaleIn * 16.0f), (int)(scaleIn * 16.0f), "");
            this.gui = guiIn;
            this.blocks = blockValues;
            this.scale = scaleIn;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                this.gui.drawBlock(this.currentBlock, this.field_146128_h - 12 - 4, this.field_146129_i - 12, this.scale);
            }
        }

        public void updateBlocks(Block[] blocksToDraw) {
            this.blocks = blocksToDraw;
            this.currentBlock = this.blocks != null && this.blocks.length > 0 ? this.blocks[0] : Blocks.field_150350_a;
        }

        public boolean drawHoveringCaption(int mouseX, int mouseY) {
            if (this.currentBlock != Blocks.field_150350_a) {
                this.gui.func_146279_a(this.currentBlock.func_149732_F(), mouseX, mouseY);
                return true;
            }
            return false;
        }
    }
}

