/*
 * Decompiled with CFR 0.152.
 */
package com.golems.integration;

import com.golems.entity.EntityBedrockGolem;
import com.golems.entity.EntityRedstoneLampGolem;
import com.golems.entity.GolemBase;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;

public abstract class GolemDescriptionManager {
    protected boolean showSpecial = true;
    protected boolean showMultiTexture = true;
    protected boolean showAttack = true;
    protected boolean showFireproof = true;
    protected boolean showKnockbackResist = false;
    protected boolean showHealItems = false;

    public List<String> getEntityDescription(GolemBase golem) {
        LinkedList<String> list = new LinkedList<String>();
        if (this.showAttack) {
            float attackAmount = (float)golem.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b();
            list.add(TextFormatting.GRAY + GolemDescriptionManager.trans("entitytip.attack", new Object[0]) + " : " + TextFormatting.WHITE + attackAmount);
        }
        if (this.showMultiTexture && golem.doesInteractChangeTexture() && !(golem instanceof EntityRedstoneLampGolem)) {
            list.add(TextFormatting.BLUE + GolemDescriptionManager.trans("entitytip.click_change_texture", new Object[0]));
        }
        if (this.showFireproof && golem.func_70045_F() && !(golem instanceof EntityBedrockGolem)) {
            list.add(TextFormatting.GOLD + GolemDescriptionManager.trans("entitytip.is_fireproof", new Object[0]));
        }
        if (this.showKnockbackResist && golem.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111125_b() > 0.8999) {
            String sResist = TextFormatting.GRAY + GolemDescriptionManager.trans("attribute.name.generic.knockbackResistance", new Object[0]);
            list.add(sResist);
        }
        if (this.showHealItems) {
            list.add(TextFormatting.RED + GolemDescriptionManager.trans("entitytip.heal_items", new Object[0]));
            HashSet<String> set = new HashSet<String>();
            String prefix = TextFormatting.RED + "\u2764" + TextFormatting.GRAY + " ";
            for (ItemStack s : golem.getHealItems()) {
                if (s.func_77960_j() == Short.MAX_VALUE) {
                    Item i = s.func_77973_b();
                    NonNullList subItems = NonNullList.func_191196_a();
                    i.func_150895_a(i.func_77640_w(), subItems);
                    for (ItemStack s2 : subItems) {
                        set.add(prefix + i.func_77653_i(s2));
                    }
                    continue;
                }
                set.add(prefix + s.func_82833_r());
            }
            list.addAll(set);
        }
        if (this.showSpecial) {
            golem.addSpecialDesc(list);
        }
        return list;
    }

    protected static String trans(String s, Object ... strings) {
        return I18n.func_135052_a((String)s, (Object[])strings);
    }
}

