/*
 * Decompiled with CFR 0.152.
 */
package com.golems.proxies;

import com.golems.blocks.BlockGolemHead;
import com.golems.blocks.BlockUtilityGlow;
import com.golems.blocks.BlockUtilityGlowWater;
import com.golems.blocks.BlockUtilityPower;
import com.golems.entity.EntityBedrockGolem;
import com.golems.entity.EntityBoneGolem;
import com.golems.entity.EntityBookshelfGolem;
import com.golems.entity.EntityClayGolem;
import com.golems.entity.EntityCoalGolem;
import com.golems.entity.EntityConcreteGolem;
import com.golems.entity.EntityCraftingGolem;
import com.golems.entity.EntityDiamondGolem;
import com.golems.entity.EntityDispenserGolem;
import com.golems.entity.EntityEmeraldGolem;
import com.golems.entity.EntityEndstoneGolem;
import com.golems.entity.EntityFurnaceGolem;
import com.golems.entity.EntityGlassGolem;
import com.golems.entity.EntityGlowstoneGolem;
import com.golems.entity.EntityGoldGolem;
import com.golems.entity.EntityHardenedClayGolem;
import com.golems.entity.EntityIceGolem;
import com.golems.entity.EntityLapisGolem;
import com.golems.entity.EntityLeafGolem;
import com.golems.entity.EntityMagmaGolem;
import com.golems.entity.EntityMelonGolem;
import com.golems.entity.EntityMushroomGolem;
import com.golems.entity.EntityNetherBrickGolem;
import com.golems.entity.EntityNetherWartGolem;
import com.golems.entity.EntityObsidianGolem;
import com.golems.entity.EntityPrismarineGolem;
import com.golems.entity.EntityQuartzGolem;
import com.golems.entity.EntityRedSandstoneGolem;
import com.golems.entity.EntityRedstoneGolem;
import com.golems.entity.EntityRedstoneLampGolem;
import com.golems.entity.EntitySandstoneGolem;
import com.golems.entity.EntitySeaLanternGolem;
import com.golems.entity.EntitySlimeGolem;
import com.golems.entity.EntitySpongeGolem;
import com.golems.entity.EntityStainedClayGolem;
import com.golems.entity.EntityStainedGlassGolem;
import com.golems.entity.EntityStrawGolem;
import com.golems.entity.EntityTNTGolem;
import com.golems.entity.EntityWoodenGolem;
import com.golems.entity.EntityWoolGolem;
import com.golems.entity.GolemBase;
import com.golems.entity.GolemColorized;
import com.golems.entity.GolemMultiTextured;
import com.golems.events.handlers.GolemCommonEventHandler;
import com.golems.items.ItemBedrockGolem;
import com.golems.items.ItemGolemSpell;
import com.golems.items.ItemInfoBook;
import com.golems.main.GolemItems;
import com.golems.util.GolemLookup;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="golems")
public class CommonProxy {
    public static final List<GolemBase> DUMMY_GOLEMS = new LinkedList<GolemBase>();
    protected static int golemEntityCount;

    public void preInitRenders() {
    }

    public void registerEvents() {
        MinecraftForge.EVENT_BUS.register((Object)new GolemCommonEventHandler());
    }

    protected static EntityEntry build(Class<? extends GolemBase> entityClass, String name, Block ... blocks) {
        return CommonProxy.build(entityClass, name, true, blocks);
    }

    protected static EntityEntry build(Class<? extends GolemBase> entityClass, String name, boolean lootTable, Block ... blocks) {
        if (blocks != null && blocks.length > 0) {
            GolemLookup.addGolem(entityClass, blocks);
        }
        EntityEntryBuilder builder = EntityEntryBuilder.create();
        builder.entity(entityClass);
        builder.name("golems." + name);
        builder.id(new ResourceLocation("golems", name), ++golemEntityCount);
        builder.tracker(48, 3, true);
        if (lootTable && !GolemColorized.class.isAssignableFrom(entityClass) && !GolemMultiTextured.class.isAssignableFrom(entityClass)) {
            LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("golems", "entities/" + name));
        }
        return builder.build();
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        golemEntityCount = 0;
        event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityEntry[]{CommonProxy.build(EntityBedrockGolem.class, "golem_bedrock", false, new Block[]{null}), CommonProxy.build(EntityBoneGolem.class, "golem_bone", Blocks.field_189880_di), CommonProxy.build(EntityBookshelfGolem.class, "golem_bookshelf", Blocks.field_150342_X), CommonProxy.build(EntityClayGolem.class, "golem_clay", Blocks.field_150435_aG), CommonProxy.build(EntityCoalGolem.class, "golem_coal", Blocks.field_150402_ci), CommonProxy.build(EntityConcreteGolem.class, "golem_concrete", Blocks.field_192443_dR), CommonProxy.build(EntityCraftingGolem.class, "golem_crafting", Blocks.field_150462_ai), CommonProxy.build(EntityDiamondGolem.class, "golem_diamond", Blocks.field_150484_ah), CommonProxy.build(EntityDispenserGolem.class, "golem_dispenser", Blocks.field_150367_z), CommonProxy.build(EntityEmeraldGolem.class, "golem_emerald", Blocks.field_150475_bE), CommonProxy.build(EntityEndstoneGolem.class, "golem_end_stone", Blocks.field_150377_bs), CommonProxy.build(EntityFurnaceGolem.class, "golem_furnace", Blocks.field_150460_al, Blocks.field_150470_am), CommonProxy.build(EntityGlassGolem.class, "golem_glass", Blocks.field_150359_w), CommonProxy.build(EntityGlowstoneGolem.class, "golem_glowstone", Blocks.field_150426_aN), CommonProxy.build(EntityGoldGolem.class, "golem_gold", Blocks.field_150340_R), CommonProxy.build(EntityHardenedClayGolem.class, "golem_hardened_clay", Blocks.field_150405_ch), CommonProxy.build(EntityIceGolem.class, "golem_ice", Blocks.field_150403_cj, Blocks.field_150432_aD), CommonProxy.build(EntityLapisGolem.class, "golem_lapis", Blocks.field_150368_y), CommonProxy.build(EntityLeafGolem.class, "golem_leaves", new Block[]{Blocks.field_150362_t, Blocks.field_150361_u}), CommonProxy.build(EntityMagmaGolem.class, "golem_magma", Blocks.field_189877_df), CommonProxy.build(EntityMelonGolem.class, "golem_melon", Blocks.field_150440_ba), CommonProxy.build(EntityMushroomGolem.class, "golem_shroom", Blocks.field_150419_aX, Blocks.field_150420_aW), CommonProxy.build(EntityNetherBrickGolem.class, "golem_nether_brick", Blocks.field_150385_bj, Blocks.field_189879_dh), CommonProxy.build(EntityNetherWartGolem.class, "golem_nether_wart", Blocks.field_189878_dg), CommonProxy.build(EntityObsidianGolem.class, "golem_obsidian", Blocks.field_150343_Z), CommonProxy.build(EntityPrismarineGolem.class, "golem_prismarine", Blocks.field_180397_cI), CommonProxy.build(EntityQuartzGolem.class, "golem_quartz", Blocks.field_150371_ca), CommonProxy.build(EntityRedSandstoneGolem.class, "golem_red_sandstone", Blocks.field_180395_cM), CommonProxy.build(EntityRedstoneGolem.class, "golem_redstone", Blocks.field_150451_bX), CommonProxy.build(EntityRedstoneLampGolem.class, "golem_redstone_lamp", Blocks.field_150379_bu, Blocks.field_150374_bv), CommonProxy.build(EntitySandstoneGolem.class, "golem_sandstone", Blocks.field_150322_A), CommonProxy.build(EntitySeaLanternGolem.class, "golem_sea_lantern", Blocks.field_180398_cJ), CommonProxy.build(EntitySlimeGolem.class, "golem_slime", Blocks.field_180399_cE), CommonProxy.build(EntitySpongeGolem.class, "golem_sponge", Blocks.field_150360_v), CommonProxy.build(EntityStainedClayGolem.class, "golem_stained_clay", Blocks.field_150406_ce), CommonProxy.build(EntityStainedGlassGolem.class, "golem_stained_glass", new Block[]{Blocks.field_150399_cn}), CommonProxy.build(EntityStrawGolem.class, "golem_straw", Blocks.field_150407_cf), CommonProxy.build(EntityTNTGolem.class, "golem_tnt", Blocks.field_150335_W), CommonProxy.build(EntityWoodenGolem.class, "golem_wooden", Blocks.field_150364_r, Blocks.field_150363_s), CommonProxy.build(EntityWoolGolem.class, "golem_wool", Blocks.field_150325_L)});
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("golems", "entities/_golem_base"));
        CommonProxy.registerLootTables("golems", "golem_wool", EntityWoolGolem.coloredWoolTypes);
        CommonProxy.registerLootTables("golems", "golem_wooden", EntityWoodenGolem.woodTypes);
        CommonProxy.registerLootTables("golems", "golem_shroom", EntityMushroomGolem.SHROOM_TYPES);
        CommonProxy.registerLootTables("golems", "golem_redstone_lamp", EntityRedstoneLampGolem.VARIANTS);
        CommonProxy.registerLootTables("golems", "golem_concrete", EntityConcreteGolem.COLOR_ARRAY.length);
        CommonProxy.registerLootTables("golems", "golem_stained_glass", EntityStainedGlassGolem.COLOR_ARRAY.length);
        CommonProxy.registerLootTables("golems", "golem_stained_clay", EntityStainedClayGolem.COLOR_ARRAY.length);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().register(new ItemBlock(GolemItems.golemHead){

            @SideOnly(value=Side.CLIENT)
            public boolean func_77636_d(ItemStack stack) {
                return true;
            }
        }.setRegistryName(GolemItems.golemHead.getRegistryName()));
        event.getRegistry().register(new ItemBedrockGolem().func_77655_b("spawn_bedrock_golem").setRegistryName("golems", "spawn_bedrock_golem"));
        event.getRegistry().register(new ItemGolemSpell().func_77655_b("golem_paper").setRegistryName("golems", "golem_paper"));
        event.getRegistry().register(new ItemInfoBook().func_77655_b("info_book").setRegistryName("golems", "info_book"));
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        int GLOWSTONE_FREQ = GolemLookup.getConfig(EntityGlowstoneGolem.class).getInt("Light Frequency");
        int SEALANTERN_FREQ = GolemLookup.getConfig(EntitySeaLanternGolem.class).getInt("Light Frequency");
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{(Block)new BlockGolemHead().func_149663_c("golem_head").setRegistryName("golems", "golem_head"), (Block)new BlockUtilityGlow(Material.field_151592_s, 1.0f, GLOWSTONE_FREQ, Blocks.field_150350_a.func_176223_P()).func_149663_c("light_provider_full").setRegistryName("golems", "light_provider_full"), (Block)new BlockUtilityGlowWater(Material.field_151586_h, 1.0f, SEALANTERN_FREQ, Blocks.field_150355_j.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(0))).func_149663_c("water_light_provider_full").setRegistryName("golems", "water_light_provider_full"), (Block)new BlockUtilityPower(15, 2).func_149663_c("power_provider_all").setRegistryName("golems", "power_provider_all")});
    }

    public static void registerLootTables(String MODID, String name, String[] textures) {
        for (String s : textures) {
            LootTableList.func_186375_a((ResourceLocation)new ResourceLocation(MODID, "entities/" + name + "/" + s));
        }
    }

    public static void registerLootTables(String MODID, String name, int max) {
        String[] array = new String[max];
        for (int i = 0; i < max; ++i) {
            array[i] = Integer.toString(i);
        }
        CommonProxy.registerLootTables(MODID, name, array);
    }
}

