/*
 * Decompiled with CFR 0.152.
 */
package com.golems.util;

import com.golems.entity.GolemBase;
import com.golems.main.Config;
import com.golems.main.ExtraGolems;
import com.golems.util.GolemConfigSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityList;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IRegistryDelegate;

public final class GolemLookup {
    private static final Map<IRegistryDelegate<Block>, Class<? extends GolemBase>> BLOCK_TO_GOLEM = new HashMap<IRegistryDelegate<Block>, Class<? extends GolemBase>>();
    private static final Map<Class<? extends GolemBase>, Set<IRegistryDelegate<Block>>> GOLEM_TO_BLOCK = new HashMap<Class<? extends GolemBase>, Set<IRegistryDelegate<Block>>>();
    private static final Map<Class<? extends GolemBase>, GolemConfigSet> GOLEM_TO_CONFIG = new HashMap<Class<? extends GolemBase>, GolemConfigSet>();

    private GolemLookup() {
    }

    public static boolean addBlockAlias(@Nonnull Block buildingBlock, Class<? extends GolemBase> golemClazz) {
        return GolemLookup.addBlockToGolemMapping(buildingBlock, golemClazz);
    }

    private static boolean addBlockToGolemMapping(@Nonnull Block buildingBlock, @Nonnull Class<? extends GolemBase> golemClazz) {
        if (BLOCK_TO_GOLEM.containsKey(buildingBlock.delegate)) {
            ExtraGolems.LOGGER.warn("Tried to associate Block " + buildingBlock + " with a Golem but Block has already been added! Skipping.");
            return false;
        }
        BLOCK_TO_GOLEM.put((IRegistryDelegate<Block>)buildingBlock.delegate, golemClazz);
        return true;
    }

    private static boolean addGolemToBlockMapping(@Nonnull Class<? extends GolemBase> golemClazz, Block ... buildingBlocks) {
        if (buildingBlocks != null && buildingBlocks.length > 0) {
            HashSet<IRegistryDelegate> blocks = new HashSet<IRegistryDelegate>();
            for (Block b : buildingBlocks) {
                if (b == null) continue;
                blocks.add(b.delegate);
            }
            if (GOLEM_TO_BLOCK.containsKey(golemClazz)) {
                GOLEM_TO_BLOCK.get(golemClazz).addAll(blocks);
            } else {
                GOLEM_TO_BLOCK.put(golemClazz, blocks);
            }
            return true;
        }
        return false;
    }

    public static boolean addGolem(@Nonnull Class<? extends GolemBase> golemClazz, Block ... buildingBlock) {
        boolean success = true;
        if (buildingBlock != null && buildingBlock.length > 0 && buildingBlock[0] != null) {
            success = GolemLookup.addBlockToGolemMapping(buildingBlock[0], golemClazz);
        }
        return success &= GolemLookup.addGolemToBlockMapping(golemClazz, buildingBlock);
    }

    public static boolean addConfig(Class<? extends GolemBase> golemClazz, GolemConfigSet config) {
        if (GOLEM_TO_CONFIG.containsKey(golemClazz)) {
            ExtraGolems.LOGGER.warn("Tried to add a Config for " + golemClazz.getName() + " but Golem already has one! Skipping.");
            return false;
        }
        GOLEM_TO_CONFIG.put(golemClazz, config);
        return true;
    }

    @Nullable
    public static GolemBase getGolem(World world, Block block) {
        Class<? extends GolemBase> clazz = GolemLookup.getGolemClass(block);
        if (clazz != null) {
            return (GolemBase)EntityList.func_191304_a(clazz, (World)world);
        }
        return null;
    }

    @Nullable
    private static Class<? extends GolemBase> getGolemClass(Block block) {
        if (block == null) {
            ExtraGolems.LOGGER.error("Can't make a golem with a null block!");
            return null;
        }
        if (BLOCK_TO_GOLEM.containsKey(block.delegate)) {
            return BLOCK_TO_GOLEM.get(block.delegate);
        }
        if (Config.getUseOreDictBlocks()) {
            for (Block b : GolemLookup.getOreDictMatches(block)) {
                if (b == null || !BLOCK_TO_GOLEM.containsKey(b.delegate)) continue;
                return BLOCK_TO_GOLEM.get(b.delegate);
            }
        } else {
            ExtraGolems.LOGGER.error("Tried to make a golem with an unknown block: " + block.getRegistryName());
        }
        return null;
    }

    @Nonnull
    public static Block[] getBuildingBlocks(Class<? extends GolemBase> golemClazz) {
        if (golemClazz == null) {
            ExtraGolems.LOGGER.error("Can't get a block from a null golem!");
            return new Block[0];
        }
        if (GOLEM_TO_BLOCK.containsKey(golemClazz)) {
            IRegistryDelegate[] blockSet = GOLEM_TO_BLOCK.get(golemClazz).toArray(new IRegistryDelegate[0]);
            Block[] blocks = new Block[blockSet.length];
            int l = blockSet.length;
            for (int i = 0; i < l; ++i) {
                blocks[i] = (Block)blockSet[i].get();
            }
            return blocks;
        }
        ExtraGolems.LOGGER.error("Tried to get blocks for an unknown golem: " + golemClazz.getName());
        return new Block[0];
    }

    @Nullable
    public static Block getFirstBuildingBlock(Class<? extends GolemBase> golemClazz) {
        if (golemClazz == null) {
            ExtraGolems.LOGGER.error("Can't get a block from a null golem!");
            return null;
        }
        if (GOLEM_TO_BLOCK.containsKey(golemClazz)) {
            Block[] blocks = GolemLookup.getBuildingBlocks(golemClazz);
            return blocks != null && blocks.length > 0 ? blocks[0] : null;
        }
        ExtraGolems.LOGGER.error("Tried to get a block for an unknown golem: " + golemClazz.getName());
        return null;
    }

    public static boolean isBuildingBlock(Block block) {
        if (block != null && BLOCK_TO_GOLEM.containsKey(block.delegate) && BLOCK_TO_GOLEM.get(block.delegate) != null) {
            return true;
        }
        if (Config.getUseOreDictBlocks()) {
            Block[] matches;
            for (Block b : matches = GolemLookup.getOreDictMatches(block)) {
                if (b == null || !BLOCK_TO_GOLEM.containsKey(b.delegate) || BLOCK_TO_GOLEM.get(b.delegate) == null) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasBuildingBlock(Class<? extends GolemBase> golemClazz) {
        return golemClazz != null && GOLEM_TO_BLOCK.containsKey(golemClazz) && GOLEM_TO_BLOCK.get(golemClazz) != null;
    }

    @Nullable
    public static GolemConfigSet getConfig(Class<? extends GolemBase> golemClazz) {
        if (golemClazz == null) {
            ExtraGolems.LOGGER.error("Can't get config file for a null golem!");
            return null;
        }
        if (GOLEM_TO_CONFIG.containsKey(golemClazz)) {
            return GOLEM_TO_CONFIG.get(golemClazz);
        }
        ExtraGolems.LOGGER.error("Tried to get config file for unknown golem!");
        return null;
    }

    public static boolean hasConfig(Class<? extends GolemBase> golemClazz) {
        return golemClazz != null && GOLEM_TO_CONFIG.containsKey(golemClazz) && GOLEM_TO_CONFIG.get(golemClazz) != null;
    }

    public static Set<IRegistryDelegate<Block>> getBlockSet() {
        return BLOCK_TO_GOLEM.keySet();
    }

    public static Set<Class<? extends GolemBase>> getGolemSet() {
        return GOLEM_TO_BLOCK.keySet();
    }

    public static List<GolemBase> getDummyGolemList(World world) {
        LinkedList<GolemBase> list = new LinkedList<GolemBase>();
        for (EntityEntry entry : ForgeRegistries.ENTITIES) {
            if (!GolemBase.class.isAssignableFrom(entry.getEntityClass())) continue;
            list.add((GolemBase)entry.newInstance(world));
        }
        return list;
    }

    @Nonnull
    private static Block[] getOreDictMatches(@Nullable Block original) {
        if (original == null) {
            return new Block[0];
        }
        int[] ids = OreDictionary.getOreIDs((ItemStack)new ItemStack(original));
        if (ids != null && ids.length > 0) {
            for (int id : ids) {
                String oreName = OreDictionary.getOreName((int)id);
                if ("Unknown".equals(oreName)) continue;
                NonNullList matches = OreDictionary.getOres((String)oreName);
                ArrayList<Block> blocks = new ArrayList<Block>(matches.size());
                for (ItemStack stack : matches) {
                    Block b;
                    if (stack == null || !(stack.func_77973_b() instanceof ItemBlock) || (b = ((ItemBlock)stack.func_77973_b()).func_179223_d()) == null || !BLOCK_TO_GOLEM.containsKey(b.delegate) || BLOCK_TO_GOLEM.get(b.delegate) == null) continue;
                    blocks.add(b);
                }
                return !blocks.isEmpty() ? blocks.toArray(new Block[blocks.size()]) : new Block[]{};
            }
        }
        return new Block[0];
    }

    public static boolean matchesOreDict(Block block, String toCheck) {
        if (OreDictionary.doesOreNameExist((String)toCheck)) {
            ItemStack passedBlock = new ItemStack(block);
            NonNullList matches = OreDictionary.getOres((String)toCheck);
            return !matches.isEmpty() && OreDictionary.itemMatches((ItemStack)passedBlock, (ItemStack)((ItemStack)matches.get(0)), (boolean)true);
        }
        return false;
    }
}

