/*
 * Decompiled with CFR 0.152.
 */
package invtweaks;

import cpw.mods.fml.common.Loader;
import invtweaks.InvTweaksConfig;
import invtweaks.InvTweaksConfigManager;
import invtweaks.InvTweaksConfigSortingRule;
import invtweaks.InvTweaksConst;
import invtweaks.InvTweaksContainerManager;
import invtweaks.InvTweaksContainerSectionManager;
import invtweaks.InvTweaksGuiSettingsButton;
import invtweaks.InvTweaksGuiSortingButton;
import invtweaks.InvTweaksHandlerSorting;
import invtweaks.InvTweaksObfuscation;
import invtweaks.InvTweaksShortcutMapping;
import invtweaks.InvTweaksShortcutType;
import invtweaks.api.IItemTreeItem;
import invtweaks.api.container.ContainerSection;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;

public class InvTweaks
extends InvTweaksObfuscation {
    public static Logger log = Logger.getLogger("InvTweaks");
    private static InvTweaks instance;
    private InvTweaksConfigManager cfgManager = null;
    private int chestAlgorithm = 0;
    private long chestAlgorithmClickTimestamp = 0L;
    private boolean chestAlgorithmButtonDown = false;
    private int storedStackId = 0;
    private int storedStackDamage = Short.MAX_VALUE;
    private int storedFocusedSlot = -1;
    private ItemStack[] hotbarClone = new ItemStack[9];
    private boolean hadFocus = true;
    private boolean mouseWasDown = false;
    private boolean wasInGUI = false;
    private int tickNumber = 0;
    private int lastPollingTickNumber = -3;
    private long sortingKeyPressedDate = 0L;
    private boolean sortKeyDown = false;
    private boolean sortKeyEnabled = true;
    private boolean textboxMode = false;
    private boolean itemPickupPending = false;
    private boolean isNEILoaded;
    private boolean wasNEIEnabled = false;
    private Class neiClientConfig;
    private Method neiHidden;

    public InvTweaks(Minecraft minecraft) {
        super(minecraft);
        log.setLevel(InvTweaksConst.DEFAULT_LOG_LEVEL);
        instance = this;
        this.isNEILoaded = Loader.isModLoaded((String)"NotEnoughItems");
        this.cfgManager = new InvTweaksConfigManager(minecraft);
        if (this.cfgManager.makeSureConfigurationIsLoaded()) {
            log.info("Mod initialized");
        } else {
            log.severe("Mod failed to initialize!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTickInGame() {
        InvTweaks invTweaks = this;
        synchronized (invTweaks) {
            if (!this.onTick()) {
                return;
            }
            this.handleAutoRefill();
            if (this.wasInGUI) {
                this.wasInGUI = false;
                this.textboxMode = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTickInGUI(GuiScreen guiScreen) {
        InvTweaks invTweaks = this;
        synchronized (invTweaks) {
            ItemStack itemStack;
            this.handleMiddleClick(guiScreen);
            if (!this.onTick()) {
                return;
            }
            if (this.isTimeForPolling()) {
                this.unlockKeysIfNecessary();
            }
            if (guiScreen instanceof GuiContainer) {
                this.handleGUILayout((GuiContainer)guiScreen);
            }
            if (!this.wasInGUI) {
                this.mouseWasDown = true;
                log.info(guiScreen.getClass().getName());
                if (guiScreen instanceof GuiContainer) {
                    log.info(((GuiContainer)guiScreen).field_74193_d.getClass().getName());
                }
            }
            if (guiScreen instanceof GuiContainer) {
                this.handleShortcuts((GuiContainer)guiScreen);
            }
            this.storedStackId = (itemStack = this.getFocusedStack()) == null ? 0 : itemStack.field_77993_c;
            int n = this.storedStackDamage = itemStack == null ? 0 : itemStack.func_77960_j();
            if (!this.wasInGUI) {
                this.wasInGUI = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onSortingKeyPressed() {
        InvTweaks invTweaks = this;
        synchronized (invTweaks) {
            if (!this.cfgManager.makeSureConfigurationIsLoaded()) {
                return;
            }
            GuiScreen guiScreen = this.getCurrentScreen();
            if (guiScreen == null || guiScreen instanceof GuiContainer && (InvTweaks.isValidChest(((GuiContainer)guiScreen).field_74193_d) || InvTweaks.isValidInventory(((GuiContainer)guiScreen).field_74193_d))) {
                this.handleSorting(guiScreen);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onItemPickup() {
        if (!this.cfgManager.makeSureConfigurationIsLoaded()) {
            return;
        }
        InvTweaksConfig invTweaksConfig = this.cfgManager.getConfig();
        if (this.cfgManager.getConfig().getProperty("enableSortingOnPickup").equals("false")) {
            return;
        }
        try {
            Object object;
            InvTweaksContainerSectionManager invTweaksContainerSectionManager = new InvTweaksContainerSectionManager(this.mc, ContainerSection.INVENTORY);
            int n = -1;
            for (int i = 0; i < 9; ++i) {
                object = invTweaksContainerSectionManager.getItemStack(i + 27);
                if (object == null || ((ItemStack)object).field_77992_b != 5 || this.hotbarClone[i] != null) continue;
                n = i + 27;
            }
            if (n != -1) {
                this.itemPickupPending = false;
                LinkedList<Integer> linkedList = new LinkedList<Integer>();
                object = invTweaksConfig.getTree();
                ItemStack itemStack = invTweaksContainerSectionManager.getItemStack(n);
                List<IItemTreeItem> list = object.getItems(itemStack.field_77993_c, itemStack.func_77960_j());
                for (InvTweaksConfigSortingRule object22 : invTweaksConfig.getRules()) {
                    if (!object.matches(list, object22.getKeyword())) continue;
                    for (int n2 : object22.getPreferredSlots()) {
                        linkedList.add(n2);
                    }
                }
                boolean bl = true;
                Iterator i = linkedList.iterator();
                while (i.hasNext()) {
                    int n3 = (Integer)i.next();
                    try {
                        if (n3 == n) {
                            bl = false;
                            break;
                        }
                        if (invTweaksContainerSectionManager.getItemStack(n3) != null || !invTweaksContainerSectionManager.move(n, n3)) continue;
                        break;
                    }
                    catch (TimeoutException timeoutException) {
                        this.logInGameError("Failed to move picked up stack", timeoutException);
                    }
                }
                if (bl) {
                    void var9_15;
                    boolean bl2 = false;
                    while (!(var9_15 >= invTweaksContainerSectionManager.getSize() || invTweaksContainerSectionManager.getItemStack((int)var9_15) == null && invTweaksContainerSectionManager.move(n, (int)var9_15))) {
                        ++var9_15;
                    }
                }
            }
        }
        catch (Exception exception) {
            this.logInGameError("Failed to move picked up stack", exception);
            this.itemPickupPending = false;
        }
    }

    public int compareItems(ItemStack itemStack, ItemStack itemStack2) {
        return this.compareItems(itemStack, itemStack2, this.getItemOrder(itemStack), this.getItemOrder(itemStack2));
    }

    int compareItems(ItemStack itemStack, ItemStack itemStack2, int n, int n2) {
        if (itemStack2 == null) {
            return -1;
        }
        if (itemStack == null || n == -1) {
            return 1;
        }
        if (n == n2) {
            if (itemStack.field_77993_c == itemStack2.field_77993_c) {
                Object object;
                Object object2;
                boolean bl = itemStack.func_82837_s();
                boolean bl2 = itemStack2.func_82837_s();
                if (bl || bl2) {
                    if (!bl) {
                        return -1;
                    }
                    if (!bl2) {
                        return 1;
                    }
                    object2 = itemStack.func_82833_r();
                    if (!((String)object2).equals(object = itemStack2.func_82833_r())) {
                        return ((String)object2).compareTo((String)object);
                    }
                }
                object2 = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
                object = EnchantmentHelper.func_82781_a((ItemStack)itemStack2);
                if (object2.size() == object.size()) {
                    int n3 = 0;
                    int n4 = 0;
                    int n5 = 0;
                    int n6 = 0;
                    for (Map.Entry entry : object2.entrySet()) {
                        if ((Integer)entry.getValue() > n4) {
                            n3 = (Integer)entry.getKey();
                            n4 = (Integer)entry.getValue();
                            continue;
                        }
                        if ((Integer)entry.getValue() != n4 || (Integer)entry.getKey() <= n3) continue;
                        n3 = (Integer)entry.getKey();
                    }
                    for (Map.Entry entry : object.entrySet()) {
                        if ((Integer)entry.getValue() > n6) {
                            n5 = (Integer)entry.getKey();
                            n6 = (Integer)entry.getValue();
                            continue;
                        }
                        if ((Integer)entry.getValue() != n6 || (Integer)entry.getKey() <= n5) continue;
                        n5 = (Integer)entry.getKey();
                    }
                    if (n3 == n5) {
                        if (n4 == n6) {
                            if (itemStack.func_77960_j() != itemStack2.func_77960_j()) {
                                if (itemStack.func_77984_f()) {
                                    return itemStack2.func_77960_j() - itemStack.func_77960_j();
                                }
                                return itemStack.func_77960_j() - itemStack2.func_77960_j();
                            }
                            return itemStack2.field_77994_a - itemStack.field_77994_a;
                        }
                        return n6 - n4;
                    }
                    return n5 - n3;
                }
                return object.size() - object2.size();
            }
            return itemStack2.field_77993_c - itemStack.field_77993_c;
        }
        return n - n2;
    }

    public void setItemPickupPending(boolean bl) {
        this.itemPickupPending = bl;
    }

    public void setSortKeyEnabled(boolean bl) {
        this.sortKeyEnabled = bl;
    }

    public void setTextboxMode(boolean bl) {
        this.textboxMode = bl;
    }

    public void logInGame(String string) {
        this.logInGame(string, false);
    }

    public void logInGame(String string, boolean bl) {
        String string2 = this.buildlogString(Level.INFO, bl ? string : StatCollector.func_74838_a((String)string));
        this.addChatMessage(string2);
        log.info(string2);
    }

    public void logInGameError(String string, Exception exception) {
        exception.printStackTrace();
        String string2 = this.buildlogString(Level.SEVERE, StatCollector.func_74838_a((String)string), exception);
        this.addChatMessage(string2);
    }

    public static void logInGameStatic(String string) {
        InvTweaks.getInstance().logInGame(string);
    }

    public static void logInGameErrorStatic(String string, Exception exception) {
        InvTweaks.getInstance().logInGameError(string, exception);
    }

    public static InvTweaks getInstance() {
        return instance;
    }

    public static Minecraft getMinecraftInstance() {
        return InvTweaks.instance.mc;
    }

    public static InvTweaksConfigManager getConfigManager() {
        return InvTweaks.instance.cfgManager;
    }

    public static boolean classExists(String string) {
        try {
            return Class.forName(string) != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private boolean onTick() {
        GuiScreen guiScreen;
        ++this.tickNumber;
        InvTweaksConfig invTweaksConfig = this.cfgManager.getConfig();
        if (invTweaksConfig == null) {
            return false;
        }
        if (this.itemPickupPending) {
            this.onItemPickup();
        }
        if ((guiScreen = this.getCurrentScreen()) == null || InvTweaks.isGuiInventory(guiScreen)) {
            this.cloneHotbar();
        }
        if (this.isSortingShortcutDown()) {
            if (!this.sortKeyDown) {
                this.sortKeyDown = true;
                this.onSortingKeyPressed();
            }
        } else {
            this.sortKeyDown = false;
        }
        this.handleConfigSwitch();
        return true;
    }

    private void handleConfigSwitch() {
        InvTweaksConfig invTweaksConfig = this.cfgManager.getConfig();
        GuiScreen guiScreen = this.getCurrentScreen();
        this.cfgManager.getShortcutsHandler().updatePressedKeys();
        InvTweaksShortcutMapping invTweaksShortcutMapping = this.cfgManager.getShortcutsHandler().isShortcutDown(InvTweaksShortcutType.MOVE_TO_SPECIFIC_HOTBAR_SLOT);
        if (this.isSortingShortcutDown() && invTweaksShortcutMapping != null) {
            String string = null;
            int n = invTweaksShortcutMapping.getKeyCodes().get(0);
            if (n >= 2 && n <= 10) {
                string = invTweaksConfig.switchConfig(n - 2);
            } else {
                switch (n) {
                    case 79: {
                        string = invTweaksConfig.switchConfig(0);
                        break;
                    }
                    case 80: {
                        string = invTweaksConfig.switchConfig(1);
                        break;
                    }
                    case 81: {
                        string = invTweaksConfig.switchConfig(2);
                        break;
                    }
                    case 75: {
                        string = invTweaksConfig.switchConfig(3);
                        break;
                    }
                    case 76: {
                        string = invTweaksConfig.switchConfig(4);
                        break;
                    }
                    case 77: {
                        string = invTweaksConfig.switchConfig(5);
                        break;
                    }
                    case 71: {
                        string = invTweaksConfig.switchConfig(6);
                        break;
                    }
                    case 72: {
                        string = invTweaksConfig.switchConfig(7);
                        break;
                    }
                    case 73: {
                        string = invTweaksConfig.switchConfig(8);
                    }
                }
            }
            if (string != null) {
                this.logInGame(String.format(StatCollector.func_74838_a((String)"invtweaks.loadconfig.enabled"), string), true);
                this.sortingKeyPressedDate = Integer.MAX_VALUE;
            }
        }
        if (this.isSortingShortcutDown()) {
            long l = System.currentTimeMillis();
            if (this.sortingKeyPressedDate == 0L) {
                this.sortingKeyPressedDate = l;
            } else if (l - this.sortingKeyPressedDate > 1000L && this.sortingKeyPressedDate != Integer.MAX_VALUE) {
                String string = invTweaksConfig.getCurrentRulesetName();
                String string2 = invTweaksConfig.switchConfig();
                if (string != null && string2 != null && !string.equals(string2)) {
                    this.logInGame(String.format(StatCollector.func_74838_a((String)"invtweaks.loadconfig.enabled"), string2), true);
                    this.handleSorting(guiScreen);
                }
                this.sortingKeyPressedDate = l;
            }
        } else {
            this.sortingKeyPressedDate = 0L;
        }
    }

    private void handleSorting(GuiScreen guiScreen) {
        ItemStack[] itemStackArray;
        ItemStack itemStack = null;
        int n = this.getFocusedSlot();
        if (n < (itemStackArray = this.getMainInventory()).length && n >= 0) {
            itemStack = itemStackArray[n];
        }
        try {
            new InvTweaksHandlerSorting(this.mc, this.cfgManager.getConfig(), ContainerSection.INVENTORY, 3, 9).sort();
        }
        catch (Exception exception) {
            this.logInGameError("invtweaks.sort.inventory.error", exception);
            exception.printStackTrace();
        }
        this.playClick();
        if (itemStack != null && itemStackArray[n] == null) {
            this.storedStackId = 0;
        }
    }

    private void handleAutoRefill() {
        ItemStack itemStack = this.getFocusedStack();
        int n = itemStack == null ? 0 : itemStack.field_77993_c;
        int n2 = itemStack == null ? 0 : itemStack.func_77960_j();
        int n3 = this.getFocusedSlot() + 27;
        InvTweaksConfig invTweaksConfig = this.cfgManager.getConfig();
        if (n != this.storedStackId || n2 != this.storedStackDamage) {
            if (this.storedFocusedSlot != n3) {
                this.storedFocusedSlot = n3;
            } else if ((itemStack == null || itemStack.field_77993_c == 281 && this.storedStackId == 282) && (this.getCurrentScreen() == null || InvTweaks.isGuiEditSign(this.getCurrentScreen()))) {
                if (invTweaksConfig.isAutoRefillEnabled(this.storedStackId, this.storedStackId)) {
                    try {
                        this.cfgManager.getAutoRefillHandler().autoRefillSlot(n3, this.storedStackId, this.storedStackDamage);
                    }
                    catch (Exception exception) {
                        this.logInGameError("invtweaks.sort.autorefill.error", exception);
                    }
                }
            } else {
                int n4;
                int n5 = itemStack.func_77973_b().func_77612_l();
                if (this.canToolBeReplaced(n2, n5, n4 = invTweaksConfig.getIntProperty("autoRefillDamageThreshhold")) && invTweaksConfig.getProperty("autoRefillBeforeBreak").equals("true") && invTweaksConfig.isAutoRefillEnabled(this.storedStackId, this.storedStackId)) {
                    try {
                        this.cfgManager.getAutoRefillHandler().autoRefillSlot(n3, this.storedStackId, this.storedStackDamage);
                    }
                    catch (Exception exception) {
                        this.logInGameError("invtweaks.sort.autorefill.error", exception);
                    }
                }
            }
        }
        this.storedStackId = n;
        this.storedStackDamage = n2;
    }

    private boolean canToolBeReplaced(int n, int n2, int n3) {
        return n2 != 0 && n2 - n < n3 && n2 - this.storedStackDamage >= n3;
    }

    private void handleMiddleClick(GuiScreen guiScreen) {
        if (Mouse.isButtonDown((int)2)) {
            if (!this.cfgManager.makeSureConfigurationIsLoaded()) {
                return;
            }
            InvTweaksConfig invTweaksConfig = this.cfgManager.getConfig();
            if (invTweaksConfig.getProperty("enableMiddleClick").equals("true") && guiScreen instanceof GuiContainer) {
                GuiContainer guiContainer = (GuiContainer)guiScreen;
                Container container = guiContainer.field_74193_d;
                if (!this.chestAlgorithmButtonDown) {
                    this.chestAlgorithmButtonDown = true;
                    InvTweaksContainerManager invTweaksContainerManager = new InvTweaksContainerManager(this.mc);
                    Slot slot = InvTweaksObfuscation.getSlotAtMousePosition((GuiContainer)this.getCurrentScreen());
                    ContainerSection containerSection = null;
                    if (slot != null) {
                        containerSection = invTweaksContainerManager.getSlotSection(InvTweaks.getSlotNumber(slot));
                    }
                    if (InvTweaks.isValidChest(container)) {
                        if (ContainerSection.CHEST.equals((Object)containerSection)) {
                            this.playClick();
                            long l = System.currentTimeMillis();
                            if (l - this.chestAlgorithmClickTimestamp > 2000L) {
                                this.chestAlgorithm = 0;
                            }
                            try {
                                new InvTweaksHandlerSorting(this.mc, this.cfgManager.getConfig(), ContainerSection.CHEST, this.chestAlgorithm, this.getContainerRowSize(guiContainer)).sort();
                            }
                            catch (Exception exception) {
                                this.logInGameError("invtweaks.sort.chest.error", exception);
                                exception.printStackTrace();
                            }
                            this.chestAlgorithm = (this.chestAlgorithm + 1) % 3;
                            this.chestAlgorithmClickTimestamp = l;
                        } else if (ContainerSection.CRAFTING_IN.equals((Object)containerSection) || ContainerSection.CRAFTING_IN_PERSISTENT.equals((Object)containerSection)) {
                            try {
                                new InvTweaksHandlerSorting(this.mc, this.cfgManager.getConfig(), containerSection, 4, invTweaksContainerManager.getSize(containerSection) == 9 ? 3 : 2).sort();
                            }
                            catch (Exception exception) {
                                this.logInGameError("invtweaks.sort.crafting.error", exception);
                                exception.printStackTrace();
                            }
                        } else if (ContainerSection.INVENTORY_HOTBAR.equals((Object)containerSection) || ContainerSection.INVENTORY_NOT_HOTBAR.equals((Object)containerSection)) {
                            this.handleSorting(guiScreen);
                        }
                    } else if (InvTweaks.isValidInventory(container)) {
                        if (ContainerSection.CRAFTING_IN.equals((Object)containerSection) || ContainerSection.CRAFTING_IN_PERSISTENT.equals((Object)containerSection)) {
                            try {
                                new InvTweaksHandlerSorting(this.mc, this.cfgManager.getConfig(), containerSection, 4, invTweaksContainerManager.getSize(containerSection) == 9 ? 3 : 2).sort();
                            }
                            catch (Exception exception) {
                                this.logInGameError("invtweaks.sort.crafting.error", exception);
                                exception.printStackTrace();
                            }
                        } else {
                            this.handleSorting(guiScreen);
                        }
                    }
                }
            }
        } else {
            this.chestAlgorithmButtonDown = false;
        }
    }

    private void handleGUILayout(GuiContainer guiContainer) {
        InvTweaksConfig invTweaksConfig = this.cfgManager.getConfig();
        Container container = guiContainer.field_74193_d;
        boolean bl = InvTweaks.isValidChest(container);
        if (bl || InvTweaks.isStandardInventory(container) && !InvTweaks.isGuiEnchantmentTable(guiContainer)) {
            GuiContainer guiContainer2 = guiContainer;
            int n = 10;
            int n2 = 10;
            boolean bl2 = this.isNotEnoughItemsEnabled();
            boolean bl3 = this.wasNEIEnabled != bl2;
            this.wasNEIEnabled = bl2;
            boolean bl4 = false;
            List list = guiContainer.field_73887_h;
            ArrayList<GuiButton> arrayList = new ArrayList<GuiButton>();
            for (Object e : list) {
                if (!InvTweaks.isGuiButton(e)) continue;
                GuiButton guiButton = (GuiButton)e;
                if (guiButton.field_73741_f < 54696386 || guiButton.field_73741_f >= 54696390) continue;
                if (bl3) {
                    arrayList.add(guiButton);
                    continue;
                }
                bl4 = true;
                break;
            }
            list.removeAll(arrayList);
            guiContainer.field_73887_h = list;
            if (!bl4) {
                boolean bl5 = this.hasTexture(new ResourceLocation("inventorytweaks", "textures/gui/button10px.png"));
                if (!bl) {
                    list.add(new InvTweaksGuiSettingsButton(this.cfgManager, 54696386, guiContainer2.field_74198_m + guiContainer2.field_74194_b - 15, guiContainer2.field_74197_n + 5, n, n2, "...", StatCollector.func_74838_a((String)"invtweaks.button.settings.tooltip"), bl5));
                } else {
                    this.chestAlgorithmClickTimestamp = 0L;
                    int n3 = 54696386;
                    int n4 = guiContainer2.field_74198_m + guiContainer2.field_74194_b - 16;
                    int n5 = guiContainer2.field_74197_n + 5;
                    boolean bl6 = InvTweaks.isLargeChest(guiContainer2.field_74193_d);
                    if (bl6 && bl2) {
                        n4 = guiContainer2.field_74198_m + guiContainer2.field_74194_b - 35;
                        n5 += 50;
                    }
                    list.add(new InvTweaksGuiSettingsButton(this.cfgManager, n3++, bl6 ? n4 + 22 : n4 - 1, bl6 ? n5 - 3 : n5, n, n2, "...", StatCollector.func_74838_a((String)"invtweaks.button.settings.tooltip"), bl5));
                    if (!invTweaksConfig.getProperty("showChestButtons").equals("false")) {
                        int n6 = this.getContainerRowSize(guiContainer2);
                        InvTweaksGuiSortingButton invTweaksGuiSortingButton = new InvTweaksGuiSortingButton(this.cfgManager, n3++, bl6 ? n4 + 22 : n4 - 13, bl6 ? n5 + 12 : n5, n, n2, "h", StatCollector.func_74838_a((String)"invtweaks.button.chest3.tooltip"), 2, n6, bl5);
                        list.add(invTweaksGuiSortingButton);
                        invTweaksGuiSortingButton = new InvTweaksGuiSortingButton(this.cfgManager, n3++, bl6 ? n4 + 22 : n4 - 25, bl6 ? n5 + 25 : n5, n, n2, "v", StatCollector.func_74838_a((String)"invtweaks.button.chest2.tooltip"), 1, n6, bl5);
                        list.add(invTweaksGuiSortingButton);
                        invTweaksGuiSortingButton = new InvTweaksGuiSortingButton(this.cfgManager, n3++, bl6 ? n4 + 22 : n4 - 37, bl6 ? n5 + 38 : n5, n, n2, "s", StatCollector.func_74838_a((String)"invtweaks.button.chest1.tooltip"), 0, n6, bl5);
                        list.add(invTweaksGuiSortingButton);
                    }
                }
            }
        } else if (InvTweaks.isGuiInventoryCreative(guiContainer)) {
            List list = guiContainer.field_73887_h;
            GuiButton guiButton = null;
            for (Object e : list) {
                if (!InvTweaks.isGuiButton(e) || ((GuiButton)e).field_73741_f != 54696386) continue;
                guiButton = (GuiButton)e;
                break;
            }
            if (guiButton != null) {
                list.remove(guiButton);
            }
        }
    }

    private boolean isNotEnoughItemsEnabled() {
        if (this.isNEILoaded) {
            if (this.neiHidden == null) {
                try {
                    this.neiClientConfig = Class.forName("codechicken.nei.NEIClientConfig");
                    this.neiHidden = this.neiClientConfig.getMethod("isHidden", new Class[0]);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return false;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return false;
                }
            }
            try {
                return (Boolean)this.neiHidden.invoke(null, new Object[0]) == false;
            }
            catch (IllegalAccessException illegalAccessException) {
                return false;
            }
            catch (InvocationTargetException invocationTargetException) {
                return false;
            }
        }
        return false;
    }

    private void handleShortcuts(GuiContainer guiContainer) {
        if (!InvTweaks.isValidChest(guiContainer.field_74193_d) && !InvTweaks.isStandardInventory(guiContainer.field_74193_d)) {
            return;
        }
        if (Mouse.isButtonDown((int)0) || Mouse.isButtonDown((int)1)) {
            if (!this.mouseWasDown) {
                this.mouseWasDown = true;
                if (this.cfgManager.getConfig().getProperty("enableShortcuts").equals("true")) {
                    this.cfgManager.getShortcutsHandler().handleShortcut();
                }
            }
        } else {
            this.mouseWasDown = false;
        }
    }

    private int getItemOrder(ItemStack itemStack) {
        List<IItemTreeItem> list = this.cfgManager.getConfig().getTree().getItems(itemStack.field_77993_c, itemStack.func_77960_j());
        return list != null && list.size() > 0 ? list.get(0).getOrder() : Integer.MAX_VALUE;
    }

    private int getContainerRowSize(GuiContainer guiContainer) {
        return InvTweaks.getSpecialChestRowSize(guiContainer.field_74193_d);
    }

    private boolean isSortingShortcutDown() {
        if (this.sortKeyEnabled && !this.textboxMode) {
            int n = this.cfgManager.getConfig().getSortKeyCode();
            if (n > 0) {
                return Keyboard.isKeyDown((int)n);
            }
            return Mouse.isButtonDown((int)(100 + n));
        }
        return false;
    }

    private boolean isTimeForPolling() {
        if (this.tickNumber - this.lastPollingTickNumber >= 3) {
            this.lastPollingTickNumber = this.tickNumber;
        }
        return this.tickNumber - this.lastPollingTickNumber == 0;
    }

    private void unlockKeysIfNecessary() {
        boolean bl = Display.isActive();
        if (!this.hadFocus && bl) {
            Keyboard.destroy();
            boolean bl2 = true;
            while (!Keyboard.isCreated()) {
                try {
                    Keyboard.create();
                }
                catch (LWJGLException lWJGLException) {
                    if (!bl2) continue;
                    this.logInGameError("invtweaks.keyboardfix.error", (Exception)((Object)lWJGLException));
                    bl2 = false;
                }
            }
            if (!bl2) {
                this.logInGame("invtweaks.keyboardfix.recover");
            }
        }
        this.hadFocus = bl;
    }

    private void cloneHotbar() {
        ItemStack[] itemStackArray = this.getMainInventory();
        for (int i = 0; i < 9; ++i) {
            this.hotbarClone[i] = itemStackArray[i] != null ? itemStackArray[i].func_77946_l() : null;
        }
    }

    private void playClick() {
        if (!this.cfgManager.getConfig().getProperty("enableSounds").equals("false")) {
            this.mc.field_71416_A.func_77366_a("random.click", 0.6f, 1.8f);
        }
    }

    private String buildlogString(Level level, String string, Exception exception) {
        if (exception != null) {
            StackTraceElement stackTraceElement = exception.getStackTrace()[0];
            if (stackTraceElement != null && stackTraceElement.getFileName() != null) {
                return this.buildlogString(level, string) + ": " + exception.getMessage() + " (l" + stackTraceElement.getLineNumber() + " in " + stackTraceElement.getFileName().replace("InvTweaks", "") + ")";
            }
            return this.buildlogString(level, string) + ": " + exception.getMessage();
        }
        return this.buildlogString(level, string);
    }

    private String buildlogString(Level level, String string) {
        return "InvTweaks: " + (level.equals(Level.SEVERE) ? "[ERROR] " : "") + string;
    }
}

