/*
 * Decompiled with CFR 0.152.
 */
package invtweaks;

import invtweaks.InvTweaks;
import invtweaks.api.IItemTreeCategory;
import invtweaks.api.IItemTreeItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;

public class InvTweaksItemTreeCategory
implements IItemTreeCategory {
    private static final Logger log = InvTweaks.log;
    private final Map<Integer, List<IItemTreeItem>> items = new HashMap<Integer, List<IItemTreeItem>>();
    private final Vector<String> matchingItems = new Vector();
    private final Vector<IItemTreeCategory> subCategories = new Vector();
    private String name;
    private int order = -1;

    public InvTweaksItemTreeCategory(String string) {
        this.name = string != null ? string.toLowerCase() : null;
    }

    @Override
    public boolean contains(IItemTreeItem iItemTreeItem) {
        List<IItemTreeItem> list = this.items.get(iItemTreeItem.getId());
        if (list != null) {
            for (IItemTreeItem object : list) {
                if (!object.equals(iItemTreeItem)) continue;
                return true;
            }
        }
        for (IItemTreeCategory iItemTreeCategory : this.subCategories) {
            if (!iItemTreeCategory.contains(iItemTreeItem)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addCategory(IItemTreeCategory iItemTreeCategory) {
        this.subCategories.add(iItemTreeCategory);
    }

    @Override
    public void addItem(IItemTreeItem iItemTreeItem) {
        if (this.items.get(iItemTreeItem.getId()) == null) {
            ArrayList<IItemTreeItem> arrayList = new ArrayList<IItemTreeItem>();
            arrayList.add(iItemTreeItem);
            this.items.put(iItemTreeItem.getId(), arrayList);
        } else {
            this.items.get(iItemTreeItem.getId()).add(iItemTreeItem);
        }
        this.matchingItems.add(iItemTreeItem.getName());
        if (this.order == -1 || this.order > iItemTreeItem.getOrder()) {
            this.order = iItemTreeItem.getOrder();
        }
    }

    @Override
    public int getCategoryOrder() {
        if (this.order != -1) {
            return this.order;
        }
        for (IItemTreeCategory iItemTreeCategory : this.subCategories) {
            int n = iItemTreeCategory.getCategoryOrder();
            if (n == -1) continue;
            return n;
        }
        return -1;
    }

    @Override
    public int findCategoryOrder(String string) {
        if (string.equals(this.name)) {
            return this.getCategoryOrder();
        }
        for (IItemTreeCategory iItemTreeCategory : this.subCategories) {
            int n = iItemTreeCategory.findCategoryOrder(string);
            if (n == -1) continue;
            return n;
        }
        return -1;
    }

    @Override
    public int findKeywordDepth(String string) {
        if (this.name.equals(string)) {
            return 0;
        }
        if (this.matchingItems.contains(string)) {
            return 1;
        }
        for (IItemTreeCategory iItemTreeCategory : this.subCategories) {
            int n = iItemTreeCategory.findKeywordDepth(string);
            if (n == -1) continue;
            return n + 1;
        }
        return -1;
    }

    @Override
    public Collection<IItemTreeCategory> getSubCategories() {
        return this.subCategories;
    }

    @Override
    public Collection<List<IItemTreeItem>> getItems() {
        return this.items.values();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name + " (" + this.subCategories.size() + " cats, " + this.items.size() + " items)";
    }
}

