/*
 * Decompiled with CFR 0.152.
 */
package calclavia.lib.gui;

import calclavia.lib.Calclavia;
import calclavia.lib.gui.GuiSlotType;
import calclavia.lib.render.CalclaviaRenderHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import universalelectricity.compatibility.Compatibility;
import universalelectricity.core.electricity.ElectricityDisplay;
import universalelectricity.core.vector.Vector2;
import universalelectricity.prefab.TranslationHelper;
import universalelectricity.prefab.vector.Region2;

public class GuiContainerBase
extends GuiContainer {
    public ResourceLocation baseTexture;
    protected int meterX = 54;
    protected int meterHeight = 49;
    protected int meterWidth = 14;
    protected int meterEnd = this.meterX + this.meterWidth;
    protected int energyMode = 0;
    public String tooltip = "";
    protected HashMap<Region2, String> tooltips = new HashMap();
    protected int containerWidth;
    protected int containerHeight;

    public GuiContainerBase(Container container) {
        super(container);
        this.field_74195_c = 217;
        this.baseTexture = Calclavia.GUI_BASE;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
    }

    public void func_73874_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        super.func_73874_b();
    }

    protected void func_74189_g(int mouseX, int mouseY) {
        for (Map.Entry<Region2, String> entry : this.tooltips.entrySet()) {
            if (!entry.getKey().isIn(new Vector2(mouseX - this.field_74198_m, mouseY - this.field_74197_n))) continue;
            this.tooltip = entry.getValue();
            break;
        }
        if (this.tooltip != null && this.tooltip != "") {
            this.drawTooltip(mouseX - this.field_74198_m, mouseY - this.field_74197_n, Calclavia.splitStringPerWord(this.tooltip, 5).toArray(new String[0]));
        }
        this.tooltip = "";
    }

    protected void func_74185_a(float var1, int x, int y) {
        this.containerWidth = (this.field_73880_f - this.field_74194_b) / 2;
        this.containerHeight = (this.field_73881_g - this.field_74195_c) / 2;
        this.field_73882_e.field_71446_o.func_110577_a(this.baseTexture);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.containerWidth, this.containerHeight, 0, 0, this.field_74194_b, this.field_74195_c);
    }

    protected void drawBulb(int x, int y, boolean isOn) {
        this.field_73882_e.field_71446_o.func_110577_a(this.baseTexture);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (isOn) {
            this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 161, 0, 6, 6);
        } else {
            this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 161, 4, 6, 6);
        }
    }

    protected void drawSlot(int x, int y, ItemStack itemStack) {
        this.field_73882_e.field_71446_o.func_110577_a(this.baseTexture);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 0, 0, 18, 18);
        this.drawItemStack(itemStack, this.containerWidth + x, this.containerHeight + y);
    }

    protected void drawItemStack(ItemStack itemStack, int x, int y) {
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
        field_74196_a.func_82406_b(this.field_73886_k, this.field_73882_e.field_71446_o, itemStack, ++x, ++y);
    }

    protected void drawTextWithTooltip(String textName, String format, int x, int y, int mouseX, int mouseY) {
        this.drawTextWithTooltip(textName, format, x, y, mouseX, mouseY, 0x404040);
    }

    protected void drawTextWithTooltip(String textName, String format, int x, int y, int mouseX, int mouseY, int color) {
        String name = TranslationHelper.getLocal("gui." + textName + ".name");
        String text = format.replaceAll("%1", name);
        this.field_73886_k.func_78276_b(text, x, y, color);
        String tooltip = TranslationHelper.getLocal("gui." + textName + ".tooltip");
        if (tooltip != null && tooltip != "" && this.func_74188_c(x, y, (int)((double)text.length() * 4.8), 12, mouseX, mouseY)) {
            this.tooltip = tooltip;
        }
    }

    protected void drawTextWithTooltip(String textName, int x, int y, int mouseX, int mouseY) {
        this.drawTextWithTooltip(textName, "%1", x, y, mouseX, mouseY);
    }

    protected void drawSlot(int x, int y, GuiSlotType type, float r, float g, float b) {
        this.field_73882_e.field_71446_o.func_110577_a(Calclavia.GUI_COMPONENTS);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
        this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 0, 0, 18, 18);
        if (type != GuiSlotType.NONE) {
            this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 0, 18 * type.ordinal(), 18, 18);
        }
    }

    protected void drawSlot(int x, int y, GuiSlotType type) {
        this.drawSlot(x, y, type, 1.0f, 1.0f, 1.0f);
    }

    protected void drawSlot(int x, int y) {
        this.drawSlot(x, y, GuiSlotType.NONE);
    }

    protected void drawBar(int x, int y, float scale) {
        this.field_73882_e.field_71446_o.func_110577_a(Calclavia.GUI_COMPONENTS);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 18, 0, 22, 15);
        if (scale > 0.0f) {
            this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 18, 15, 22 - (int)(scale * 22.0f), 15);
        }
    }

    protected void drawForce(int x, int y, float scale) {
        this.field_73882_e.field_71446_o.func_110577_a(Calclavia.GUI_COMPONENTS);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 54, 0, 107, 11);
        if (scale > 0.0f) {
            this.func_73729_b(this.containerWidth + x, this.containerHeight + y, this.meterX, 11, (int)(scale * 107.0f), 11);
        }
    }

    protected void drawElectricity(int x, int y, float scale) {
        this.field_73882_e.field_71446_o.func_110577_a(Calclavia.GUI_COMPONENTS);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 54, 0, 107, 11);
        if (scale > 0.0f) {
            this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 54, 22, (int)(scale * 107.0f), 11);
        }
    }

    protected void drawMeter(int x, int y, float scale, float r, float g, float b) {
        this.field_73882_e.field_71446_o.func_110577_a(Calclavia.GUI_COMPONENTS);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 40, 0, this.meterWidth, this.meterHeight);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
        int actualScale = (int)((float)(this.meterHeight - 1) * scale);
        this.func_73729_b(this.containerWidth + x, this.containerHeight + y + (this.meterHeight - 1 - actualScale), 40, 49, this.meterHeight - 1, actualScale);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 40, 98, this.meterWidth, this.meterHeight);
    }

    protected void drawMeter(int x, int y, float scale, FluidStack liquidStack) {
        this.field_73882_e.field_71446_o.func_110577_a(Calclavia.GUI_COMPONENTS);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 40, 0, this.meterWidth, this.meterHeight);
        this.displayGauge(this.containerWidth + x, this.containerHeight + y, -10, 1, 12, (int)((float)(this.meterHeight - 1) * scale), liquidStack);
        this.field_73882_e.field_71446_o.func_110577_a(Calclavia.GUI_COMPONENTS);
        this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 40, 98, this.meterWidth, this.meterHeight);
    }

    protected void drawSlot(int x, int y, SlotType type, float r, float g, float b) {
        this.field_73882_e.field_71446_o.func_110577_a(Calclavia.GUI_COMPONENTS);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
        this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 0, 0, 18, 18);
        if (type != SlotType.NONE) {
            this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 0, 18 * type.ordinal(), 18, 18);
        }
    }

    protected void drawSlot(int x, int y, SlotType type) {
        this.drawSlot(x, y, type, 1.0f, 1.0f, 1.0f);
    }

    public void renderUniversalDisplay(int x, int y, float energy, int mouseX, int mouseY) {
        String display;
        switch (this.energyMode) {
            default: {
                display = ElectricityDisplay.getDisplay(energy, ElectricityDisplay.ElectricUnit.WATT);
                break;
            }
            case 1: {
                display = ElectricityDisplay.roundDecimals(energy * Compatibility.TO_BC_RATIO) + " MJ";
                break;
            }
            case 2: {
                display = ElectricityDisplay.roundDecimals(energy * Compatibility.TO_IC2_RATIO) + " EU";
            }
        }
        if (Mouse.isButtonDown((int)0) && this.func_74188_c(x, y, display.length() * 5, 9, mouseX, mouseY)) {
            this.energyMode = (this.energyMode + 1) % 3;
        }
        this.field_73886_k.func_78276_b(display, x, y, 0x404040);
    }

    public void drawTooltip(int x, int y, String ... toolTips) {
        if (!GuiScreen.func_73877_p()) {
            GL11.glDisable((int)32826);
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            if (toolTips != null) {
                int var7;
                int var6;
                int var5 = 0;
                for (var6 = 0; var6 < toolTips.length; ++var6) {
                    var7 = this.field_73886_k.func_78256_a(toolTips[var6]);
                    if (var7 <= var5) continue;
                    var5 = var7;
                }
                var6 = x + 12;
                var7 = y - 12;
                int var9 = 8;
                if (toolTips.length > 1) {
                    var9 += 2 + (toolTips.length - 1) * 10;
                }
                if (this.field_74197_n + var7 + var9 + 6 > this.field_73881_g) {
                    var7 = this.field_73881_g - var9 - this.field_74197_n - 6;
                }
                this.field_73735_i = 300.0f;
                int var10 = -267386864;
                this.func_73733_a(var6 - 3, var7 - 4, var6 + var5 + 3, var7 - 3, var10, var10);
                this.func_73733_a(var6 - 3, var7 + var9 + 3, var6 + var5 + 3, var7 + var9 + 4, var10, var10);
                this.func_73733_a(var6 - 3, var7 - 3, var6 + var5 + 3, var7 + var9 + 3, var10, var10);
                this.func_73733_a(var6 - 4, var7 - 3, var6 - 3, var7 + var9 + 3, var10, var10);
                this.func_73733_a(var6 + var5 + 3, var7 - 3, var6 + var5 + 4, var7 + var9 + 3, var10, var10);
                int var11 = 0x505000FF;
                int var12 = (var11 & 0xFEFEFE) >> 1 | var11 & 0xFF000000;
                this.func_73733_a(var6 - 3, var7 - 3 + 1, var6 - 3 + 1, var7 + var9 + 3 - 1, var11, var12);
                this.func_73733_a(var6 + var5 + 2, var7 - 3 + 1, var6 + var5 + 3, var7 + var9 + 3 - 1, var11, var12);
                this.func_73733_a(var6 - 3, var7 - 3, var6 + var5 + 3, var7 - 3 + 1, var11, var11);
                this.func_73733_a(var6 - 3, var7 + var9 + 2, var6 + var5 + 3, var7 + var9 + 3, var12, var12);
                for (int var13 = 0; var13 < toolTips.length; ++var13) {
                    String var14 = toolTips[var13];
                    this.field_73886_k.func_78261_a(var14, var6, var7, -1);
                    var7 += 10;
                }
                this.field_73735_i = 0.0f;
                GL11.glEnable((int)2929);
                GL11.glEnable((int)2896);
                RenderHelper.func_74520_c();
                GL11.glEnable((int)32826);
            }
        }
    }

    protected void displayGauge(int j, int k, int line, int col, int width, int squaled, FluidStack liquid) {
        block5: {
            int x;
            --squaled;
            if (liquid == null) {
                return;
            }
            int start = 0;
            Icon liquidIcon = null;
            Fluid fluid = liquid.getFluid();
            if (fluid != null && fluid.getStillIcon() != null) {
                liquidIcon = fluid.getStillIcon();
            }
            CalclaviaRenderHelper.setSpriteTexture(fluid.getSpriteNumber());
            if (liquidIcon == null) break block5;
            do {
                if (squaled > 16) {
                    x = 16;
                    squaled -= 16;
                } else {
                    x = squaled;
                    squaled = 0;
                }
                this.func_94065_a(j + col, k + line + 58 - x - start, liquidIcon, width, 16 - (16 - x));
                start += 16;
            } while (x != 0 && squaled != 0);
        }
    }

    public static enum SlotType {
        NONE,
        BATTERY,
        LIQUID,
        GAS,
        ARR_UP,
        ARR_DOWN,
        ARR_LEFT,
        ARR_RIGHT,
        ARR_UP_RIGHT,
        ARR_UP_LEFT,
        ARR_DOWN_LEFT,
        ARR_DOWN_RIGHT;

    }
}

