/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gas;

import cpw.mods.fml.common.FMLCommonHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasAcceptor;
import mekanism.api.gas.IGasStorage;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.ITransmitter;
import mekanism.api.transmitters.ITransmitterNetwork;
import mekanism.api.transmitters.TransmissionType;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class GasNetwork
extends DynamicNetwork<IGasAcceptor, GasNetwork> {
    public int transferDelay = 0;
    public boolean didTransfer;
    public boolean prevTransfer;
    public float gasScale;
    public Gas refGas = null;

    public GasNetwork(ITransmitter<GasNetwork> ... varPipes) {
        this.transmitters.addAll(Arrays.asList(varPipes));
        this.register();
    }

    public GasNetwork(Collection<ITransmitter<GasNetwork>> collection) {
        this.transmitters.addAll(collection);
        this.register();
    }

    public GasNetwork(Set<GasNetwork> networks) {
        for (GasNetwork net : networks) {
            if (net == null) continue;
            if (net.refGas != null && net.gasScale > this.gasScale) {
                this.refGas = net.refGas;
                this.gasScale = net.gasScale;
            }
            this.addAllTransmitters(net.transmitters);
            net.deregister();
        }
        this.refresh();
        this.register();
    }

    public synchronized int emit(GasStack stack, TileEntity emitter) {
        int sent;
        int toSend;
        if (this.refGas != null && this.refGas != stack.getGas()) {
            return 0;
        }
        List<Object> availableAcceptors = Arrays.asList(this.getAcceptors(stack.getGas()).toArray());
        Collections.shuffle(availableAcceptors);
        int prevSending = toSend = stack.amount;
        if (!availableAcceptors.isEmpty()) {
            int divider = availableAcceptors.size();
            int remaining = toSend % divider;
            int sending = (toSend - remaining) / divider;
            for (Object obj : availableAcceptors) {
                if (!(obj instanceof IGasAcceptor) || obj == emitter) continue;
                IGasAcceptor acceptor = (IGasAcceptor)obj;
                int currentSending = sending;
                if (remaining > 0) {
                    ++currentSending;
                    --remaining;
                }
                toSend -= acceptor.receiveGas(new GasStack(stack.getGas(), currentSending));
            }
        }
        if ((sent = prevSending - toSend) > 0 && FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.refGas = stack.getGas();
            this.didTransfer = true;
            this.transferDelay = 2;
        }
        return sent;
    }

    @Override
    public void tick() {
        super.tick();
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            if (this.transferDelay == 0) {
                this.didTransfer = false;
            } else {
                --this.transferDelay;
            }
            if (this.didTransfer != this.prevTransfer || this.needsUpdate) {
                MinecraftForge.EVENT_BUS.post((Event)new GasTransferEvent(this, this.refGas != null ? this.refGas.getID() : -1, this.didTransfer));
                this.needsUpdate = false;
            }
            this.prevTransfer = this.didTransfer;
        }
    }

    @Override
    public void clientTick() {
        super.clientTick();
        if (this.didTransfer && this.gasScale < 1.0f) {
            this.gasScale = Math.min(1.0f, this.gasScale + 0.02f);
        } else if (!this.didTransfer && this.gasScale > 0.0f) {
            this.gasScale = Math.max(0.0f, this.gasScale - 0.02f);
            if (this.gasScale == 0.0f) {
                this.refGas = null;
            }
        }
    }

    @Override
    public synchronized Set<IGasAcceptor> getAcceptors(Object ... data) {
        Gas type = (Gas)data[0];
        HashSet<IGasAcceptor> toReturn = new HashSet<IGasAcceptor>();
        for (IGasAcceptor acceptor : this.possibleAcceptors) {
            int stored;
            if (!acceptor.canReceiveGas(((ForgeDirection)this.acceptorDirections.get(acceptor)).getOpposite(), type)) continue;
            int n = stored = ((IGasStorage)((Object)acceptor)).getGas(new Object[0]) != null ? ((IGasStorage)((Object)acceptor)).getGas((Object[])new Object[0]).amount : 0;
            if (acceptor instanceof IGasStorage && (!(acceptor instanceof IGasStorage) || ((IGasStorage)((Object)acceptor)).getMaxGas(new Object[0]) - stored <= 0)) continue;
            toReturn.add(acceptor);
        }
        return toReturn;
    }

    @Override
    public synchronized void refresh() {
        Set iterTubes = (Set)this.transmitters.clone();
        Iterator it = iterTubes.iterator();
        this.possibleAcceptors.clear();
        this.acceptorDirections.clear();
        while (it.hasNext()) {
            ITransmitter conductor = (ITransmitter)it.next();
            if (conductor == null || ((TileEntity)conductor).func_70320_p()) {
                it.remove();
                this.transmitters.remove(conductor);
                continue;
            }
            conductor.setTransmitterNetwork(this);
        }
        for (ITransmitter pipe : this.transmitters) {
            IGasAcceptor[] acceptors;
            for (IGasAcceptor acceptor : acceptors = GasTransmission.getConnectedAcceptors((TileEntity)pipe)) {
                if (acceptor == null || acceptor instanceof ITransmitter) continue;
                this.possibleAcceptors.add(acceptor);
                this.acceptorDirections.put(acceptor, ForgeDirection.getOrientation((int)Arrays.asList(acceptors).indexOf(acceptor)));
            }
        }
    }

    @Override
    public synchronized void merge(GasNetwork network) {
        if (network != null && network != this) {
            HashSet<GasNetwork> networks = new HashSet<GasNetwork>();
            networks.add(this);
            networks.add(network);
            ITransmitterNetwork newNetwork = this.create(networks);
            ((GasNetwork)newNetwork).refresh();
        }
    }

    public String toString() {
        return "[GasNetwork] " + this.transmitters.size() + " transmitters, " + this.possibleAcceptors.size() + " acceptors.";
    }

    protected GasNetwork create(ITransmitter<GasNetwork> ... varTransmitters) {
        GasNetwork network = new GasNetwork(varTransmitters);
        network.refGas = this.refGas;
        network.gasScale = this.gasScale;
        return network;
    }

    protected GasNetwork create(Collection<ITransmitter<GasNetwork>> collection) {
        GasNetwork network = new GasNetwork(collection);
        network.refGas = this.refGas;
        network.gasScale = this.gasScale;
        return network;
    }

    protected GasNetwork create(Set<GasNetwork> networks) {
        GasNetwork network = new GasNetwork(networks);
        if (this.refGas != null && this.gasScale > network.gasScale) {
            network.refGas = this.refGas;
            network.gasScale = this.gasScale;
        }
        return network;
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.GAS;
    }

    @Override
    public String getNeeded() {
        return "Undefined for Gas networks.";
    }

    @Override
    public String getFlow() {
        return "Not defined yet for Gas networks";
    }

    public static class GasTransferEvent
    extends Event {
        public final GasNetwork gasNetwork;
        public final int transferType;
        public final boolean didTransfer;

        public GasTransferEvent(GasNetwork network, int type, boolean did) {
            this.gasNetwork = network;
            this.transferType = type;
            this.didTransfer = did;
        }
    }
}

