/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gas;

import java.util.ArrayList;
import java.util.List;
import mekanism.api.gas.Gas;
import net.minecraftforge.fluids.Fluid;

public class GasRegistry {
    private static ArrayList<Gas> registeredGasses = new ArrayList();

    public static Gas register(Gas gas) {
        if (gas == null) {
            return null;
        }
        registeredGasses.add(gas);
        return GasRegistry.getGas(gas.getName());
    }

    public static Gas getGas(int id) {
        if (id == -1) {
            return null;
        }
        return registeredGasses.get(id);
    }

    public static Gas getGas(Fluid f) {
        for (Gas gas : GasRegistry.getRegisteredGasses()) {
            if (!gas.hasFluid() || gas.getFluid() != f) continue;
            return gas;
        }
        return null;
    }

    public static boolean containsGas(String name) {
        return GasRegistry.getGas(name) != null;
    }

    public static List<Gas> getRegisteredGasses() {
        return (List)registeredGasses.clone();
    }

    public static Gas getGas(String name) {
        for (Gas gas : registeredGasses) {
            if (!gas.getName().equals(name.toLowerCase())) continue;
            return gas;
        }
        return null;
    }

    public static int getGasID(Gas gas) {
        if (gas == null || !GasRegistry.containsGas(gas.getName())) {
            return -1;
        }
        return registeredGasses.indexOf(gas);
    }
}

