/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.transmitters;

import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import mekanism.api.IClientTicker;
import mekanism.api.Object3D;
import mekanism.api.transmitters.ITransmitter;
import mekanism.api.transmitters.ITransmitterNetwork;
import mekanism.api.transmitters.TransmissionType;
import mekanism.api.transmitters.TransmitterNetworkRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public abstract class DynamicNetwork<A, N>
implements ITransmitterNetwork<A, N>,
IClientTicker {
    public HashSet<ITransmitter<N>> transmitters = new HashSet();
    public HashSet<A> possibleAcceptors = new HashSet();
    public HashMap<A, ForgeDirection> acceptorDirections = new HashMap();
    private List<DelayQueue> updateQueue = new ArrayList<DelayQueue>();
    protected int ticksSinceCreate = 0;
    protected boolean fixed = false;
    protected boolean needsUpdate = false;

    protected abstract ITransmitterNetwork<A, N> create(ITransmitter<N> ... var1);

    protected abstract ITransmitterNetwork<A, N> create(Collection<ITransmitter<N>> var1);

    protected abstract ITransmitterNetwork<A, N> create(Set<N> var1);

    public void addAllTransmitters(Set<ITransmitter<N>> newTransmitters) {
        this.transmitters.addAll(newTransmitters);
    }

    @Override
    public void removeTransmitter(ITransmitter<N> transmitter) {
        this.transmitters.remove(transmitter);
        if (this.transmitters.size() == 0) {
            this.deregister();
        }
    }

    @Override
    public void register() {
        try {
            ITransmitter<N> aTransmitter = this.transmitters.iterator().next();
            if (aTransmitter instanceof TileEntity) {
                if (!((TileEntity)aTransmitter).field_70331_k.field_72995_K) {
                    TransmitterNetworkRegistry.getInstance().registerNetwork(this);
                } else {
                    MinecraftForge.EVENT_BUS.post((Event)new ClientTickUpdate(this, 1));
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Override
    public void deregister() {
        this.transmitters.clear();
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            TransmitterNetworkRegistry.getInstance().removeNetwork(this);
        } else {
            MinecraftForge.EVENT_BUS.post((Event)new ClientTickUpdate(this, 0));
        }
    }

    @Override
    public int getSize() {
        return this.transmitters.size();
    }

    @Override
    public int getAcceptorSize() {
        return this.possibleAcceptors.size();
    }

    @Override
    public void tick() {
        if (!this.fixed) {
            ++this.ticksSinceCreate;
            if (this.ticksSinceCreate > 1200) {
                this.ticksSinceCreate = 0;
                this.fixMessedUpNetwork(this.transmitters.iterator().next());
            }
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            Iterator<DelayQueue> i = this.updateQueue.iterator();
            while (i.hasNext()) {
                DelayQueue q = i.next();
                if (q.delay > 0) {
                    --q.delay;
                    continue;
                }
                this.needsUpdate = true;
                i.remove();
            }
        }
    }

    @Override
    public synchronized void fixMessedUpNetwork(ITransmitter<N> transmitter) {
        if (transmitter instanceof TileEntity) {
            NetworkFinder finder = new NetworkFinder(((TileEntity)transmitter).func_70314_l(), this.getTransmissionType(), Object3D.get((TileEntity)transmitter), new Object3D[0]);
            List<Object3D> partNetwork = finder.exploreNetwork();
            HashSet<ITransmitter<N>> newTransporters = new HashSet<ITransmitter<N>>();
            for (Object3D node : partNetwork) {
                TileEntity nodeTile = node.getTileEntity((IBlockAccess)((TileEntity)transmitter).field_70331_k);
                if (!TransmissionType.checkTransmissionType(nodeTile, this.getTransmissionType(), (TileEntity)transmitter)) continue;
                ((ITransmitter)nodeTile).removeFromTransmitterNetwork();
                newTransporters.add((ITransmitter)nodeTile);
            }
            ITransmitterNetwork<A, N> newNetwork = this.create((Collection<ITransmitter<N>>)newTransporters);
            newNetwork.refresh();
            newNetwork.setFixed(true);
            this.deregister();
        }
    }

    @Override
    public synchronized void split(ITransmitter<N> splitPoint) {
        if (splitPoint instanceof TileEntity) {
            this.removeTransmitter(splitPoint);
            TileEntity[] connectedBlocks = new TileEntity[6];
            boolean[] dealtWith = new boolean[]{false, false, false, false, false, false};
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity sideTile = Object3D.get((TileEntity)splitPoint).getFromSide(direction).getTileEntity((IBlockAccess)((TileEntity)splitPoint).field_70331_k);
                if (sideTile == null) continue;
                connectedBlocks[Arrays.asList(ForgeDirection.values()).indexOf((Object)direction)] = sideTile;
            }
            for (int countOne = 0; countOne < connectedBlocks.length; ++countOne) {
                TileEntity connectedBlockA = connectedBlocks[countOne];
                if (!TransmissionType.checkTransmissionType(connectedBlockA, this.getTransmissionType()) || dealtWith[countOne]) continue;
                NetworkFinder finder = new NetworkFinder(((TileEntity)splitPoint).field_70331_k, this.getTransmissionType(), Object3D.get(connectedBlockA), Object3D.get((TileEntity)splitPoint));
                List<Object3D> partNetwork = finder.exploreNetwork();
                for (int countTwo = countOne + 1; countTwo < connectedBlocks.length; ++countTwo) {
                    TileEntity connectedBlockB = connectedBlocks[countTwo];
                    if (!TransmissionType.checkTransmissionType(connectedBlockB, this.getTransmissionType()) || dealtWith[countTwo] || !partNetwork.contains(Object3D.get(connectedBlockB))) continue;
                    dealtWith[countTwo] = true;
                }
                HashSet<ITransmitter<N>> newNetCables = new HashSet<ITransmitter<N>>();
                for (Object3D node : finder.iterated) {
                    TileEntity nodeTile = node.getTileEntity((IBlockAccess)((TileEntity)splitPoint).field_70331_k);
                    if (!TransmissionType.checkTransmissionType(nodeTile, this.getTransmissionType()) || nodeTile == splitPoint) continue;
                    newNetCables.add((ITransmitter)nodeTile);
                }
                ITransmitterNetwork<A, N> newNetwork = this.create((Collection<ITransmitter<N>>)newNetCables);
                newNetwork.refresh();
            }
            this.deregister();
        }
    }

    @Override
    public void setFixed(boolean value) {
        this.fixed = value;
    }

    @Override
    public boolean needsTicks() {
        return this.getSize() > 0;
    }

    @Override
    public void clientTick() {
        ++this.ticksSinceCreate;
        if (this.ticksSinceCreate == 5 && this.getSize() > 0) {
            TileEntity tile = (TileEntity)this.transmitters.iterator().next();
            MinecraftForge.EVENT_BUS.post((Event)new NetworkClientRequest(tile));
        }
    }

    public void addUpdate(EntityPlayer player) {
        this.updateQueue.add(new DelayQueue(player));
    }

    public static class DelayQueue {
        public EntityPlayer player;
        public int delay;

        public DelayQueue(EntityPlayer p) {
            this.player = p;
            this.delay = 5;
        }
    }

    public static class NetworkFinder {
        public TransmissionType transmissionType;
        public World worldObj;
        public Object3D start;
        public List<Object3D> iterated = new ArrayList<Object3D>();
        public List<Object3D> toIgnore = new ArrayList<Object3D>();

        public NetworkFinder(World world, TransmissionType type, Object3D location, Object3D ... ignore) {
            this.worldObj = world;
            this.start = location;
            this.transmissionType = type;
            if (ignore != null) {
                for (int i = 0; i < ignore.length; ++i) {
                    this.toIgnore.add(ignore[i]);
                }
            }
        }

        public void loopAll(Object3D location) {
            if (TransmissionType.checkTransmissionType(location.getTileEntity((IBlockAccess)this.worldObj), this.transmissionType)) {
                this.iterated.add(location);
            } else {
                this.toIgnore.add(location);
            }
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tileEntity;
                Object3D obj = location.getFromSide(direction);
                if (this.iterated.contains(obj) || this.toIgnore.contains(obj) || !TransmissionType.checkTransmissionType(tileEntity = obj.getTileEntity((IBlockAccess)this.worldObj), this.transmissionType, location.getTileEntity((IBlockAccess)this.worldObj))) continue;
                this.loopAll(obj);
            }
        }

        public List<Object3D> exploreNetwork() {
            this.loopAll(this.start);
            return this.iterated;
        }
    }

    public static class NetworkClientRequest
    extends Event {
        public TileEntity tileEntity;

        public NetworkClientRequest(TileEntity tile) {
            this.tileEntity = tile;
        }
    }

    public static class ClientTickUpdate
    extends Event {
        public DynamicNetwork network;
        public byte operation;

        public ClientTickUpdate(DynamicNetwork net, byte b) {
            this.network = net;
            this.operation = b;
        }
    }
}

