/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.transmitters;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mekanism.api.transmitters.ITransmitter;
import mekanism.api.transmitters.ITransmitterNetwork;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.ChunkEvent;

public class TransmitterNetworkRegistry
implements ITickHandler {
    private static TransmitterNetworkRegistry INSTANCE = new TransmitterNetworkRegistry();
    private static boolean loaderRegistered = false;
    private HashSet<ITransmitterNetwork> networks = new HashSet();

    public TransmitterNetworkRegistry() {
        TickRegistry.registerTickHandler((ITickHandler)this, (Side)Side.SERVER);
    }

    public static void initiate() {
        if (!loaderRegistered) {
            loaderRegistered = true;
            MinecraftForge.EVENT_BUS.register((Object)new NetworkLoader());
        }
    }

    public static TransmitterNetworkRegistry getInstance() {
        return INSTANCE;
    }

    public void registerNetwork(ITransmitterNetwork network) {
        this.networks.add(network);
    }

    public void removeNetwork(ITransmitterNetwork network) {
        if (this.networks.contains(network)) {
            this.networks.remove(network);
        }
    }

    public void pruneEmptyNetworks() {
        HashSet<ITransmitterNetwork> copySet = new HashSet<ITransmitterNetwork>(this.networks);
        for (ITransmitterNetwork e : copySet) {
            if (e.getSize() != 0) continue;
            this.removeNetwork(e);
        }
    }

    public void tickStart(EnumSet<TickType> type, Object ... tickData) {
    }

    public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
        Set iterNetworks = (Set)this.networks.clone();
        for (ITransmitterNetwork net : iterNetworks) {
            if (!this.networks.contains(net)) continue;
            net.tick();
        }
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.SERVER);
    }

    public String getLabel() {
        return "MekanismNetworks";
    }

    public String toString() {
        return "Network Registry:\n" + this.networks;
    }

    public static class NetworkLoader {
        @ForgeSubscribe
        public void onChunkLoad(ChunkEvent.Load event) {
            if (event.getChunk() != null && !event.world.field_72995_K) {
                int x = event.getChunk().field_76635_g;
                int z = event.getChunk().field_76647_h;
                IChunkProvider cProvider = event.getChunk().field_76637_e.func_72863_F();
                Chunk[] neighbors = new Chunk[5];
                neighbors[0] = event.getChunk();
                if (cProvider.func_73149_a(x + 1, z)) {
                    neighbors[1] = cProvider.func_73154_d(x + 1, z);
                }
                if (cProvider.func_73149_a(x - 1, z)) {
                    neighbors[2] = cProvider.func_73154_d(x - 1, z);
                }
                if (cProvider.func_73149_a(x, z + 1)) {
                    neighbors[3] = cProvider.func_73154_d(x, z + 1);
                }
                if (cProvider.func_73149_a(x, z - 1)) {
                    neighbors[4] = cProvider.func_73154_d(x, z - 1);
                }
                for (Chunk c : neighbors) {
                    this.refreshChunk(c);
                }
            }
        }

        public synchronized void refreshChunk(Chunk c) {
            try {
                if (c != null) {
                    Map copy = (Map)((HashMap)c.field_76648_i).clone();
                    for (Object obj : c.field_76648_i.values()) {
                        if (!(obj instanceof ITransmitter)) continue;
                        ((ITransmitter)obj).refreshTransmitterNetwork();
                        ((ITransmitter)obj).chunkLoad();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

