/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import mekanism.client.gui.GuiCredits;
import mekanism.common.Mekanism;

@SideOnly(value=Side.CLIENT)
public class ThreadClientUpdate
extends Thread {
    private int bytesDownloaded;
    private int lastBytesDownloaded;
    private byte[] buffer = new byte[10240];
    private URL url;
    public String moduleName;
    public static int modulesBeingDownloaded;
    public static boolean hasUpdated;

    public ThreadClientUpdate(String location, String name) {
        this.moduleName = name;
        ++modulesBeingDownloaded;
        try {
            this.url = new URL(location);
            this.setDaemon(false);
            this.start();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        File download = new File(Mekanism.proxy.getMinecraftDir() + (File.separator + "mods" + File.separator + "Mekanism" + this.moduleName + "-v" + Mekanism.latestVersionNumber + ".jar"));
        try {
            this.prepareForDownload();
            download.createNewFile();
            FileOutputStream outputStream = new FileOutputStream(download.getAbsolutePath());
            InputStream stream = this.url.openStream();
            while ((this.lastBytesDownloaded = stream.read(this.buffer)) > 0) {
                outputStream.write(this.buffer, 0, this.lastBytesDownloaded);
                this.buffer = new byte[10240];
                this.bytesDownloaded += this.lastBytesDownloaded;
            }
            outputStream.close();
            stream.close();
            --modulesBeingDownloaded;
            this.finalize();
        }
        catch (Throwable t) {
            GuiCredits.onErrorDownloading();
            System.err.println("[Mekanism] Error while finishing update thread: " + t.getMessage());
            try {
                --modulesBeingDownloaded;
                this.finalize();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void prepareForDownload() {
        File[] modsList;
        for (File file : modsList = new File(Mekanism.proxy.getMinecraftDir() + (File.separator + "mods")).listFiles()) {
            if (!file.getName().startsWith("Mekanism" + this.moduleName) || !file.getName().endsWith(".jar") || file.getName().contains(Mekanism.latestVersionNumber)) continue;
            file.delete();
        }
        System.out.println("[Mekanism] Preparing to update...");
    }
}

