/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mekanism.api.Object3D;
import mekanism.client.gui.GuiMekanism;
import mekanism.common.PacketHandler;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.miner.MItemStackFilter;
import mekanism.common.miner.MOreDictFilter;
import mekanism.common.miner.MinerFilter;
import mekanism.common.network.PacketDigitalMinerGui;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tileentity.TileEntityDigitalMiner;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

public class GuiDigitalMinerConfig
extends GuiMekanism {
    public TileEntityDigitalMiner tileEntity;
    public boolean isDragging = false;
    public int dragOffset = 0;
    public int stackSwitch = 0;
    public Map<MOreDictFilter, StackData> oreDictStacks = new HashMap<MOreDictFilter, StackData>();
    public float scroll;
    private GuiTextField radiusField;
    private GuiTextField minField;
    private GuiTextField maxField;

    public GuiDigitalMinerConfig(EntityPlayer player, TileEntityDigitalMiner tentity) {
        super(new ContainerNull(player, tentity));
        this.tileEntity = tentity;
    }

    public int getScroll() {
        return Math.max(Math.min((int)(this.scroll * 123.0f), 123), 0);
    }

    public int getFilterIndex() {
        if (this.tileEntity.filters.size() <= 4) {
            return 0;
        }
        return (int)((float)this.tileEntity.filters.size() * this.scroll - 4.0f / (float)this.tileEntity.filters.size() * this.scroll);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.radiusField.func_73780_a();
        this.minField.func_73780_a();
        this.maxField.func_73780_a();
        if (this.stackSwitch > 0) {
            --this.stackSwitch;
        }
        if (this.stackSwitch == 0) {
            for (Map.Entry<MOreDictFilter, StackData> entry : this.oreDictStacks.entrySet()) {
                if (entry.getValue().iterStacks == null || entry.getValue().iterStacks.size() <= 0) continue;
                if (entry.getValue().stackIndex == -1 || entry.getValue().stackIndex == entry.getValue().iterStacks.size() - 1) {
                    entry.getValue().stackIndex = 0;
                } else if (entry.getValue().stackIndex < entry.getValue().iterStacks.size() - 1) {
                    ++entry.getValue().stackIndex;
                }
                entry.getValue().renderStack = entry.getValue().iterStacks.get(entry.getValue().stackIndex);
            }
            this.stackSwitch = 20;
        } else {
            for (Map.Entry<MOreDictFilter, StackData> entry : this.oreDictStacks.entrySet()) {
                if (entry.getValue().iterStacks == null || entry.getValue().iterStacks.size() != 0) continue;
                entry.getValue().renderStack = null;
            }
        }
        HashSet<MOreDictFilter> filtersVisible = new HashSet<MOreDictFilter>();
        for (int i = 0; i < 4; ++i) {
            if (!(this.tileEntity.filters.get(this.getFilterIndex() + i) instanceof MOreDictFilter)) continue;
            filtersVisible.add((MOreDictFilter)this.tileEntity.filters.get(this.getFilterIndex() + i));
        }
        for (MinerFilter filter : this.tileEntity.filters) {
            if (!(filter instanceof MOreDictFilter) || filtersVisible.contains(filter) || !this.oreDictStacks.containsKey(filter)) continue;
            this.oreDictStacks.remove(filter);
        }
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int button) {
        super.func_73864_a(mouseX, mouseY, button);
        this.radiusField.func_73793_a(mouseX, mouseY, button);
        this.minField.func_73793_a(mouseX, mouseY, button);
        this.maxField.func_73793_a(mouseX, mouseY, button);
        if (button == 0) {
            int xAxis = mouseX - (this.field_73880_f - this.field_74194_b) / 2;
            int yAxis = mouseY - (this.field_73881_g - this.field_74195_c) / 2;
            if (xAxis >= 154 && xAxis <= 166 && yAxis >= this.getScroll() + 18 && yAxis <= this.getScroll() + 18 + 15) {
                this.dragOffset = yAxis - (this.getScroll() + 18);
                this.isDragging = true;
            }
            for (int i = 0; i < 4; ++i) {
                if (this.tileEntity.filters.get(this.getFilterIndex() + i) == null) continue;
                int yStart = i * 29 + 18;
                if (xAxis < 56 || xAxis > 152 || yAxis < yStart || yAxis > yStart + 29) continue;
                MinerFilter filter = this.tileEntity.filters.get(this.getFilterIndex() + i);
                if (filter instanceof MItemStackFilter) {
                    this.field_73882_e.field_71416_A.func_77366_a("random.click", 1.0f, 1.0f);
                    PacketHandler.sendPacket(PacketHandler.Transmission.SERVER, new PacketDigitalMinerGui().setParams(new Object[]{PacketDigitalMinerGui.MinerGuiPacket.SERVER_INDEX, Object3D.get(this.tileEntity), 1, this.getFilterIndex() + i}), new Object[0]);
                    continue;
                }
                if (!(filter instanceof MOreDictFilter)) continue;
                this.field_73882_e.field_71416_A.func_77366_a("random.click", 1.0f, 1.0f);
                PacketHandler.sendPacket(PacketHandler.Transmission.SERVER, new PacketDigitalMinerGui().setParams(new Object[]{PacketDigitalMinerGui.MinerGuiPacket.SERVER_INDEX, Object3D.get(this.tileEntity), 2, this.getFilterIndex() + i}), new Object[0]);
            }
            if (xAxis >= 5 && xAxis <= 16 && yAxis >= 5 && yAxis <= 16) {
                this.field_73882_e.field_71416_A.func_77366_a("random.click", 1.0f, 1.0f);
                PacketHandler.sendPacket(PacketHandler.Transmission.SERVER, new PacketDigitalMinerGui().setParams(new Object[]{PacketDigitalMinerGui.MinerGuiPacket.SERVER, Object3D.get(this.tileEntity), 3}), new Object[0]);
            }
            if (xAxis >= 39 && xAxis <= 50 && yAxis >= 67 && yAxis <= 78) {
                this.field_73882_e.field_71416_A.func_77366_a("random.click", 1.0f, 1.0f);
                this.setRadius();
            }
            if (xAxis >= 39 && xAxis <= 50 && yAxis >= 92 && yAxis <= 103) {
                this.field_73882_e.field_71416_A.func_77366_a("random.click", 1.0f, 1.0f);
                this.setMinY();
            }
            if (xAxis >= 39 && xAxis <= 50 && yAxis >= 117 && yAxis <= 128) {
                this.field_73882_e.field_71416_A.func_77366_a("random.click", 1.0f, 1.0f);
                this.setMaxY();
            }
        }
    }

    protected void func_85041_a(int mouseX, int mouseY, int button, long ticks) {
        super.func_85041_a(mouseX, mouseY, button, ticks);
        int xAxis = mouseX - (this.field_73880_f - this.field_74194_b) / 2;
        int yAxis = mouseY - (this.field_73881_g - this.field_74195_c) / 2;
        if (this.isDragging) {
            this.scroll = Math.min(Math.max((float)(yAxis - 18 - this.dragOffset) / 123.0f, 0.0f), 1.0f);
        }
    }

    protected void func_73879_b(int x, int y, int type) {
        super.func_73879_b(x, y, type);
        if (type == 0 && this.isDragging) {
            this.dragOffset = 0;
            this.isDragging = false;
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int guiWidth = (this.field_73880_f - this.field_74194_b) / 2;
        int guiHeight = (this.field_73881_g - this.field_74195_c) / 2;
        this.field_73887_h.clear();
        this.field_73887_h.add(new GuiButton(0, guiWidth + 56, guiHeight + 136, 54, 20, "ItemStack"));
        this.field_73887_h.add(new GuiButton(1, guiWidth + 110, guiHeight + 136, 43, 20, "OreDict"));
        String prevRad = this.radiusField != null ? this.radiusField.func_73781_b() : "";
        String prevMin = this.minField != null ? this.minField.func_73781_b() : "";
        String prevMax = this.maxField != null ? this.maxField.func_73781_b() : "";
        this.radiusField = new GuiTextField(this.field_73886_k, guiWidth + 12, guiHeight + 67, 26, 11);
        this.radiusField.func_73804_f(2);
        this.radiusField.func_73782_a(prevRad);
        this.minField = new GuiTextField(this.field_73886_k, guiWidth + 12, guiHeight + 92, 26, 11);
        this.minField.func_73804_f(3);
        this.minField.func_73782_a(prevMin);
        this.maxField = new GuiTextField(this.field_73886_k, guiWidth + 12, guiHeight + 117, 26, 11);
        this.maxField.func_73804_f(3);
        this.maxField.func_73782_a(prevMax);
    }

    protected void func_73875_a(GuiButton guibutton) {
        super.func_73875_a(guibutton);
        if (guibutton.field_73741_f == 0) {
            PacketHandler.sendPacket(PacketHandler.Transmission.SERVER, new PacketDigitalMinerGui().setParams(new Object[]{PacketDigitalMinerGui.MinerGuiPacket.SERVER, Object3D.get(this.tileEntity), 1}), new Object[0]);
        } else if (guibutton.field_73741_f == 1) {
            PacketHandler.sendPacket(PacketHandler.Transmission.SERVER, new PacketDigitalMinerGui().setParams(new Object[]{PacketDigitalMinerGui.MinerGuiPacket.SERVER, Object3D.get(this.tileEntity), 2}), new Object[0]);
        }
    }

    @Override
    protected void func_74189_g(int mouseX, int mouseY) {
        int xAxis = mouseX - (this.field_73880_f - this.field_74194_b) / 2;
        int yAxis = mouseY - (this.field_73881_g - this.field_74195_c) / 2;
        this.field_73886_k.func_78276_b(MekanismUtils.localize("gui.digitalMinerConfig"), 43, 6, 0x404040);
        this.field_73886_k.func_78276_b("Filters:", 11, 19, 52480);
        this.field_73886_k.func_78276_b("T: " + this.tileEntity.filters.size(), 11, 28, 52480);
        this.field_73886_k.func_78276_b("IS: " + this.getItemStackFilters().size(), 11, 37, 52480);
        this.field_73886_k.func_78276_b("OD: " + this.getOreDictFilters().size(), 11, 46, 52480);
        this.field_73886_k.func_78276_b("Radi: " + this.tileEntity.radius, 11, 58, 52480);
        this.field_73886_k.func_78276_b("Min: " + this.tileEntity.minY, 11, 83, 52480);
        this.field_73886_k.func_78276_b("Max: " + this.tileEntity.maxY, 11, 108, 52480);
        for (int i = 0; i < 4; ++i) {
            if (this.tileEntity.filters.get(this.getFilterIndex() + i) == null) continue;
            MinerFilter filter = this.tileEntity.filters.get(this.getFilterIndex() + i);
            int yStart = i * 29 + 18;
            if (filter instanceof MItemStackFilter) {
                MItemStackFilter itemFilter = (MItemStackFilter)filter;
                if (itemFilter.itemType != null) {
                    GL11.glPushMatrix();
                    GL11.glEnable((int)2896);
                    field_74196_a.func_82406_b(this.field_73886_k, this.field_73882_e.func_110434_K(), itemFilter.itemType, 59, yStart + 3);
                    GL11.glDisable((int)2896);
                    GL11.glPopMatrix();
                }
                this.field_73886_k.func_78276_b("Item Filter", 78, yStart + 2, 0x404040);
                continue;
            }
            if (!(filter instanceof MOreDictFilter)) continue;
            MOreDictFilter oreFilter = (MOreDictFilter)filter;
            if (!this.oreDictStacks.containsKey(oreFilter)) {
                this.updateStackList(oreFilter);
            }
            if (this.oreDictStacks.get((Object)filter).renderStack != null) {
                try {
                    GL11.glPushMatrix();
                    GL11.glEnable((int)2896);
                    field_74196_a.func_82406_b(this.field_73886_k, this.field_73882_e.func_110434_K(), this.oreDictStacks.get((Object)filter).renderStack, 59, yStart + 3);
                    GL11.glDisable((int)2896);
                    GL11.glPopMatrix();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.field_73886_k.func_78276_b("OreDict Filter", 78, yStart + 2, 0x404040);
        }
        super.func_74189_g(mouseX, mouseY);
    }

    @Override
    protected void func_74185_a(float partialTick, int mouseX, int mouseY) {
        super.func_74185_a(partialTick, mouseX, mouseY);
        this.field_73882_e.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiDigitalMinerConfig.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_73880_f - this.field_74194_b) / 2;
        int guiHeight = (this.field_73881_g - this.field_74195_c) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_74194_b, this.field_74195_c);
        this.func_73729_b(guiWidth + 154, guiHeight + 18 + this.getScroll(), 232, 0, 12, 15);
        int xAxis = mouseX - (this.field_73880_f - this.field_74194_b) / 2;
        int yAxis = mouseY - (this.field_73881_g - this.field_74195_c) / 2;
        for (int i = 0; i < 4; ++i) {
            boolean mouseOver;
            if (this.tileEntity.filters.get(this.getFilterIndex() + i) == null) continue;
            MinerFilter filter = this.tileEntity.filters.get(this.getFilterIndex() + i);
            int yStart = i * 29 + 18;
            boolean bl = mouseOver = xAxis >= 56 && xAxis <= 152 && yAxis >= yStart && yAxis <= yStart + 29;
            if (filter instanceof MItemStackFilter) {
                this.func_73729_b(guiWidth + 56, guiHeight + yStart, mouseOver ? 0 : 96, 166, 96, 29);
                continue;
            }
            if (!(filter instanceof MOreDictFilter)) continue;
            this.func_73729_b(guiWidth + 56, guiHeight + yStart, mouseOver ? 0 : 96, 195, 96, 29);
        }
        if (xAxis >= 5 && xAxis <= 16 && yAxis >= 5 && yAxis <= 16) {
            this.func_73729_b(guiWidth + 5, guiHeight + 5, 176, 0, 11, 11);
        } else {
            this.func_73729_b(guiWidth + 5, guiHeight + 5, 176, 11, 11, 11);
        }
        if (xAxis >= 39 && xAxis <= 50 && yAxis >= 67 && yAxis <= 78) {
            this.func_73729_b(guiWidth + 39, guiHeight + 67, 187, 0, 11, 11);
        } else {
            this.func_73729_b(guiWidth + 39, guiHeight + 67, 187, 11, 11, 11);
        }
        if (xAxis >= 39 && xAxis <= 50 && yAxis >= 92 && yAxis <= 103) {
            this.func_73729_b(guiWidth + 39, guiHeight + 92, 187, 0, 11, 11);
        } else {
            this.func_73729_b(guiWidth + 39, guiHeight + 92, 187, 11, 11, 11);
        }
        if (xAxis >= 39 && xAxis <= 50 && yAxis >= 117 && yAxis <= 128) {
            this.func_73729_b(guiWidth + 39, guiHeight + 117, 187, 0, 11, 11);
        } else {
            this.func_73729_b(guiWidth + 39, guiHeight + 117, 187, 11, 11, 11);
        }
        this.radiusField.func_73795_f();
        this.minField.func_73795_f();
        this.maxField.func_73795_f();
    }

    public void func_73869_a(char c, int i) {
        if (!this.radiusField.func_73806_l() && !this.minField.func_73806_l() && !this.maxField.func_73806_l() || i == 1) {
            super.func_73869_a(c, i);
        }
        if (i == 28) {
            if (this.radiusField.func_73806_l()) {
                this.setRadius();
            } else if (this.minField.func_73806_l()) {
                this.setMinY();
            } else if (this.maxField.func_73806_l()) {
                this.setMaxY();
            }
        }
        if (Character.isDigit(c) || i == 14 || i == 211 || i == 203 || i == 205) {
            this.radiusField.func_73802_a(c, i);
            this.minField.func_73802_a(c, i);
            this.maxField.func_73802_a(c, i);
        }
    }

    private void setRadius() {
        if (!this.radiusField.func_73781_b().isEmpty()) {
            int toUse = Math.max(0, Math.min(Integer.parseInt(this.radiusField.func_73781_b()), 32));
            ArrayList<Integer> data = new ArrayList<Integer>();
            data.add(6);
            data.add(toUse);
            PacketHandler.sendPacket(PacketHandler.Transmission.SERVER, new PacketTileEntity().setParams(Object3D.get(this.tileEntity), data), new Object[0]);
            this.radiusField.func_73782_a("");
        }
    }

    private void setMinY() {
        if (!this.minField.func_73781_b().isEmpty()) {
            int toUse = Math.max(0, Math.min(Integer.parseInt(this.minField.func_73781_b()), 255));
            ArrayList<Integer> data = new ArrayList<Integer>();
            data.add(7);
            data.add(toUse);
            PacketHandler.sendPacket(PacketHandler.Transmission.SERVER, new PacketTileEntity().setParams(Object3D.get(this.tileEntity), data), new Object[0]);
            this.minField.func_73782_a("");
        }
    }

    private void setMaxY() {
        if (!this.maxField.func_73781_b().isEmpty()) {
            int toUse = Math.max(0, Math.min(Integer.parseInt(this.maxField.func_73781_b()), 255));
            ArrayList<Integer> data = new ArrayList<Integer>();
            data.add(8);
            data.add(toUse);
            PacketHandler.sendPacket(PacketHandler.Transmission.SERVER, new PacketTileEntity().setParams(Object3D.get(this.tileEntity), data), new Object[0]);
            this.maxField.func_73782_a("");
        }
    }

    public ArrayList getItemStackFilters() {
        ArrayList<MinerFilter> list = new ArrayList<MinerFilter>();
        for (MinerFilter filter : this.tileEntity.filters) {
            if (!(filter instanceof MItemStackFilter)) continue;
            list.add(filter);
        }
        return list;
    }

    public ArrayList getOreDictFilters() {
        ArrayList<MinerFilter> list = new ArrayList<MinerFilter>();
        for (MinerFilter filter : this.tileEntity.filters) {
            if (!(filter instanceof MOreDictFilter)) continue;
            list.add(filter);
        }
        return list;
    }

    private void updateStackList(MOreDictFilter filter) {
        if (!this.oreDictStacks.containsKey(filter)) {
            this.oreDictStacks.put(filter, new StackData());
        }
        if (this.oreDictStacks.get((Object)filter).iterStacks == null) {
            this.oreDictStacks.get((Object)filter).iterStacks = new ArrayList<ItemStack>();
        } else {
            this.oreDictStacks.get((Object)filter).iterStacks.clear();
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (String s : OreDictionary.getOreNames()) {
            if (filter.oreDictName.equals(s) || filter.oreDictName.equals("*")) {
                keys.add(s);
                continue;
            }
            if (filter.oreDictName.endsWith("*") && !filter.oreDictName.startsWith("*")) {
                if (!s.startsWith(filter.oreDictName.substring(0, filter.oreDictName.length() - 1))) continue;
                keys.add(s);
                continue;
            }
            if (filter.oreDictName.startsWith("*") && !filter.oreDictName.endsWith("*")) {
                if (!s.endsWith(filter.oreDictName.substring(1))) continue;
                keys.add(s);
                continue;
            }
            if (!filter.oreDictName.startsWith("*") || !filter.oreDictName.endsWith("*") || !s.contains(filter.oreDictName.substring(1, filter.oreDictName.length() - 1))) continue;
            keys.add(s);
        }
        for (String key : keys) {
            for (ItemStack stack : OreDictionary.getOres((String)key)) {
                ItemStack toAdd = stack.func_77946_l();
                if (this.oreDictStacks.get((Object)filter).iterStacks.contains(stack) || !(toAdd.func_77973_b() instanceof ItemBlock)) continue;
                this.oreDictStacks.get((Object)filter).iterStacks.add(stack.func_77946_l());
            }
        }
        this.stackSwitch = 0;
        this.func_73876_c();
        this.oreDictStacks.get((Object)filter).stackIndex = -1;
    }

    public static class StackData {
        public List<ItemStack> iterStacks;
        public int stackIndex;
        public ItemStack renderStack;
    }
}

