/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.lang.reflect.Method;
import mekanism.common.ObfuscatedNames;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public abstract class GuiElement {
    protected static Minecraft mc = Minecraft.func_71410_x();
    protected ResourceLocation RESOURCE;
    public GuiScreen guiObj;
    public TileEntity tileEntity;
    public ResourceLocation defaultLocation;

    public GuiElement(ResourceLocation resource, GuiScreen gui, TileEntity tile, ResourceLocation def) {
        this.RESOURCE = resource;
        this.guiObj = gui;
        this.tileEntity = tile;
        this.defaultLocation = def;
    }

    protected void displayTooltip(String s, int xAxis, int yAxis) {
        try {
            Method m = MekanismUtils.getPrivateMethod(GuiContainer.class, ObfuscatedNames.GuiContainer_drawCreativeTabHoveringText, String.class, Integer.TYPE, Integer.TYPE);
            m.setAccessible(true);
            m.invoke((Object)this.guiObj, s, xAxis, yAxis);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected void offsetX(int xSize) {
        if (this.guiObj instanceof GuiContainer) {
            try {
                int size = (Integer)MekanismUtils.getPrivateValue(this.guiObj, GuiContainer.class, ObfuscatedNames.GuiContainer_xSize);
                MekanismUtils.setPrivateValue(this.guiObj, size + xSize, GuiContainer.class, ObfuscatedNames.GuiContainer_xSize);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void offsetY(int ySize) {
        if (this.guiObj instanceof GuiContainer) {
            try {
                int size = (Integer)MekanismUtils.getPrivateValue(this.guiObj, GuiContainer.class, ObfuscatedNames.GuiContainer_ySize);
                MekanismUtils.setPrivateValue(this.guiObj, size + ySize, GuiContainer.class, ObfuscatedNames.GuiContainer_ySize);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected FontRenderer getFontRenderer() {
        try {
            return (FontRenderer)MekanismUtils.getPrivateValue(this.guiObj, GuiScreen.class, ObfuscatedNames.GuiScreen_fontRenderer);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public abstract void renderBackground(int var1, int var2, int var3, int var4);

    public abstract void renderForeground(int var1, int var2);

    public abstract void preMouseClicked(int var1, int var2, int var3);

    public abstract void mouseClicked(int var1, int var2, int var3);
}

