/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mekanism.api.Object3D;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.GuiRedstoneControl;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.PacketHandler;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.network.PacketLogisticalSorterGui;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tileentity.TileEntityLogisticalSorter;
import mekanism.common.transporter.TItemStackFilter;
import mekanism.common.transporter.TOreDictFilter;
import mekanism.common.transporter.TransporterFilter;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiLogisticalSorter
extends GuiMekanism {
    public TileEntityLogisticalSorter tileEntity;
    public boolean isDragging = false;
    public int dragOffset = 0;
    public int stackSwitch = 0;
    public Map<TOreDictFilter, StackData> oreDictStacks = new HashMap<TOreDictFilter, StackData>();
    public float scroll;

    public GuiLogisticalSorter(EntityPlayer player, TileEntityLogisticalSorter tentity) {
        super(new ContainerNull(player, tentity));
        this.tileEntity = tentity;
        this.guiElements.add(new GuiRedstoneControl((GuiScreen)this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiLogisticalSorter.png")));
    }

    public int getScroll() {
        return Math.max(Math.min((int)(this.scroll * 123.0f), 123), 0);
    }

    public int getFilterIndex() {
        if (this.tileEntity.filters.size() <= 4) {
            return 0;
        }
        return (int)((float)this.tileEntity.filters.size() * this.scroll - 4.0f / (float)this.tileEntity.filters.size() * this.scroll);
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.stackSwitch > 0) {
            --this.stackSwitch;
        }
        if (this.stackSwitch == 0) {
            for (Map.Entry<TOreDictFilter, StackData> entry : this.oreDictStacks.entrySet()) {
                if (entry.getValue().iterStacks == null || entry.getValue().iterStacks.size() <= 0) continue;
                if (entry.getValue().stackIndex == -1 || entry.getValue().stackIndex == entry.getValue().iterStacks.size() - 1) {
                    entry.getValue().stackIndex = 0;
                } else if (entry.getValue().stackIndex < entry.getValue().iterStacks.size() - 1) {
                    ++entry.getValue().stackIndex;
                }
                entry.getValue().renderStack = entry.getValue().iterStacks.get(entry.getValue().stackIndex);
            }
            this.stackSwitch = 20;
        } else {
            for (Map.Entry<TOreDictFilter, StackData> entry : this.oreDictStacks.entrySet()) {
                if (entry.getValue().iterStacks == null || entry.getValue().iterStacks.size() != 0) continue;
                entry.getValue().renderStack = null;
            }
        }
        HashSet<TOreDictFilter> filtersVisible = new HashSet<TOreDictFilter>();
        for (int i = 0; i < 4; ++i) {
            if (!(this.tileEntity.filters.get(this.getFilterIndex() + i) instanceof TOreDictFilter)) continue;
            filtersVisible.add((TOreDictFilter)this.tileEntity.filters.get(this.getFilterIndex() + i));
        }
        for (TransporterFilter filter : this.tileEntity.filters) {
            if (!(filter instanceof TOreDictFilter) || filtersVisible.contains(filter) || !this.oreDictStacks.containsKey(filter)) continue;
            this.oreDictStacks.remove(filter);
        }
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int button) {
        super.func_73864_a(mouseX, mouseY, button);
        int xAxis = mouseX - (this.field_73880_f - this.field_74194_b) / 2;
        int yAxis = mouseY - (this.field_73881_g - this.field_74195_c) / 2;
        if (button == 0) {
            if (xAxis >= 154 && xAxis <= 166 && yAxis >= this.getScroll() + 18 && yAxis <= this.getScroll() + 18 + 15) {
                this.dragOffset = yAxis - (this.getScroll() + 18);
                this.isDragging = true;
            }
            for (int i = 0; i < 4; ++i) {
                if (this.tileEntity.filters.get(this.getFilterIndex() + i) == null) continue;
                int yStart = i * 29 + 18;
                if (xAxis < 56 || xAxis > 152 || yAxis < yStart || yAxis > yStart + 29) continue;
                TransporterFilter filter = this.tileEntity.filters.get(this.getFilterIndex() + i);
                if (filter instanceof TItemStackFilter) {
                    this.field_73882_e.field_71416_A.func_77366_a("random.click", 1.0f, 1.0f);
                    PacketHandler.sendPacket(PacketHandler.Transmission.SERVER, new PacketLogisticalSorterGui().setParams(new Object[]{PacketLogisticalSorterGui.SorterGuiPacket.SERVER_INDEX, Object3D.get(this.tileEntity), 1, this.getFilterIndex() + i}), new Object[0]);
                    continue;
                }
                if (!(filter instanceof TOreDictFilter)) continue;
                this.field_73882_e.field_71416_A.func_77366_a("random.click", 1.0f, 1.0f);
                PacketHandler.sendPacket(PacketHandler.Transmission.SERVER, new PacketLogisticalSorterGui().setParams(new Object[]{PacketLogisticalSorterGui.SorterGuiPacket.SERVER_INDEX, Object3D.get(this.tileEntity), 2, this.getFilterIndex() + i}), new Object[0]);
            }
            if (xAxis >= 12 && xAxis <= 26 && yAxis >= 110 && yAxis <= 124) {
                ArrayList<Integer> data = new ArrayList<Integer>();
                data.add(1);
                PacketHandler.sendPacket(PacketHandler.Transmission.SERVER, new PacketTileEntity().setParams(Object3D.get(this.tileEntity), data), new Object[0]);
                this.field_73882_e.field_71416_A.func_77366_a("random.click", 1.0f, 1.0f);
            }
            if (xAxis >= 12 && xAxis <= 26 && yAxis >= 84 && yAxis <= 98) {
                ArrayList<Integer> data = new ArrayList<Integer>();
                data.add(2);
                PacketHandler.sendPacket(PacketHandler.Transmission.SERVER, new PacketTileEntity().setParams(Object3D.get(this.tileEntity), data), new Object[0]);
                this.field_73882_e.field_71416_A.func_77366_a("random.click", 1.0f, 1.0f);
            }
        }
        if (Keyboard.isKeyDown((int)42) && button == 0) {
            button = 2;
        }
        if (xAxis >= 13 && xAxis <= 29 && yAxis >= 137 && yAxis <= 153) {
            ArrayList<Integer> data = new ArrayList<Integer>();
            data.add(0);
            data.add(button);
            PacketHandler.sendPacket(PacketHandler.Transmission.SERVER, new PacketTileEntity().setParams(Object3D.get(this.tileEntity), data), new Object[0]);
            this.field_73882_e.field_71416_A.func_77366_a("mekanism:etc.Ding", 1.0f, 1.0f);
        }
    }

    protected void func_85041_a(int mouseX, int mouseY, int button, long ticks) {
        super.func_85041_a(mouseX, mouseY, button, ticks);
        int xAxis = mouseX - (this.field_73880_f - this.field_74194_b) / 2;
        int yAxis = mouseY - (this.field_73881_g - this.field_74195_c) / 2;
        if (this.isDragging) {
            this.scroll = Math.min(Math.max((float)(yAxis - 18 - this.dragOffset) / 123.0f, 0.0f), 1.0f);
        }
    }

    protected void func_73879_b(int x, int y, int type) {
        super.func_73879_b(x, y, type);
        if (type == 0 && this.isDragging) {
            this.dragOffset = 0;
            this.isDragging = false;
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int guiWidth = (this.field_73880_f - this.field_74194_b) / 2;
        int guiHeight = (this.field_73881_g - this.field_74195_c) / 2;
        this.field_73887_h.clear();
        this.field_73887_h.add(new GuiButton(0, guiWidth + 56, guiHeight + 136, 54, 20, MekanismUtils.localize("gui.itemstack")));
        this.field_73887_h.add(new GuiButton(1, guiWidth + 110, guiHeight + 136, 43, 20, MekanismUtils.localize("gui.oredict")));
    }

    protected void func_73875_a(GuiButton guibutton) {
        super.func_73875_a(guibutton);
        if (guibutton.field_73741_f == 0) {
            PacketHandler.sendPacket(PacketHandler.Transmission.SERVER, new PacketLogisticalSorterGui().setParams(new Object[]{PacketLogisticalSorterGui.SorterGuiPacket.SERVER, Object3D.get(this.tileEntity), 1}), new Object[0]);
        } else if (guibutton.field_73741_f == 1) {
            PacketHandler.sendPacket(PacketHandler.Transmission.SERVER, new PacketLogisticalSorterGui().setParams(new Object[]{PacketLogisticalSorterGui.SorterGuiPacket.SERVER, Object3D.get(this.tileEntity), 2}), new Object[0]);
        }
    }

    @Override
    protected void func_74189_g(int mouseX, int mouseY) {
        int xAxis = mouseX - (this.field_73880_f - this.field_74194_b) / 2;
        int yAxis = mouseY - (this.field_73881_g - this.field_74195_c) / 2;
        this.field_73886_k.func_78276_b(this.tileEntity.func_70303_b(), 43, 6, 0x404040);
        this.field_73886_k.func_78276_b(MekanismUtils.localize("gui.logisticalSorter.filters") + ":", 11, 19, 52480);
        this.field_73886_k.func_78276_b("T: " + this.tileEntity.filters.size(), 11, 28, 52480);
        this.field_73886_k.func_78276_b("IS: " + this.getItemStackFilters().size(), 11, 37, 52480);
        this.field_73886_k.func_78276_b("OD: " + this.getOreDictFilters().size(), 11, 46, 52480);
        this.field_73886_k.func_78276_b("RR:", 12, 74, 52480);
        this.field_73886_k.func_78276_b(this.tileEntity.roundRobin ? "On" : "Off", 27, 86, 52480);
        this.field_73886_k.func_78276_b(MekanismUtils.localize("gui.logisticalSorter.auto") + ":", 12, 100, 52480);
        this.field_73886_k.func_78276_b(this.tileEntity.autoEject ? "On" : "Off", 27, 112, 52480);
        this.field_73886_k.func_78276_b(MekanismUtils.localize("gui.logisticalSorter.default") + ":", 12, 126, 52480);
        for (int i = 0; i < 4; ++i) {
            if (this.tileEntity.filters.get(this.getFilterIndex() + i) == null) continue;
            TransporterFilter filter = this.tileEntity.filters.get(this.getFilterIndex() + i);
            int yStart = i * 29 + 18;
            if (filter instanceof TItemStackFilter) {
                TItemStackFilter itemFilter = (TItemStackFilter)filter;
                if (itemFilter.itemType != null) {
                    GL11.glPushMatrix();
                    GL11.glEnable((int)2896);
                    field_74196_a.func_82406_b(this.field_73886_k, this.field_73882_e.func_110434_K(), itemFilter.itemType, 59, yStart + 3);
                    GL11.glDisable((int)2896);
                    GL11.glPopMatrix();
                }
                this.field_73886_k.func_78276_b(MekanismUtils.localize("gui.itemFilter"), 78, yStart + 2, 0x404040);
                this.field_73886_k.func_78276_b(filter.color != null ? filter.color.getName() : MekanismUtils.localize("gui.none"), 78, yStart + 11, 0x404040);
                continue;
            }
            if (!(filter instanceof TOreDictFilter)) continue;
            TOreDictFilter oreFilter = (TOreDictFilter)filter;
            if (!this.oreDictStacks.containsKey(oreFilter)) {
                this.updateStackList(oreFilter);
            }
            if (this.oreDictStacks.get((Object)filter).renderStack != null) {
                try {
                    GL11.glPushMatrix();
                    GL11.glEnable((int)2896);
                    field_74196_a.func_82406_b(this.field_73886_k, this.field_73882_e.func_110434_K(), this.oreDictStacks.get((Object)filter).renderStack, 59, yStart + 3);
                    GL11.glDisable((int)2896);
                    GL11.glPopMatrix();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.field_73886_k.func_78276_b("OreDict Filter", 78, yStart + 2, 0x404040);
            this.field_73886_k.func_78276_b(filter.color != null ? filter.color.getName() : MekanismUtils.localize("gui.none"), 78, yStart + 11, 0x404040);
        }
        if (this.tileEntity.color != null) {
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)32826);
            this.field_73882_e.func_110434_K().func_110577_a(MekanismRenderer.getBlocksTexture());
            field_74196_a.func_94149_a(13, 137, MekanismRenderer.getColorIcon(this.tileEntity.color), 16, 16);
            GL11.glDisable((int)2896);
            GL11.glPopMatrix();
        }
        if (xAxis >= 13 && xAxis <= 29 && yAxis >= 137 && yAxis <= 153) {
            if (this.tileEntity.color != null) {
                this.func_74190_a(this.tileEntity.color.getName(), xAxis, yAxis);
            } else {
                this.func_74190_a(MekanismUtils.localize("gui.none"), xAxis, yAxis);
            }
        }
        if (xAxis >= 12 && xAxis <= 26 && yAxis >= 110 && yAxis <= 124) {
            this.func_74190_a(MekanismUtils.localize("gui.autoEject"), xAxis, yAxis);
        }
        if (xAxis >= 12 && xAxis <= 26 && yAxis >= 84 && yAxis <= 98) {
            this.func_74190_a(MekanismUtils.localize("gui.logisticalSorter.roundRobin"), xAxis, yAxis);
        }
        super.func_74189_g(mouseX, mouseY);
    }

    @Override
    protected void func_74185_a(float partialTick, int mouseX, int mouseY) {
        super.func_74185_a(partialTick, mouseX, mouseY);
        this.field_73882_e.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiLogisticalSorter.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_73880_f - this.field_74194_b) / 2;
        int guiHeight = (this.field_73881_g - this.field_74195_c) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_74194_b, this.field_74195_c);
        this.func_73729_b(guiWidth + 154, guiHeight + 18 + this.getScroll(), 232, 0, 12, 15);
        int xAxis = mouseX - (this.field_73880_f - this.field_74194_b) / 2;
        int yAxis = mouseY - (this.field_73881_g - this.field_74195_c) / 2;
        for (int i = 0; i < 4; ++i) {
            boolean mouseOver;
            if (this.tileEntity.filters.get(this.getFilterIndex() + i) == null) continue;
            TransporterFilter filter = this.tileEntity.filters.get(this.getFilterIndex() + i);
            int yStart = i * 29 + 18;
            boolean bl = mouseOver = xAxis >= 56 && xAxis <= 152 && yAxis >= yStart && yAxis <= yStart + 29;
            if (filter instanceof TItemStackFilter) {
                this.func_73729_b(guiWidth + 56, guiHeight + yStart, mouseOver ? 0 : 96, 166, 96, 29);
                continue;
            }
            if (!(filter instanceof TOreDictFilter)) continue;
            this.func_73729_b(guiWidth + 56, guiHeight + yStart, mouseOver ? 0 : 96, 195, 96, 29);
        }
        if (xAxis >= 12 && xAxis <= 26 && yAxis >= 110 && yAxis <= 124) {
            this.func_73729_b(guiWidth + 12, guiHeight + 110, 176, 0, 14, 14);
        } else {
            this.func_73729_b(guiWidth + 12, guiHeight + 110, 176, 14, 14, 14);
        }
        if (xAxis >= 12 && xAxis <= 26 && yAxis >= 84 && yAxis <= 98) {
            this.func_73729_b(guiWidth + 12, guiHeight + 84, 190, 0, 14, 14);
        } else {
            this.func_73729_b(guiWidth + 12, guiHeight + 84, 190, 14, 14, 14);
        }
    }

    public ArrayList getItemStackFilters() {
        ArrayList<TransporterFilter> list = new ArrayList<TransporterFilter>();
        for (TransporterFilter filter : this.tileEntity.filters) {
            if (!(filter instanceof TItemStackFilter)) continue;
            list.add(filter);
        }
        return list;
    }

    public ArrayList getOreDictFilters() {
        ArrayList<TransporterFilter> list = new ArrayList<TransporterFilter>();
        for (TransporterFilter filter : this.tileEntity.filters) {
            if (!(filter instanceof TOreDictFilter)) continue;
            list.add(filter);
        }
        return list;
    }

    private void updateStackList(TOreDictFilter filter) {
        if (!this.oreDictStacks.containsKey(filter)) {
            this.oreDictStacks.put(filter, new StackData());
        }
        if (this.oreDictStacks.get((Object)filter).iterStacks == null) {
            this.oreDictStacks.get((Object)filter).iterStacks = new ArrayList<ItemStack>();
        } else {
            this.oreDictStacks.get((Object)filter).iterStacks.clear();
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (String s : OreDictionary.getOreNames()) {
            if (filter.oreDictName.equals(s) || filter.oreDictName.equals("*")) {
                keys.add(s);
                continue;
            }
            if (filter.oreDictName.endsWith("*") && !filter.oreDictName.startsWith("*")) {
                if (!s.startsWith(filter.oreDictName.substring(0, filter.oreDictName.length() - 1))) continue;
                keys.add(s);
                continue;
            }
            if (filter.oreDictName.startsWith("*") && !filter.oreDictName.endsWith("*")) {
                if (!s.endsWith(filter.oreDictName.substring(1))) continue;
                keys.add(s);
                continue;
            }
            if (!filter.oreDictName.startsWith("*") || !filter.oreDictName.endsWith("*") || !s.contains(filter.oreDictName.substring(1, filter.oreDictName.length() - 1))) continue;
            keys.add(s);
        }
        for (String key : keys) {
            for (ItemStack stack : OreDictionary.getOres((String)key)) {
                ItemStack toAdd = stack.func_77946_l();
                if (this.oreDictStacks.get((Object)filter).iterStacks.contains(stack)) continue;
                this.oreDictStacks.get((Object)filter).iterStacks.add(stack.func_77946_l());
            }
        }
        this.stackSwitch = 0;
        this.func_73876_c();
        this.oreDictStacks.get((Object)filter).stackIndex = -1;
    }

    public static class StackData {
        public List<ItemStack> iterStacks;
        public int stackIndex;
        public ItemStack renderStack;
    }
}

