/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.nei;

import codechicken.core.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public abstract class AdvancedMachineRecipeHandler
extends TemplateRecipeHandler {
    private int ticksPassed;

    public abstract String getRecipeId();

    public abstract ItemStack getFuelStack();

    public abstract Set<Map.Entry<ItemStack, ItemStack>> getRecipes();

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)12, (int)0, (int)28, (int)5, (int)144, (int)68);
    }

    public void drawExtras(int i) {
        float f = this.ticksPassed >= 40 ? (float)((this.ticksPassed - 40) % 20) / 20.0f : 0.0f;
        this.drawProgressBar(63, 34, 176, 0, 24, 7, f, 0);
        float f2 = f = this.ticksPassed >= 20 && this.ticksPassed < 40 ? (float)((this.ticksPassed - 20) % 20) / 20.0f : 1.0f;
        if (this.ticksPassed < 20) {
            f = 0.0f;
        }
        this.drawProgressBar(45, 32, 176, 7, 5, 12, f, 3);
        f = this.ticksPassed <= 20 ? (float)this.ticksPassed / 20.0f : 1.0f;
        this.drawProgressBar(149, 12, 176, 19, 4, 52, f, 3);
    }

    public void onUpdate() {
        super.onUpdate();
        ++this.ticksPassed;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(63, 34, 24, 7), this.getRecipeId(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry<ItemStack, ItemStack> irecipe : this.getRecipes()) {
                this.arecipes.add(new CachedIORecipe(irecipe, this.getFuelStack()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Map.Entry<ItemStack, ItemStack> irecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.getValue(), (ItemStack)result)) continue;
            this.arecipes.add(new CachedIORecipe(irecipe, this.getFuelStack()));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Map.Entry<ItemStack, ItemStack> irecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.getKey(), (ItemStack)ingredient)) continue;
            this.arecipes.add(new CachedIORecipe(irecipe, this.getFuelStack()));
        }
    }

    public class CachedIORecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public PositionedStack inputStack;
        public PositionedStack outputStack;
        public PositionedStack fuelStack;

        public PositionedStack getIngredient() {
            return this.inputStack;
        }

        public PositionedStack getResult() {
            return this.outputStack;
        }

        public PositionedStack getOtherStack() {
            return this.fuelStack;
        }

        public CachedIORecipe(ItemStack input, ItemStack output, ItemStack fuel) {
            super((TemplateRecipeHandler)AdvancedMachineRecipeHandler.this);
            this.inputStack = new PositionedStack((Object)input, 40, 12);
            this.outputStack = new PositionedStack((Object)output, 100, 30);
            this.fuelStack = new PositionedStack((Object)fuel, 40, 48);
        }

        public CachedIORecipe(Map.Entry recipe, ItemStack fuel) {
            this((ItemStack)recipe.getKey(), (ItemStack)recipe.getValue(), fuel);
        }
    }
}

