/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.ShapedRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mekanism.api.energy.IEnergizedItem;
import mekanism.common.IEnergyCube;
import mekanism.common.IFactory;
import mekanism.common.MekanismRecipe;
import mekanism.common.block.BlockMachine;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;

public class MekanismRecipeHandler
extends ShapedRecipeHandler {
    public String getRecipeName() {
        return "Shaped Mekanism Crafting";
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("crafting") && ((Object)((Object)this)).getClass() == MekanismRecipeHandler.class) {
            List allrecipes = CraftingManager.func_77594_a().func_77592_b();
            for (IRecipe irecipe : allrecipes) {
                if (!(irecipe instanceof MekanismRecipe)) continue;
                MekanismRecipe energyRecipe = (MekanismRecipe)irecipe;
                CachedEnergyRecipe recipe = new CachedEnergyRecipe(energyRecipe.width, energyRecipe.height, energyRecipe.getInput(), energyRecipe.func_77571_b());
                this.arecipes.add(recipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        List allrecipes = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe irecipe : allrecipes) {
            if (!(irecipe instanceof MekanismRecipe) || !MekanismRecipeHandler.areItemsEqual(irecipe.func_77571_b(), result)) continue;
            MekanismRecipe energyRecipe = (MekanismRecipe)irecipe;
            CachedEnergyRecipe recipe = new CachedEnergyRecipe(energyRecipe.width, energyRecipe.height, energyRecipe.getInput(), energyRecipe.func_77571_b());
            this.arecipes.add(recipe);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List allrecipes = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe irecipe : allrecipes) {
            MekanismRecipe energyRecipe;
            CachedEnergyRecipe recipe;
            if (!(irecipe instanceof MekanismRecipe) || !(recipe = new CachedEnergyRecipe(energyRecipe.width, energyRecipe.height, (energyRecipe = (MekanismRecipe)irecipe).getInput(), energyRecipe.func_77571_b())).contains(recipe.ingredients, ingredient)) continue;
            recipe.setIngredientPermutation(recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
        }
    }

    public static boolean areItemsEqual(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null && stack2 != null || stack1 != null && stack2 == null) {
            return false;
        }
        if (stack1 == null && stack2 == null) {
            return true;
        }
        if (stack1.field_77993_c != stack2.field_77993_c) {
            return false;
        }
        if (!(stack1.func_77973_b() instanceof IEnergizedItem) && !(stack2.func_77973_b() instanceof IEnergizedItem)) {
            if (stack1.func_77960_j() != stack2.func_77960_j()) {
                return false;
            }
        } else {
            if (((IEnergizedItem)stack1.func_77973_b()).isMetadataSpecific() && ((IEnergizedItem)stack2.func_77973_b()).isMetadataSpecific() && stack1.func_77960_j() != stack2.func_77960_j()) {
                return false;
            }
            if (stack1.func_77973_b() instanceof IEnergyCube && stack2.func_77973_b() instanceof IEnergyCube ? ((IEnergyCube)stack1.func_77973_b()).getEnergyCubeTier(stack1) != ((IEnergyCube)stack2.func_77973_b()).getEnergyCubeTier(stack2) : stack1.func_77973_b() instanceof IFactory && stack2.func_77973_b() instanceof IFactory && MekanismRecipeHandler.isFactory(stack1) && MekanismRecipeHandler.isFactory(stack2) && ((IFactory)stack1.func_77973_b()).getRecipeType(stack1) != ((IFactory)stack2.func_77973_b()).getRecipeType(stack2)) {
                return false;
            }
        }
        return true;
    }

    private static boolean isFactory(ItemStack stack) {
        return BlockMachine.MachineType.get(stack) == BlockMachine.MachineType.BASIC_FACTORY || BlockMachine.MachineType.get(stack) == BlockMachine.MachineType.ADVANCED_FACTORY || BlockMachine.MachineType.get(stack) == BlockMachine.MachineType.ELITE_FACTORY;
    }

    public class CachedEnergyRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> ingredients;
        public PositionedStack result;

        public CachedEnergyRecipe(int width, int height, Object[] items, ItemStack out) {
            super((TemplateRecipeHandler)MekanismRecipeHandler.this);
            this.result = new PositionedStack((Object)out, 119, 24);
            this.ingredients = new ArrayList();
            this.setIngredients(width, height, items);
        }

        public void setIngredients(int width, int height, Object[] items) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (items[y * width + x] == null) continue;
                    PositionedStack stack = new PositionedStack(items[y * width + x], 25 + x * 18, 6 + y * 18);
                    stack.setMaxSize(1);
                    this.ingredients.add(stack);
                }
            }
        }

        public ArrayList<PositionedStack> getIngredients() {
            return (ArrayList)this.getCycledIngredients(MekanismRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public boolean contains(Collection<PositionedStack> ingredients, ItemStack ingredient) {
            for (PositionedStack stack : ingredients) {
                for (ItemStack item : stack.items) {
                    if (!MekanismRecipeHandler.areItemsEqual(item, ingredient)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

