/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.List;
import mekanism.api.EnumColor;
import mekanism.api.gas.GasRegistry;
import mekanism.common.ISpecialBounds;
import mekanism.common.ObfuscatedNames;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Timer;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.fluids.Fluid;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class MekanismRenderer {
    private static RenderBlocks renderBlocks = new RenderBlocks();
    public static Icon[] colors = new Icon[256];
    public static Icon energyIcon;
    private static float lightmapLastX;
    private static float lightmapLastY;
    private static boolean optifineBreak;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new MekanismRenderer());
    }

    @ForgeSubscribe
    public void onStitch(TextureStitchEvent.Pre event) {
        if (event.map.field_94255_a == 0) {
            for (EnumColor color : EnumColor.values()) {
                MekanismRenderer.colors[color.ordinal()] = event.map.func_94245_a("mekanism:overlay/Overlay" + color.getLocalizedName().replace(" ", ""));
            }
            energyIcon = event.map.func_94245_a("mekanism:LiquidEnergy");
            GasRegistry.getGas("hydrogen").setIcon(event.map.func_94245_a("mekanism:LiquidHydrogen"));
            GasRegistry.getGas("oxygen").setIcon(event.map.func_94245_a("mekanism:LiquidOxygen"));
        }
    }

    public static void renderObject(Model3D object) {
        if (object == null) {
            return;
        }
        MekanismRenderer.renderBlocks.field_83026_h = object.maxX;
        MekanismRenderer.renderBlocks.field_83021_g = object.minX;
        MekanismRenderer.renderBlocks.field_83024_j = object.maxY;
        MekanismRenderer.renderBlocks.field_83027_i = object.minY;
        MekanismRenderer.renderBlocks.field_83022_l = object.maxZ;
        MekanismRenderer.renderBlocks.field_83025_k = object.minZ;
        MekanismRenderer.renderBlocks.field_78677_m = false;
        Tessellator.field_78398_a.func_78382_b();
        if (object.shouldSideRender(ForgeDirection.DOWN)) {
            renderBlocks.func_78613_a(null, 0.0, 0.0, 0.0, object.getBlockTextureFromSide(0));
        }
        if (object.shouldSideRender(ForgeDirection.UP)) {
            renderBlocks.func_78617_b(null, 0.0, 0.0, 0.0, object.getBlockTextureFromSide(1));
        }
        if (object.shouldSideRender(ForgeDirection.NORTH)) {
            renderBlocks.func_78611_c(null, 0.0, 0.0, 0.0, object.getBlockTextureFromSide(2));
        }
        if (object.shouldSideRender(ForgeDirection.SOUTH)) {
            renderBlocks.func_78622_d(null, 0.0, 0.0, 0.0, object.getBlockTextureFromSide(3));
        }
        if (object.shouldSideRender(ForgeDirection.WEST)) {
            renderBlocks.func_78573_e(null, 0.0, 0.0, 0.0, object.getBlockTextureFromSide(4));
        }
        if (object.shouldSideRender(ForgeDirection.EAST)) {
            renderBlocks.func_78605_f(null, 0.0, 0.0, 0.0, object.getBlockTextureFromSide(5));
        }
        if (Tessellator.field_78398_a.field_78415_z) {
            Tessellator.field_78398_a.func_78381_a();
        }
    }

    public static Icon getColorIcon(EnumColor color) {
        return colors[color.ordinal()];
    }

    public static void glowOn() {
        MekanismRenderer.glowOn(15);
    }

    public static void glowOn(int glow) {
        GL11.glPushAttrib((int)64);
        try {
            lightmapLastX = OpenGlHelper.lastBrightnessX;
            lightmapLastY = OpenGlHelper.lastBrightnessY;
        }
        catch (NoSuchFieldError e) {
            optifineBreak = true;
        }
        RenderHelper.func_74518_a();
        float glowRatioX = Math.min((float)glow / 15.0f * 240.0f + lightmapLastX, 240.0f);
        float glowRatioY = Math.min((float)glow / 15.0f * 240.0f + lightmapLastY, 240.0f);
        if (!optifineBreak) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)glowRatioX, (float)glowRatioY);
        }
    }

    public static void glowOff() {
        if (!optifineBreak) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightmapLastX, (float)lightmapLastY);
        }
        GL11.glPopAttrib();
    }

    public static void blendOn() {
        GL11.glPushAttrib((int)16448);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
    }

    public static void blendOff() {
        GL11.glPopAttrib();
    }

    public static void renderItem(ItemStack item) {
        Icon icon = item.func_77973_b().func_77650_f(item);
        TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
        if (icon == null) {
            GL11.glPopMatrix();
            return;
        }
        texturemanager.func_110577_a(texturemanager.func_130087_a(item.func_94608_d()));
        Tessellator tessellator = Tessellator.field_78398_a;
        float minU = icon.func_94209_e();
        float maxU = icon.func_94212_f();
        float minV = icon.func_94206_g();
        float maxV = icon.func_94210_h();
        GL11.glEnable((int)32826);
        GL11.glTranslatef((float)0.0f, (float)-0.3f, (float)0.0f);
        GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
        GL11.glRotatef((float)50.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)335.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)-0.9375f, (float)-0.0625f, (float)0.0f);
        ItemRenderer cfr_ignored_0 = RenderManager.field_78727_a.field_78721_f;
        ItemRenderer.func_78439_a((Tessellator)tessellator, (float)maxU, (float)minV, (float)minU, (float)maxV, (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
        GL11.glDisable((int)32826);
    }

    public static void renderItem(RenderBlocks renderer, int metadata, Block block) {
        if (!(block instanceof ISpecialBounds) || ((ISpecialBounds)block).doDefaultBoundSetting(metadata)) {
            block.func_71919_f();
        }
        if (block instanceof ISpecialBounds) {
            ((ISpecialBounds)block).setRenderBounds(block, metadata);
        }
        if (!(block instanceof ISpecialBounds) || ((ISpecialBounds)block).doDefaultBoundSetting(metadata)) {
            renderer.func_83018_a(block);
        } else {
            renderer.func_83020_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
        if (renderer.field_78668_c) {
            int renderColor = block.func_71889_f_(metadata);
            float red = (float)(renderColor >> 16 & 0xFF) / 255.0f;
            float green = (float)(renderColor >> 8 & 0xFF) / 255.0f;
            float blue = (float)(renderColor & 0xFF) / 255.0f;
            GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
        }
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_78613_a(block, 0.0, 0.0, 0.0, block.func_71858_a(0, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_78617_b(block, 0.0, 0.0, 0.0, block.func_71858_a(1, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_78611_c(block, 0.0, 0.0, 0.0, block.func_71858_a(2, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_78622_d(block, 0.0, 0.0, 0.0, block.func_71858_a(3, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_78573_e(block, 0.0, 0.0, 0.0, block.func_71858_a(4, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_78605_f(block, 0.0, 0.0, 0.0, block.func_71858_a(5, metadata));
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public static void colorFluid(Fluid fluid) {
        int color = fluid.getColor();
        float cR = (float)(color >> 16 & 0xFF) / 255.0f;
        float cG = (float)(color >> 8 & 0xFF) / 255.0f;
        float cB = (float)(color & 0xFF) / 255.0f;
        GL11.glColor3f((float)cR, (float)cG, (float)cB);
    }

    public static TextureMap getTextureMap(int type) {
        try {
            List l = (List)MekanismUtils.getPrivateValue(Minecraft.func_71410_x().field_71446_o, TextureManager.class, ObfuscatedNames.TextureManager_listTickables);
            for (Object obj : l) {
                if (!(obj instanceof TextureMap) || ((TextureMap)obj).field_94255_a != type) continue;
                return (TextureMap)obj;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static float getPartialTick() {
        try {
            Timer t = (Timer)MekanismUtils.getPrivateValue(Minecraft.func_71410_x(), Minecraft.class, ObfuscatedNames.Minecraft_timer);
            return t.field_74281_c;
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    public void drawTexturedModalRect(int par1, int par2, int par3, int par4, int par5, int par6) {
        boolean zLevel = false;
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(par1 + 0), (double)(par2 + par6), (double)zLevel, (double)((float)(par3 + 0) * f), (double)((float)(par4 + par6) * f1));
        tessellator.func_78374_a((double)(par1 + par5), (double)(par2 + par6), (double)zLevel, (double)((float)(par3 + par5) * f), (double)((float)(par4 + par6) * f1));
        tessellator.func_78374_a((double)(par1 + par5), (double)(par2 + 0), (double)zLevel, (double)((float)(par3 + par5) * f), (double)((float)(par4 + 0) * f1));
        tessellator.func_78374_a((double)(par1 + 0), (double)(par2 + 0), (double)zLevel, (double)((float)(par3 + 0) * f), (double)((float)(par4 + 0) * f1));
        tessellator.func_78381_a();
    }

    public static ResourceLocation getBlocksTexture() {
        return TextureMap.field_110575_b;
    }

    public static ResourceLocation getItemsTexture() {
        return TextureMap.field_110576_c;
    }

    static {
        optifineBreak = false;
    }

    public static class BooleanArray {
        private final boolean[] boolArray;

        public BooleanArray(boolean[] array) {
            this.boolArray = (boolean[])array.clone();
        }

        public boolean equals(Object o) {
            if (o instanceof BooleanArray) {
                return Arrays.equals(this.boolArray, ((BooleanArray)o).boolArray);
            }
            if (o instanceof boolean[]) {
                return Arrays.equals(this.boolArray, (boolean[])o);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.boolArray);
        }
    }

    public static class DisplayInteger {
        public int display;

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.display;
            return code;
        }

        public boolean equals(Object obj) {
            return obj instanceof DisplayInteger && ((DisplayInteger)obj).display == this.display;
        }

        public static DisplayInteger createAndStart() {
            DisplayInteger newInteger = new DisplayInteger();
            newInteger.display = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)newInteger.display, (int)4864);
            return newInteger;
        }

        public static void endList() {
            GL11.glEndList();
        }

        public void render() {
            GL11.glCallList((int)this.display);
        }
    }

    public static class Model3D {
        public double minX;
        public double minY;
        public double minZ;
        public double maxX;
        public double maxY;
        public double maxZ;
        public Icon[] textures = new Icon[6];
        public boolean[] renderSides = new boolean[]{true, true, true, true, true, true, false};
        public Block baseBlock = Block.field_71939_E;

        public final void setBlockBounds(float xNeg, float yNeg, float zNeg, float xPos, float yPos, float zPos) {
            this.minX = xNeg;
            this.minY = yNeg;
            this.minZ = zNeg;
            this.maxX = xPos;
            this.maxY = yPos;
            this.maxZ = zPos;
        }

        public void setSideRender(ForgeDirection side, boolean value) {
            this.renderSides[side.ordinal()] = value;
        }

        public boolean shouldSideRender(ForgeDirection side) {
            return this.renderSides[side.ordinal()];
        }

        public Icon getBlockTextureFromSide(int i) {
            return this.textures[i];
        }

        public void setTexture(Icon tex) {
            Arrays.fill(this.textures, tex);
        }

        public void setTextures(Icon down, Icon up, Icon north, Icon south, Icon west, Icon east) {
            this.textures[0] = down;
            this.textures[1] = up;
            this.textures[2] = north;
            this.textures[3] = south;
            this.textures[4] = west;
            this.textures[5] = east;
        }
    }
}

