/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.Random;
import mekanism.api.EnumColor;
import mekanism.api.Object3D;
import mekanism.common.Mekanism;
import mekanism.common.item.ItemJetpack;
import mekanism.common.item.ItemScubaTank;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntityFlameFX;
import net.minecraft.client.particle.EntitySmokeFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import universalelectricity.core.vector.Vector3;

@SideOnly(value=Side.CLIENT)
public class RenderTickHandler
implements ITickHandler {
    public Random rand = new Random();
    public Minecraft mc = Minecraft.func_71410_x();

    public void tickStart(EnumSet<TickType> type, Object ... tickData) {
    }

    public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
        float partialTick = ((Float)tickData[0]).floatValue();
        if (this.mc.field_71439_g != null && this.mc.field_71441_e != null) {
            EntityClientPlayerMP player = this.mc.field_71439_g;
            World world = this.mc.field_71439_g.field_70170_p;
            FontRenderer font = this.mc.field_71466_p;
            MovingObjectPosition pos = player.func_70614_a(40.0, 1.0f);
            if (pos != null) {
                int x = MathHelper.func_76128_c((double)pos.field_72311_b);
                int y = MathHelper.func_76128_c((double)pos.field_72312_c);
                int z = MathHelper.func_76128_c((double)pos.field_72309_d);
                Object3D obj = new Object3D(x, y, z);
                if (Mekanism.debug && this.mc.field_71462_r == null && !this.mc.field_71474_y.field_74330_P) {
                    String tileDisplay = "";
                    if (obj.getTileEntity((IBlockAccess)world) != null && obj.getTileEntity((IBlockAccess)world).getClass() != null) {
                        tileDisplay = obj.getTileEntity((IBlockAccess)world).getClass().getSimpleName();
                    }
                    font.func_78261_a("Block ID: " + obj.getBlockId((IBlockAccess)world), 1, 1, 0x404040);
                    font.func_78261_a("Metadata: " + obj.getMetadata((IBlockAccess)world), 1, 10, 0x404040);
                    font.func_78261_a("TileEntity: " + tileDisplay, 1, 19, 0x404040);
                    font.func_78261_a("Side: " + pos.field_72310_e, 1, 28, 0x404040);
                }
            }
            if (player != null && !(this.mc.field_71462_r instanceof GuiChat) && player.func_71124_b(3) != null) {
                ItemStack stack = player.func_71124_b(3);
                ScaledResolution scaledresolution = new ScaledResolution(this.mc.field_71474_y, this.mc.field_71443_c, this.mc.field_71440_d);
                int x = scaledresolution.func_78326_a();
                int y = scaledresolution.func_78328_b();
                if (stack.func_77973_b() instanceof ItemJetpack) {
                    ItemJetpack jetpack = (ItemJetpack)stack.func_77973_b();
                    font.func_78261_a("Mode: " + jetpack.getMode(stack).getName(), 1, y - 20, 0x404040);
                    font.func_78261_a("Hydrogen: " + jetpack.getStored(stack), 1, y - 11, 0x404040);
                } else if (stack.func_77973_b() instanceof ItemScubaTank) {
                    ItemScubaTank scubaTank = (ItemScubaTank)stack.func_77973_b();
                    String state = scubaTank.getFlowing(stack) ? (Object)((Object)EnumColor.DARK_GREEN) + "On" : (Object)((Object)EnumColor.DARK_RED) + "Off";
                    font.func_78261_a("Mode: " + state, 1, y - 20, 0x404040);
                    font.func_78261_a("Oxygen: " + scubaTank.getStored(stack), 1, y - 11, 0x404040);
                }
            }
            for (String s : Mekanism.jetpackOn) {
                EntityPlayer p = this.mc.field_71441_e.func_72924_a(s);
                if (p == null) continue;
                Vector3 playerPos = new Vector3((Entity)p);
                if (p != this.mc.field_71439_g) {
                    playerPos.translate(new Vector3(0.0, 1.7, 0.0));
                }
                float random = (this.rand.nextFloat() - 0.5f) * 0.1f;
                Vector3 vLeft = new Vector3();
                vLeft.z -= 0.54;
                vLeft.x -= 0.43;
                vLeft.rotate(p.field_70761_aq);
                vLeft.y -= 0.55;
                Vector3 vRight = new Vector3();
                vRight.z -= 0.54;
                vRight.x += 0.43;
                vRight.rotate(p.field_70761_aq);
                vRight.y -= 0.55;
                Vector3 vCenter = new Vector3();
                vCenter.z -= 0.3;
                vCenter.x = (this.rand.nextFloat() - 0.5f) * 0.4f;
                vCenter.rotate(p.field_70761_aq);
                vCenter.y -= 0.86;
                Vector3 rLeft = vLeft.clone().scale(random);
                Vector3 rRight = vRight.clone().scale(random);
                Vector3 mLeft = Vector3.translate(vLeft.clone().scale(0.2), new Vector3(p.field_70159_w, p.field_70181_x, p.field_70179_y));
                Vector3 mRight = Vector3.translate(vRight.clone().scale(0.2), new Vector3(p.field_70159_w, p.field_70181_x, p.field_70179_y));
                Vector3 mCenter = Vector3.translate(vCenter.clone().scale(0.2), new Vector3(p.field_70159_w, p.field_70181_x, p.field_70179_y));
                mLeft.translate(rLeft);
                mRight.translate(rRight);
                Vector3 v = new Vector3(playerPos).translate(vLeft);
                this.spawnAndSetParticle("flame", world, v.x, v.y, v.z, mLeft.x, mLeft.y, mLeft.z);
                this.spawnAndSetParticle("smoke", world, v.x, v.y, v.z, mLeft.x, mLeft.y, mLeft.z);
                v = new Vector3(playerPos).translate(vRight);
                this.spawnAndSetParticle("flame", world, v.x, v.y, v.z, mRight.x, mRight.y, mRight.z);
                this.spawnAndSetParticle("smoke", world, v.x, v.y, v.z, mRight.x, mRight.y, mRight.z);
                v = new Vector3(playerPos).translate(vCenter);
                this.spawnAndSetParticle("flame", world, v.x, v.y, v.z, mCenter.x, mCenter.y, mCenter.z);
                this.spawnAndSetParticle("smoke", world, v.x, v.y, v.z, mCenter.x, mCenter.y, mCenter.z);
            }
        }
    }

    public void spawnAndSetParticle(String s, World world, double x, double y, double z, double velX, double velY, double velZ) {
        EntityFlameFX fx = null;
        if (s.equals("flame")) {
            fx = new EntityFlameFX(world, x, y, z, velX, velY, velZ);
        } else if (s.equals("smoke")) {
            fx = new EntitySmokeFX(world, x, y, z, velX, velY, velZ);
        }
        fx.field_70169_q = fx.field_70165_t = x;
        fx.field_70167_r = fx.field_70163_u = y;
        fx.field_70166_s = fx.field_70161_v = z;
        this.mc.field_71452_i.func_78873_a((EntityFX)fx);
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.RENDER);
    }

    public String getLabel() {
        return "MekanismRender";
    }
}

