/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import mekanism.api.Object3D;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.SynchronizedTankData;
import mekanism.common.tileentity.TileEntityDynamicTank;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderDynamicTank
extends TileEntitySpecialRenderer {
    private static Map<RenderData, HashMap<Fluid, MekanismRenderer.DisplayInteger[]>> cachedCenterFluids = new HashMap<RenderData, HashMap<Fluid, MekanismRenderer.DisplayInteger[]>>();
    private static Map<ValveRenderData, HashMap<Fluid, MekanismRenderer.DisplayInteger>> cachedValveFluids = new HashMap<ValveRenderData, HashMap<Fluid, MekanismRenderer.DisplayInteger>>();

    public void func_76894_a(TileEntity tileEntity, double x, double y, double z, float partialTick) {
        this.renderAModelAt((TileEntityDynamicTank)tileEntity, x, y, z, partialTick);
    }

    public void renderAModelAt(TileEntityDynamicTank tileEntity, double x, double y, double z, float partialTick) {
        if (tileEntity.clientHasStructure && tileEntity.isRendering && tileEntity.structure != null && tileEntity.structure.fluidStored != null && tileEntity.structure.fluidStored.amount != 0) {
            RenderData data = new RenderData();
            data.location = tileEntity.structure.renderLocation;
            data.height = tileEntity.structure.volHeight;
            data.length = tileEntity.structure.volLength;
            data.width = tileEntity.structure.volWidth;
            this.func_110628_a(MekanismRenderer.getBlocksTexture());
            if (data.location != null && data.height > 0 && tileEntity.structure.fluidStored.getFluid() != null) {
                this.push();
                GL11.glTranslated((double)this.getX(data.location.xCoord), (double)this.getY(data.location.yCoord), (double)this.getZ(data.location.zCoord));
                MekanismRenderer.glowOn(tileEntity.structure.fluidStored.getFluid().getLuminosity());
                MekanismRenderer.DisplayInteger[] displayList = this.getListAndRender(data, tileEntity.structure.fluidStored.getFluid(), tileEntity.field_70331_k);
                if (tileEntity.structure.fluidStored.getFluid().isGaseous()) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min(1.0f, (float)tileEntity.structure.fluidStored.amount / (float)tileEntity.clientCapacity + 0.3f));
                    displayList[this.getStages(data.height) - 1].render();
                } else {
                    displayList[(int)((float)tileEntity.structure.fluidStored.amount / (float)tileEntity.clientCapacity * ((float)this.getStages(data.height) - 1.0f))].render();
                }
                MekanismRenderer.glowOff();
                this.pop();
                for (SynchronizedTankData.ValveData valveData : tileEntity.valveViewing.keySet()) {
                    if (tileEntity.valveViewing.get(valveData) <= 0) continue;
                    this.push();
                    GL11.glTranslated((double)this.getX(valveData.location.xCoord), (double)this.getY(valveData.location.yCoord), (double)this.getZ(valveData.location.zCoord));
                    MekanismRenderer.glowOn(tileEntity.structure.fluidStored.getFluid().getLuminosity());
                    this.getValveDisplay(ValveRenderData.get(data, valveData), tileEntity.structure.fluidStored.getFluid(), tileEntity.field_70331_k).render();
                    MekanismRenderer.glowOff();
                    this.pop();
                }
            }
        }
    }

    private void pop() {
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private void push() {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glBlendFunc((int)770, (int)771);
    }

    private MekanismRenderer.DisplayInteger[] getListAndRender(RenderData data, Fluid fluid, World world) {
        if (cachedCenterFluids.containsKey(data) && cachedCenterFluids.get(data).containsKey(fluid)) {
            return cachedCenterFluids.get(data).get(fluid);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Block.field_71943_B;
        toReturn.setTexture(fluid.getIcon());
        int stages = this.getStages(data.height);
        MekanismRenderer.DisplayInteger[] displays = new MekanismRenderer.DisplayInteger[stages];
        if (cachedCenterFluids.containsKey(data)) {
            cachedCenterFluids.get(data).put(fluid, displays);
        } else {
            HashMap<Fluid, MekanismRenderer.DisplayInteger[]> map = new HashMap<Fluid, MekanismRenderer.DisplayInteger[]>();
            map.put(fluid, displays);
            cachedCenterFluids.put(data, map);
        }
        MekanismRenderer.colorFluid(fluid);
        for (int i = 0; i < stages; ++i) {
            displays[i] = MekanismRenderer.DisplayInteger.createAndStart();
            if (fluid.getIcon() != null) {
                toReturn.minX = 0.01;
                toReturn.minY = 0.01;
                toReturn.minZ = 0.01;
                toReturn.maxX = (double)data.length - 0.01;
                toReturn.maxY = (double)((float)i / (float)stages * (float)(data.height - 2)) - 0.01;
                toReturn.maxZ = (double)data.width - 0.01;
                MekanismRenderer.renderObject(toReturn);
            }
            GL11.glEndList();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return displays;
    }

    private MekanismRenderer.DisplayInteger getValveDisplay(ValveRenderData data, Fluid fluid, World world) {
        if (cachedValveFluids.containsKey(data) && cachedValveFluids.get(data).containsKey(fluid)) {
            return cachedValveFluids.get(data).get(fluid);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Block.field_71943_B;
        toReturn.setTexture(fluid.getFlowingIcon());
        MekanismRenderer.DisplayInteger display = MekanismRenderer.DisplayInteger.createAndStart();
        if (cachedValveFluids.containsKey(data)) {
            cachedValveFluids.get(data).put(fluid, display);
        } else {
            HashMap<Fluid, MekanismRenderer.DisplayInteger> map = new HashMap<Fluid, MekanismRenderer.DisplayInteger>();
            map.put(fluid, display);
            cachedValveFluids.put(data, map);
        }
        MekanismRenderer.colorFluid(fluid);
        switch (data.side) {
            case DOWN: {
                toReturn.minX = 0.3;
                toReturn.minY = 1.01;
                toReturn.minZ = 0.3;
                toReturn.maxX = 0.7;
                toReturn.maxY = 1.5;
                toReturn.maxZ = 0.7;
                break;
            }
            case UP: {
                toReturn.minX = 0.3;
                toReturn.minY = (double)(-(data.height - 2)) - 0.01;
                toReturn.minZ = 0.3;
                toReturn.maxX = 0.7;
                toReturn.maxY = -0.01;
                toReturn.maxZ = 0.7;
                break;
            }
            case NORTH: {
                toReturn.minX = 0.3;
                toReturn.minY = (double)(-this.getValveFluidHeight(data)) + 0.01;
                toReturn.minZ = 1.02;
                toReturn.maxX = 0.7;
                toReturn.maxY = 0.7;
                toReturn.maxZ = 1.4;
                break;
            }
            case SOUTH: {
                toReturn.minX = 0.3;
                toReturn.minY = (double)(-this.getValveFluidHeight(data)) + 0.01;
                toReturn.minZ = -0.4;
                toReturn.maxX = 0.7;
                toReturn.maxY = 0.7;
                toReturn.maxZ = -0.02;
                break;
            }
            case WEST: {
                toReturn.minX = 1.02;
                toReturn.minY = (double)(-this.getValveFluidHeight(data)) + 0.01;
                toReturn.minZ = 0.3;
                toReturn.maxX = 1.4;
                toReturn.maxY = 0.7;
                toReturn.maxZ = 0.7;
                break;
            }
            case EAST: {
                toReturn.minX = -0.4;
                toReturn.minY = (double)(-this.getValveFluidHeight(data)) + 0.01;
                toReturn.minZ = 0.3;
                toReturn.maxX = -0.02;
                toReturn.maxY = 0.7;
                toReturn.maxZ = 0.7;
                break;
            }
        }
        MekanismRenderer.renderObject(toReturn);
        display.endList();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return display;
    }

    private int getValveFluidHeight(ValveRenderData data) {
        return data.valveLocation.yCoord - data.location.yCoord;
    }

    private int getStages(int height) {
        return (height - 2) * 1600;
    }

    private double getX(int x) {
        return (double)x - TileEntityRenderer.field_76961_b;
    }

    private double getY(int y) {
        return (double)y - TileEntityRenderer.field_76962_c;
    }

    private double getZ(int z) {
        return (double)z - TileEntityRenderer.field_76959_d;
    }

    public static class ValveRenderData
    extends RenderData {
        public ForgeDirection side;
        public Object3D valveLocation;

        public static ValveRenderData get(RenderData renderData, SynchronizedTankData.ValveData valveData) {
            ValveRenderData data = new ValveRenderData();
            data.location = renderData.location;
            data.height = renderData.height;
            data.length = renderData.length;
            data.width = renderData.width;
            data.side = valveData.side;
            data.valveLocation = valveData.location;
            return data;
        }

        @Override
        public boolean equals(Object data) {
            return data instanceof ValveRenderData && super.equals(data) && ((ValveRenderData)data).side.equals((Object)this.side);
        }

        @Override
        public int hashCode() {
            int code = 1;
            code = 31 * code + super.hashCode();
            code = 31 * code + this.side.ordinal();
            code = 31 * code + this.valveLocation.hashCode();
            return code;
        }
    }

    public static class RenderData {
        public Object3D location;
        public int height;
        public int length;
        public int width;

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.location.hashCode();
            code = 31 * code + this.height;
            code = 31 * code + this.length;
            code = 31 * code + this.width;
            return code;
        }

        public boolean equals(Object data) {
            return data instanceof RenderData && ((RenderData)data).location.equals(this.location) && ((RenderData)data).height == this.height && ((RenderData)data).length == this.length && ((RenderData)data).width == this.width;
        }
    }
}

