/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import mekanism.api.Object3D;
import mekanism.client.model.ModelTransmitter;
import mekanism.client.model.ModelTransporterBox;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.tileentity.TileEntityDiversionTransporter;
import mekanism.common.tileentity.TileEntityLogisticalTransporter;
import mekanism.common.transporter.TransporterStack;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderLogisticalTransporter
extends TileEntitySpecialRenderer {
    private ModelTransmitter model = new ModelTransmitter(ModelTransmitter.Size.LARGE);
    private ModelTransporterBox modelBox = new ModelTransporterBox();
    private HashMap<ForgeDirection, HashMap<Integer, MekanismRenderer.DisplayInteger>> cachedOverlays = new HashMap();
    private Minecraft mc = Minecraft.func_71410_x();
    private EntityItem entityItem = new EntityItem(null);
    private RenderItem renderer = (RenderItem)RenderManager.field_78727_a.func_78715_a(EntityItem.class);

    public void func_76894_a(TileEntity tileEntity, double x, double y, double z, float partialTick) {
        this.renderAModelAt((TileEntityLogisticalTransporter)tileEntity, x, y, z, partialTick);
    }

    public void renderAModelAt(TileEntityLogisticalTransporter tileEntity, double x, double y, double z, float partialTick) {
        int meta = Object3D.get(tileEntity).getMetadata((IBlockAccess)tileEntity.field_70331_k);
        if (meta == 3) {
            this.func_110628_a(MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "LogisticalTransporter.png"));
        } else if (meta == 4) {
            this.func_110628_a(MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "RestrictiveTransporter.png"));
        } else if (meta == 5) {
            this.func_110628_a(MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "DiversionTransporter.png"));
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glDisable((int)2884);
        if (tileEntity.color != null) {
            GL11.glColor4f((float)tileEntity.color.getColor(0), (float)tileEntity.color.getColor(1), (float)tileEntity.color.getColor(2), (float)1.0f);
        }
        boolean[] connectable = TransporterUtils.getConnections(tileEntity);
        this.model.renderCenter(connectable);
        for (int i = 0; i < 6; ++i) {
            this.model.renderSide(ForgeDirection.getOrientation((int)i), connectable[i]);
        }
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        this.entityItem.field_70292_b = 0;
        this.entityItem.field_70290_d = 0.0f;
        this.entityItem.func_70107_b((double)tileEntity.field_70329_l + 0.5, (double)tileEntity.field_70330_m + 0.5, (double)tileEntity.field_70327_n + 0.5);
        this.entityItem.field_70170_p = tileEntity.field_70331_k;
        for (TransporterStack stack : tileEntity.transit) {
            if (stack == null) continue;
            GL11.glPushMatrix();
            this.entityItem.func_92058_a(stack.itemStack);
            float[] pos = TransporterUtils.getStackPosition(tileEntity, stack, partialTick * 5.0f);
            GL11.glTranslated((double)(x + (double)pos[0]), (double)(y + (double)pos[1] - (double)this.entityItem.field_70129_M), (double)(z + (double)pos[2]));
            GL11.glScalef((float)0.75f, (float)0.75f, (float)0.75f);
            this.renderer.func_77014_a(this.entityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            GL11.glPopMatrix();
            if (stack.color == null) continue;
            this.func_110628_a(MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "TransporterBox.png"));
            GL11.glPushMatrix();
            MekanismRenderer.glowOn();
            GL11.glDisable((int)2884);
            GL11.glColor4f((float)stack.color.getColor(0), (float)stack.color.getColor(1), (float)stack.color.getColor(2), (float)1.0f);
            GL11.glTranslatef((float)((float)(x + (double)pos[0])), (float)((float)(y + (double)pos[1] - (double)this.entityItem.field_70129_M - (stack.itemStack.func_77973_b() instanceof ItemBlock ? 0.1 : 0.0))), (float)((float)(z + (double)pos[2])));
            this.modelBox.render(0.0625f);
            MekanismRenderer.glowOff();
            GL11.glPopMatrix();
        }
        if (meta == 5) {
            int zPos;
            int yPos;
            int xPos;
            Object3D obj;
            EntityClientPlayerMP player = this.mc.field_71439_g;
            World world = this.mc.field_71439_g.field_70170_p;
            ItemStack itemStack = player.func_71045_bC();
            MovingObjectPosition pos = player.func_70614_a(8.0, 1.0f);
            if (pos != null && itemStack != null && itemStack.func_77973_b() instanceof ItemConfigurator && (obj = new Object3D(xPos = MathHelper.func_76128_c((double)pos.field_72311_b), yPos = MathHelper.func_76128_c((double)pos.field_72312_c), zPos = MathHelper.func_76128_c((double)pos.field_72309_d))).equals(Object3D.get(tileEntity))) {
                int mode = ((TileEntityDiversionTransporter)tileEntity).modes[pos.field_72310_e];
                ForgeDirection side = ForgeDirection.getOrientation((int)pos.field_72310_e);
                this.push();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
                this.func_110628_a(mode == 0 ? MekanismRenderer.getItemsTexture() : MekanismRenderer.getBlocksTexture());
                GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
                int display = this.getOverlayDisplay((World)world, (ForgeDirection)side, (int)mode).display;
                GL11.glCallList((int)display);
                this.pop();
            }
        }
    }

    private void pop() {
        GL11.glPopAttrib();
        MekanismRenderer.glowOff();
        MekanismRenderer.blendOff();
        GL11.glPopMatrix();
    }

    private void push() {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)2896);
        MekanismRenderer.glowOn();
        MekanismRenderer.blendOn();
    }

    private MekanismRenderer.DisplayInteger getOverlayDisplay(World world, ForgeDirection side, int mode) {
        if (this.cachedOverlays.containsKey(side) && this.cachedOverlays.get(side).containsKey(mode)) {
            return this.cachedOverlays.get(side).get(mode);
        }
        Icon icon = null;
        switch (mode) {
            case 0: {
                icon = Item.field_77677_M.getIcon(new ItemStack(Item.field_77677_M), 0);
                break;
            }
            case 1: {
                icon = Block.field_72035_aQ.func_71858_a(0, 0);
                break;
            }
            case 2: {
                icon = Block.field_72049_aP.func_71858_a(0, 0);
            }
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Block.field_71981_t;
        toReturn.setTexture(icon);
        MekanismRenderer.DisplayInteger display = MekanismRenderer.DisplayInteger.createAndStart();
        if (this.cachedOverlays.containsKey(side)) {
            this.cachedOverlays.get(side).put(mode, display);
        } else {
            HashMap<Integer, MekanismRenderer.DisplayInteger> map = new HashMap<Integer, MekanismRenderer.DisplayInteger>();
            map.put(mode, display);
            this.cachedOverlays.put(side, map);
        }
        switch (side) {
            case DOWN: {
                toReturn.minY = -0.01;
                toReturn.maxY = 0.0;
                toReturn.minX = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
            case UP: {
                toReturn.minY = 1.0;
                toReturn.maxY = 1.01;
                toReturn.minX = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
            case NORTH: {
                toReturn.minZ = -0.01;
                toReturn.maxZ = 0.0;
                toReturn.minX = 0.0;
                toReturn.minY = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxY = 1.0;
                break;
            }
            case SOUTH: {
                toReturn.minZ = 1.0;
                toReturn.maxZ = 1.01;
                toReturn.minX = 0.0;
                toReturn.minY = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxY = 1.0;
                break;
            }
            case WEST: {
                toReturn.minX = -0.01;
                toReturn.maxX = 0.0;
                toReturn.minY = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxY = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
            case EAST: {
                toReturn.minX = 1.0;
                toReturn.maxX = 1.01;
                toReturn.minY = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxY = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
        }
        MekanismRenderer.renderObject(toReturn);
        display.endList();
        return display;
    }
}

