/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import mekanism.client.model.ModelTransmitter;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.FluidNetwork;
import mekanism.common.tileentity.TileEntityMechanicalPipe;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderMechanicalPipe
extends TileEntitySpecialRenderer {
    private ModelTransmitter model = new ModelTransmitter(ModelTransmitter.Size.LARGE);
    private HashMap<ForgeDirection, HashMap<Fluid, MekanismRenderer.DisplayInteger[]>> cachedLiquids = new HashMap();
    private static final int stages = 100;
    private static final double height = 0.45;
    private static final double offset = 0.015;

    public void func_76894_a(TileEntity tileEntity, double x, double y, double z, float partialTick) {
        this.renderAModelAt((TileEntityMechanicalPipe)tileEntity, x, y, z, partialTick);
    }

    public void renderAModelAt(TileEntityMechanicalPipe tileEntity, double x, double y, double z, float partialTick) {
        this.func_110628_a(MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "MechanicalPipe" + (tileEntity.isActive ? "Active" : "") + ".png"));
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glDisable((int)2884);
        boolean[] connectable = PipeUtils.getConnections(tileEntity);
        this.model.renderCenter(connectable);
        for (int i = 0; i < 6; ++i) {
            this.model.renderSide(ForgeDirection.getOrientation((int)i), connectable[i]);
        }
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        Fluid fluid = ((FluidNetwork)tileEntity.getTransmitterNetwork()).refFluid;
        float scale = ((FluidNetwork)tileEntity.getTransmitterNetwork()).fluidScale;
        if (scale > 0.0f && fluid != null) {
            this.push();
            MekanismRenderer.glowOn(fluid.getLuminosity());
            this.func_110628_a(MekanismRenderer.getBlocksTexture());
            GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
            boolean gas = fluid.isGaseous();
            for (int i = 0; i < 6; ++i) {
                MekanismRenderer.DisplayInteger[] displayLists;
                if (!connectable[i] || (displayLists = this.getListAndRender(ForgeDirection.getOrientation((int)i), fluid)) == null) continue;
                if (!gas) {
                    displayLists[Math.max(0, (int)(scale * 99.0f))].render();
                    continue;
                }
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)scale);
                displayLists[99].render();
            }
            MekanismRenderer.DisplayInteger[] displayLists = this.getListAndRender(ForgeDirection.UNKNOWN, fluid);
            if (displayLists != null) {
                if (!gas) {
                    displayLists[Math.max(3, (int)(scale * 99.0f))].render();
                } else {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)scale);
                    displayLists[99].render();
                }
            }
            MekanismRenderer.glowOff();
            this.pop();
        }
    }

    private void pop() {
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private void push() {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glBlendFunc((int)770, (int)771);
    }

    private MekanismRenderer.DisplayInteger[] getListAndRender(ForgeDirection side, Fluid fluid) {
        if (side == null || fluid == null || fluid.getIcon() == null) {
            return null;
        }
        if (this.cachedLiquids.containsKey(side) && this.cachedLiquids.get(side).containsKey(fluid)) {
            return this.cachedLiquids.get(side).get(fluid);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Block.field_71943_B;
        toReturn.setTexture(fluid.getIcon());
        toReturn.setSideRender(side, false);
        toReturn.setSideRender(side.getOpposite(), false);
        MekanismRenderer.DisplayInteger[] displays = new MekanismRenderer.DisplayInteger[100];
        if (this.cachedLiquids.containsKey(side)) {
            this.cachedLiquids.get(side).put(fluid, displays);
        } else {
            HashMap<Fluid, MekanismRenderer.DisplayInteger[]> map = new HashMap<Fluid, MekanismRenderer.DisplayInteger[]>();
            map.put(fluid, displays);
            this.cachedLiquids.put(side, map);
        }
        MekanismRenderer.colorFluid(fluid);
        for (int i = 0; i < 100; ++i) {
            displays[i] = MekanismRenderer.DisplayInteger.createAndStart();
            switch (side) {
                case UNKNOWN: {
                    toReturn.minX = 0.265;
                    toReturn.minY = 0.265;
                    toReturn.minZ = 0.265;
                    toReturn.maxX = 0.735;
                    toReturn.maxY = 0.265 + (double)((float)i / 100.0f) * 0.45;
                    toReturn.maxZ = 0.735;
                    break;
                }
                case DOWN: {
                    toReturn.minX = 0.5 - (double)((float)i / 100.0f) * 0.45 / 2.0;
                    toReturn.minY = 0.0;
                    toReturn.minZ = 0.5 - (double)((float)i / 100.0f) * 0.45 / 2.0;
                    toReturn.maxX = 0.5 + (double)((float)i / 100.0f) * 0.45 / 2.0;
                    toReturn.maxY = 0.265;
                    toReturn.maxZ = 0.5 + (double)((float)i / 100.0f) * 0.45 / 2.0;
                    break;
                }
                case UP: {
                    toReturn.minX = 0.5 - (double)((float)i / 100.0f) * 0.45 / 2.0;
                    toReturn.minY = 0.235 + (double)((float)i / 100.0f) * 0.45;
                    toReturn.minZ = 0.5 - (double)((float)i / 100.0f) * 0.45 / 2.0;
                    toReturn.maxX = 0.5 + (double)((float)i / 100.0f) * 0.45 / 2.0;
                    toReturn.maxY = 1.0;
                    toReturn.maxZ = 0.5 + (double)((float)i / 100.0f) * 0.45 / 2.0;
                    break;
                }
                case NORTH: {
                    toReturn.minX = 0.265;
                    toReturn.minY = 0.265;
                    toReturn.minZ = 0.0;
                    toReturn.maxX = 0.735;
                    toReturn.maxY = 0.265 + (double)((float)i / 100.0f) * 0.45;
                    toReturn.maxZ = 0.265;
                    break;
                }
                case SOUTH: {
                    toReturn.minX = 0.265;
                    toReturn.minY = 0.265;
                    toReturn.minZ = 0.735;
                    toReturn.maxX = 0.735;
                    toReturn.maxY = 0.265 + (double)((float)i / 100.0f) * 0.45;
                    toReturn.maxZ = 1.0;
                    break;
                }
                case WEST: {
                    toReturn.minX = 0.0;
                    toReturn.minY = 0.265;
                    toReturn.minZ = 0.265;
                    toReturn.maxX = 0.265;
                    toReturn.maxY = 0.265 + (double)((float)i / 100.0f) * 0.45;
                    toReturn.maxZ = 0.735;
                    break;
                }
                case EAST: {
                    toReturn.minX = 0.735;
                    toReturn.minY = 0.265;
                    toReturn.minZ = 0.265;
                    toReturn.maxX = 1.0;
                    toReturn.maxY = 0.265 + (double)((float)i / 100.0f) * 0.45;
                    toReturn.maxZ = 0.735;
                }
            }
            MekanismRenderer.renderObject(toReturn);
            MekanismRenderer.DisplayInteger cfr_ignored_0 = displays[i];
            MekanismRenderer.DisplayInteger.endList();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return displays;
    }
}

