/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.HashMap;
import mekanism.api.Object3D;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasNetwork;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.ITubeConnection;
import mekanism.client.model.ModelTransmitter;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.tileentity.TileEntityGasTank;
import mekanism.common.tileentity.TileEntityPressurizedTube;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderPressurizedTube
extends TileEntitySpecialRenderer {
    private ModelTransmitter model = new ModelTransmitter(ModelTransmitter.Size.SMALL);
    private boolean[] connectable;
    private HashMap<MekanismRenderer.BooleanArray, HashMap<Gas, MekanismRenderer.DisplayInteger>> cachedCenterGasses = new HashMap();
    private HashMap<TubeRenderData, HashMap<Gas, MekanismRenderer.DisplayInteger>> cachedSideGasses = new HashMap();
    private static final double offset = 0.015;

    public void func_76894_a(TileEntity tileEntity, double x, double y, double z, float partialTick) {
        this.renderAModelAt((TileEntityPressurizedTube)tileEntity, x, y, z, partialTick);
    }

    public void renderAModelAt(TileEntityPressurizedTube tileEntity, double x, double y, double z, float partialTick) {
        ITubeConnection[] connections;
        this.func_110628_a(MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "PressurizedTube.png"));
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glDisable((int)2884);
        this.connectable = new boolean[]{false, false, false, false, false, false};
        for (ITubeConnection connection : connections = GasTransmission.getConnections(tileEntity)) {
            int side;
            if (connection == null || !connection.canTubeConnect(ForgeDirection.getOrientation((int)(side = Arrays.asList(connections).indexOf(connection))).getOpposite())) continue;
            this.connectable[side] = true;
        }
        this.model.renderCenter(this.connectable);
        for (int i = 0; i < 6; ++i) {
            TileEntity sideTile = Object3D.get(tileEntity).getFromSide(ForgeDirection.getOrientation((int)i)).getTileEntity((IBlockAccess)tileEntity.field_70331_k);
            if (sideTile instanceof TileEntityGasTank && i != 0 && i != 1) {
                GL11.glPushMatrix();
                switch (ForgeDirection.getOrientation((int)i)) {
                    case NORTH: {
                        GL11.glScalef((float)1.0f, (float)1.0f, (float)1.7f);
                        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.077f);
                        break;
                    }
                    case SOUTH: {
                        GL11.glScalef((float)1.0f, (float)1.0f, (float)1.7f);
                        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.077f);
                        break;
                    }
                    case WEST: {
                        GL11.glScalef((float)1.7f, (float)1.0f, (float)1.0f);
                        GL11.glTranslatef((float)0.077f, (float)0.0f, (float)0.0f);
                        break;
                    }
                    case EAST: {
                        GL11.glScalef((float)1.7f, (float)1.0f, (float)1.0f);
                        GL11.glTranslatef((float)-0.077f, (float)0.0f, (float)0.0f);
                    }
                }
                this.model.renderSide(ForgeDirection.getOrientation((int)i), this.connectable[i]);
                GL11.glPopMatrix();
                continue;
            }
            this.model.renderSide(ForgeDirection.getOrientation((int)i), this.connectable[i]);
        }
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        Gas gasType = ((GasNetwork)tileEntity.getTransmitterNetwork()).refGas;
        float scale = ((GasNetwork)tileEntity.getTransmitterNetwork()).gasScale;
        if (scale > 0.0f && gasType != null && gasType.getIcon() != null) {
            this.push();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)scale);
            this.func_110628_a(MekanismRenderer.getBlocksTexture());
            GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
            for (int i = 0; i < 6; ++i) {
                if (!this.connectable[i]) continue;
                Object3D obj = Object3D.get(tileEntity).getFromSide(ForgeDirection.getOrientation((int)i));
                Block b = Block.field_71973_m[obj.getBlockId((IBlockAccess)tileEntity.field_70331_k)];
                b.func_71902_a((IBlockAccess)tileEntity.field_70331_k, obj.xCoord, obj.yCoord, obj.zCoord);
                this.getListAndRender(ForgeDirection.getOrientation((int)i), gasType, b).render();
            }
            this.getListAndRender(ForgeDirection.UNKNOWN, gasType, null).render();
            this.pop();
        }
    }

    private void pop() {
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private void push() {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glBlendFunc((int)770, (int)771);
    }

    private MekanismRenderer.DisplayInteger getListAndRender(ForgeDirection side, Gas type, Block block) {
        if (side == ForgeDirection.UNKNOWN) {
            if (this.cachedCenterGasses.containsKey(side) && this.cachedCenterGasses.get(side).containsKey(type)) {
                return this.cachedCenterGasses.get(new MekanismRenderer.BooleanArray(this.connectable)).get(type);
            }
            MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
            toReturn.baseBlock = Block.field_71943_B;
            toReturn.setTexture(type.getIcon());
            toReturn.minX = 0.315;
            toReturn.minY = 0.315;
            toReturn.minZ = 0.315;
            toReturn.maxX = 0.6849999999999999;
            toReturn.maxY = 0.6849999999999999;
            toReturn.maxZ = 0.6849999999999999;
            for (ForgeDirection face : ForgeDirection.VALID_DIRECTIONS) {
                toReturn.setSideRender(face, !this.connectable[face.ordinal()]);
            }
            MekanismRenderer.DisplayInteger display = MekanismRenderer.DisplayInteger.createAndStart();
            MekanismRenderer.renderObject(toReturn);
            MekanismRenderer.DisplayInteger.endList();
            if (this.cachedCenterGasses.containsKey(side)) {
                this.cachedCenterGasses.get(side).put(type, display);
            } else {
                HashMap<Gas, MekanismRenderer.DisplayInteger> map = new HashMap<Gas, MekanismRenderer.DisplayInteger>();
                map.put(type, display);
                this.cachedCenterGasses.put(new MekanismRenderer.BooleanArray(this.connectable), map);
            }
            return display;
        }
        TubeRenderData data = TubeRenderData.get(side, block);
        if (this.cachedSideGasses.containsKey(data) && this.cachedSideGasses.get(data).containsKey(type)) {
            return this.cachedSideGasses.get(data).get(type);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Block.field_71943_B;
        toReturn.setTexture(type.getIcon());
        toReturn.setSideRender(side, false);
        toReturn.setSideRender(side.getOpposite(), false);
        MekanismRenderer.DisplayInteger display = MekanismRenderer.DisplayInteger.createAndStart();
        if (this.cachedSideGasses.containsKey(data)) {
            this.cachedSideGasses.get(data).put(type, display);
        } else {
            HashMap<Gas, MekanismRenderer.DisplayInteger> map = new HashMap<Gas, MekanismRenderer.DisplayInteger>();
            map.put(type, display);
            this.cachedSideGasses.put(data, map);
        }
        switch (side) {
            case DOWN: {
                toReturn.minX = 0.315;
                toReturn.minY = 0.0 - (1.0 - block.func_83010_y());
                toReturn.minZ = 0.315;
                toReturn.maxX = 0.6849999999999999;
                toReturn.maxY = 0.315;
                toReturn.maxZ = 0.6849999999999999;
                break;
            }
            case UP: {
                toReturn.minX = 0.315;
                toReturn.minY = 0.6849999999999999;
                toReturn.minZ = 0.315;
                toReturn.maxX = 0.6849999999999999;
                toReturn.maxY = 1.0 + block.func_83008_x();
                toReturn.maxZ = 0.6849999999999999;
                break;
            }
            case NORTH: {
                toReturn.minX = 0.315;
                toReturn.minY = 0.315;
                toReturn.minZ = 0.0 - (1.0 - block.func_83006_A());
                toReturn.maxX = 0.6849999999999999;
                toReturn.maxY = 0.6849999999999999;
                toReturn.maxZ = 0.315;
                break;
            }
            case SOUTH: {
                toReturn.minX = 0.315;
                toReturn.minY = 0.315;
                toReturn.minZ = 0.6849999999999999;
                toReturn.maxX = 0.6849999999999999;
                toReturn.maxY = 0.6849999999999999;
                toReturn.maxZ = 1.0 + block.func_83005_z();
                break;
            }
            case WEST: {
                toReturn.minX = 0.0 - (1.0 - block.func_83007_w());
                toReturn.minY = 0.315;
                toReturn.minZ = 0.315;
                toReturn.maxX = 0.315;
                toReturn.maxY = 0.6849999999999999;
                toReturn.maxZ = 0.6849999999999999;
                break;
            }
            case EAST: {
                toReturn.minX = 0.6849999999999999;
                toReturn.minY = 0.315;
                toReturn.minZ = 0.315;
                toReturn.maxX = 1.0 + block.func_83009_v();
                toReturn.maxY = 0.6849999999999999;
                toReturn.maxZ = 0.6849999999999999;
            }
        }
        MekanismRenderer.renderObject(toReturn);
        display.endList();
        return display;
    }

    public static class TubeRenderData {
        public double minX;
        public double maxX;
        public double minY;
        public double maxY;
        public double minZ;
        public double maxZ;
        public ForgeDirection side;

        public int hashCode() {
            int code = 1;
            code = 31 * code + new Double(this.minX).hashCode();
            code = 31 * code + new Double(this.maxX).hashCode();
            code = 31 * code + new Double(this.minY).hashCode();
            code = 31 * code + new Double(this.maxY).hashCode();
            code = 31 * code + new Double(this.minZ).hashCode();
            code = 31 * code + new Double(this.maxZ).hashCode();
            code = 31 * code + this.side.ordinal();
            return code;
        }

        public boolean equals(Object data) {
            return data instanceof TubeRenderData && ((TubeRenderData)data).minX == this.minX && ((TubeRenderData)data).maxX == this.maxX && ((TubeRenderData)data).minY == this.minY && ((TubeRenderData)data).maxY == this.maxY && ((TubeRenderData)data).minZ == this.minZ && ((TubeRenderData)data).maxZ == this.maxZ && ((TubeRenderData)data).side == this.side;
        }

        public static TubeRenderData get(ForgeDirection dir, Block b) {
            TubeRenderData data = new TubeRenderData();
            data.side = dir;
            data.minX = b.func_83009_v();
            data.maxX = b.func_83007_w();
            data.minY = b.func_83008_x();
            data.maxY = b.func_83010_y();
            data.minZ = b.func_83005_z();
            data.maxZ = b.func_83006_A();
            return data;
        }
    }
}

