/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import mekanism.client.MekanismClient;
import mekanism.client.model.ModelTransmitter;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.EnergyNetwork;
import mekanism.common.tileentity.TileEntityUniversalCable;
import mekanism.common.util.CableUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderUniversalCable
extends TileEntitySpecialRenderer {
    private static ModelTransmitter model = new ModelTransmitter(ModelTransmitter.Size.SMALL);
    private static MekanismRenderer.Model3D[] energy = null;
    private static Map<ForgeDirection, MekanismRenderer.DisplayInteger> sideDisplayLists = new HashMap<ForgeDirection, MekanismRenderer.DisplayInteger>();
    private static Map<MekanismRenderer.BooleanArray, MekanismRenderer.DisplayInteger> centerDisplayLists = new HashMap<MekanismRenderer.BooleanArray, MekanismRenderer.DisplayInteger>();
    private static final double offset = 0.015;
    private boolean[] connectable;

    public void func_76894_a(TileEntity tileEntity, double x, double y, double z, float partialTick) {
        this.renderAModelAt((TileEntityUniversalCable)tileEntity, x, y, z, partialTick);
    }

    public void renderAModelAt(TileEntityUniversalCable tileEntity, double x, double y, double z, float partialTick) {
        int i;
        this.func_110628_a(MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "UniversalCable.png"));
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glDisable((int)2884);
        this.connectable = CableUtils.getConnections(tileEntity);
        model.renderCenter(this.connectable);
        for (i = 0; i < 6; ++i) {
            model.renderSide(ForgeDirection.getOrientation((int)i), this.connectable[i]);
        }
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        if (((EnergyNetwork)tileEntity.getTransmitterNetwork()).clientEnergyScale <= 0.0 || !MekanismClient.fancyUniversalCableRender) {
            return;
        }
        this.push();
        MekanismRenderer.glowOn();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)((EnergyNetwork)tileEntity.getTransmitterNetwork()).clientEnergyScale));
        this.func_110628_a(MekanismRenderer.getBlocksTexture());
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        if (energy == null) {
            energy = RenderUniversalCable.assignEnergy();
        }
        for (i = 0; i < 6; ++i) {
            if (!this.connectable[i]) continue;
            this.renderEnergy(ForgeDirection.getOrientation((int)i));
        }
        this.renderEnergy(ForgeDirection.UNKNOWN);
        MekanismRenderer.glowOff();
        this.pop();
    }

    private void renderEnergy(ForgeDirection side) {
        MekanismRenderer.DisplayInteger list = this.getDisplayList(side);
        list.render();
    }

    private void pop() {
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private void push() {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glBlendFunc((int)770, (int)771);
    }

    private static MekanismRenderer.Model3D[] assignEnergy() {
        MekanismRenderer.Model3D[] energyArray = new MekanismRenderer.Model3D[7];
        MekanismRenderer.Model3D centerModel = new MekanismRenderer.Model3D();
        centerModel.baseBlock = Block.field_71943_B;
        centerModel.setTexture(MekanismRenderer.energyIcon);
        centerModel.minX = 0.315;
        centerModel.minY = 0.315;
        centerModel.minZ = 0.315;
        centerModel.maxX = 0.6849999999999999;
        centerModel.maxY = 0.6849999999999999;
        centerModel.maxZ = 0.6849999999999999;
        energyArray[ForgeDirection.UNKNOWN.ordinal()] = centerModel;
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
            toReturn.baseBlock = Block.field_71943_B;
            toReturn.setTexture(MekanismRenderer.energyIcon);
            toReturn.setSideRender(side, false);
            toReturn.setSideRender(side.getOpposite(), false);
            switch (side) {
                case DOWN: {
                    toReturn.minX = 0.315;
                    toReturn.minY = 0.0;
                    toReturn.minZ = 0.315;
                    toReturn.maxX = 0.6849999999999999;
                    toReturn.maxY = 0.315;
                    toReturn.maxZ = 0.6849999999999999;
                    break;
                }
                case UP: {
                    toReturn.minX = 0.315;
                    toReturn.minY = 0.6849999999999999;
                    toReturn.minZ = 0.315;
                    toReturn.maxX = 0.6849999999999999;
                    toReturn.maxY = 1.0;
                    toReturn.maxZ = 0.6849999999999999;
                    break;
                }
                case NORTH: {
                    toReturn.minX = 0.315;
                    toReturn.minY = 0.315;
                    toReturn.minZ = 0.0;
                    toReturn.maxX = 0.6849999999999999;
                    toReturn.maxY = 0.6849999999999999;
                    toReturn.maxZ = 0.315;
                    break;
                }
                case SOUTH: {
                    toReturn.minX = 0.315;
                    toReturn.minY = 0.315;
                    toReturn.minZ = 0.6849999999999999;
                    toReturn.maxX = 0.6849999999999999;
                    toReturn.maxY = 0.6849999999999999;
                    toReturn.maxZ = 1.0;
                    break;
                }
                case WEST: {
                    toReturn.minX = 0.0;
                    toReturn.minY = 0.315;
                    toReturn.minZ = 0.315;
                    toReturn.maxX = 0.315;
                    toReturn.maxY = 0.6849999999999999;
                    toReturn.maxZ = 0.6849999999999999;
                    break;
                }
                case EAST: {
                    toReturn.minX = 0.6849999999999999;
                    toReturn.minY = 0.315;
                    toReturn.minZ = 0.315;
                    toReturn.maxX = 1.0;
                    toReturn.maxY = 0.6849999999999999;
                    toReturn.maxZ = 0.6849999999999999;
                }
            }
            energyArray[side.ordinal()] = toReturn;
        }
        return energyArray;
    }

    private MekanismRenderer.DisplayInteger getDisplayList(ForgeDirection side) {
        MekanismRenderer.DisplayInteger newDisplayList;
        MekanismRenderer.Model3D toRender = energy[side.ordinal()];
        if (side == ForgeDirection.UNKNOWN) {
            newDisplayList = centerDisplayLists.get(new MekanismRenderer.BooleanArray(this.connectable));
            if (newDisplayList != null) {
                return newDisplayList;
            }
            for (ForgeDirection face : ForgeDirection.VALID_DIRECTIONS) {
                toRender.setSideRender(face, !this.connectable[face.ordinal()]);
            }
            newDisplayList = MekanismRenderer.DisplayInteger.createAndStart();
            MekanismRenderer.renderObject(toRender);
            newDisplayList.endList();
            centerDisplayLists.put(new MekanismRenderer.BooleanArray(this.connectable), newDisplayList);
        } else {
            newDisplayList = sideDisplayLists.get(side);
            if (newDisplayList != null) {
                return newDisplayList;
            }
            newDisplayList = MekanismRenderer.DisplayInteger.createAndStart();
            MekanismRenderer.renderObject(toRender);
            newDisplayList.endList();
            sideDisplayLists.put(side, newDisplayList);
        }
        return newDisplayList;
    }
}

