/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.voice;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.TargetDataLine;
import mekanism.client.MekanismKeyHandler;
import mekanism.client.voice.VoiceClient;

@SideOnly(value=Side.CLIENT)
public class VoiceInput
extends Thread {
    public VoiceClient voiceClient;
    public DataLine.Info microphone;
    public TargetDataLine targetLine;

    public VoiceInput(VoiceClient client) {
        this.voiceClient = client;
        this.microphone = new DataLine.Info(TargetDataLine.class, this.voiceClient.format, 2200);
        this.setDaemon(true);
        this.setName("VoiceServer Client Input Thread");
    }

    @Override
    public void run() {
        try {
            this.targetLine = (TargetDataLine)AudioSystem.getLine(this.microphone);
            this.targetLine.open(this.voiceClient.format, 2200);
            this.targetLine.start();
            AudioInputStream audioInput = new AudioInputStream(this.targetLine);
            boolean doFlush = false;
            while (this.voiceClient.running) {
                if (MekanismKeyHandler.voiceKey.field_74513_e) {
                    this.targetLine.flush();
                    while (this.voiceClient.running && MekanismKeyHandler.voiceKey.field_74513_e) {
                        try {
                            int availableBytes = audioInput.available();
                            byte[] audioData = new byte[availableBytes > 2200 ? 2200 : availableBytes];
                            int bytesRead = audioInput.read(audioData, 0, audioData.length);
                            if (bytesRead <= 0) continue;
                            this.voiceClient.output.writeShort(audioData.length);
                            this.voiceClient.output.write(audioData);
                        }
                        catch (Exception e) {}
                    }
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    doFlush = true;
                } else if (doFlush) {
                    try {
                        this.voiceClient.output.flush();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    doFlush = false;
                }
                try {
                    Thread.sleep(20L);
                }
                catch (Exception exception) {}
            }
            audioInput.close();
        }
        catch (Exception e) {
            System.err.println("[Mekanism] VoiceServer: Error while running client input thread.");
            e.printStackTrace();
        }
    }

    public void close() {
        this.targetLine.flush();
        this.targetLine.close();
    }
}

