/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import mekanism.api.Object3D;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;

public class ConnectedTextureRenderer {
    public static final byte[][] sideEdges = new byte[][]{{2, 5, 3, 4}, {2, 5, 3, 4}, {1, 4, 0, 5}, {1, 5, 0, 4}, {1, 3, 0, 2}, {1, 2, 0, 3}};
    public int blockID;
    public int metadata;
    public String iconTitle;
    public Map<Integer, Icon> glassMap = new HashMap<Integer, Icon>();

    public ConnectedTextureRenderer(String title, int id, int meta) {
        this.iconTitle = title;
        this.blockID = id;
        this.metadata = meta;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IconRegister register) {
        this.glassMap.put(0, register.func_94245_a("mekanism:" + this.iconTitle + "_13"));
        this.glassMap.put(1, register.func_94245_a("mekanism:" + this.iconTitle + "_20"));
        this.glassMap.put(4, register.func_94245_a("mekanism:" + this.iconTitle + "_19"));
        this.glassMap.put(5, register.func_94245_a("mekanism:" + this.iconTitle + "_23"));
        this.glassMap.put(7, register.func_94245_a("mekanism:" + this.iconTitle + "_1"));
        this.glassMap.put(16, register.func_94245_a("mekanism:" + this.iconTitle + "_7"));
        this.glassMap.put(17, register.func_94245_a("mekanism:" + this.iconTitle + "_35"));
        this.glassMap.put(20, register.func_94245_a("mekanism:" + this.iconTitle + "_40"));
        this.glassMap.put(21, register.func_94245_a("mekanism:" + this.iconTitle + "_21"));
        this.glassMap.put(23, register.func_94245_a("mekanism:" + this.iconTitle + "_31"));
        this.glassMap.put(28, register.func_94245_a("mekanism:" + this.iconTitle + "_14"));
        this.glassMap.put(29, register.func_94245_a("mekanism:" + this.iconTitle + "_45"));
        this.glassMap.put(31, register.func_94245_a("mekanism:" + this.iconTitle + "_2"));
        this.glassMap.put(64, register.func_94245_a("mekanism:" + this.iconTitle + "_8"));
        this.glassMap.put(65, register.func_94245_a("mekanism:" + this.iconTitle + "_41"));
        this.glassMap.put(68, register.func_94245_a("mekanism:" + this.iconTitle + "_46"));
        this.glassMap.put(69, register.func_94245_a("mekanism:" + this.iconTitle + "_22"));
        this.glassMap.put(71, register.func_94245_a("mekanism:" + this.iconTitle + "_32"));
        this.glassMap.put(80, register.func_94245_a("mekanism:" + this.iconTitle + "_11"));
        this.glassMap.put(81, register.func_94245_a("mekanism:" + this.iconTitle + "_10"));
        this.glassMap.put(84, register.func_94245_a("mekanism:" + this.iconTitle + "_9"));
        this.glassMap.put(85, register.func_94245_a("mekanism:" + this.iconTitle + "_17"));
        this.glassMap.put(87, register.func_94245_a("mekanism:" + this.iconTitle + "_5"));
        this.glassMap.put(92, register.func_94245_a("mekanism:" + this.iconTitle + "_34"));
        this.glassMap.put(93, register.func_94245_a("mekanism:" + this.iconTitle + "_18"));
        this.glassMap.put(95, register.func_94245_a("mekanism:" + this.iconTitle + "_6"));
        this.glassMap.put(112, register.func_94245_a("mekanism:" + this.iconTitle + "_25"));
        this.glassMap.put(113, register.func_94245_a("mekanism:" + this.iconTitle + "_43"));
        this.glassMap.put(116, register.func_94245_a("mekanism:" + this.iconTitle + "_42"));
        this.glassMap.put(117, register.func_94245_a("mekanism:" + this.iconTitle + "_29"));
        this.glassMap.put(119, register.func_94245_a("mekanism:" + this.iconTitle + "_37"));
        this.glassMap.put(124, register.func_94245_a("mekanism:" + this.iconTitle + "_26"));
        this.glassMap.put(125, register.func_94245_a("mekanism:" + this.iconTitle + "_30"));
        this.glassMap.put(127, register.func_94245_a("mekanism:" + this.iconTitle + "_38"));
        this.glassMap.put(193, register.func_94245_a("mekanism:" + this.iconTitle + "_12"));
        this.glassMap.put(197, register.func_94245_a("mekanism:" + this.iconTitle + "_44"));
        this.glassMap.put(199, register.func_94245_a("mekanism:" + this.iconTitle + "_0"));
        this.glassMap.put(209, register.func_94245_a("mekanism:" + this.iconTitle + "_33"));
        this.glassMap.put(213, register.func_94245_a("mekanism:" + this.iconTitle + "_16"));
        this.glassMap.put(215, register.func_94245_a("mekanism:" + this.iconTitle + "_4"));
        this.glassMap.put(221, register.func_94245_a("mekanism:" + this.iconTitle + "_15"));
        this.glassMap.put(223, register.func_94245_a("mekanism:" + this.iconTitle + "_3"));
        this.glassMap.put(241, register.func_94245_a("mekanism:" + this.iconTitle + "_24"));
        this.glassMap.put(245, register.func_94245_a("mekanism:" + this.iconTitle + "_28"));
        this.glassMap.put(247, register.func_94245_a("mekanism:" + this.iconTitle + "_36"));
        this.glassMap.put(253, register.func_94245_a("mekanism:" + this.iconTitle + "_27"));
        this.glassMap.put(255, register.func_94245_a("mekanism:" + this.iconTitle + "_39"));
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(IBlockAccess world, int x, int y, int z, int side) {
        int map = 0;
        for (int face = 0; face < 4; ++face) {
            byte side0 = sideEdges[side][(face + 3) % 4];
            byte side1 = sideEdges[side][face];
            if (!this.canConnect(world, new Object3D(x, y, z), sideEdges[side][face], side)) {
                map |= (7 << face * 2) % 256 | 7 >>> 8 - face * 2;
                continue;
            }
            if (!this.canConnect(world, new Object3D(x, y, z).getFromSide(ForgeDirection.getOrientation((int)side0)), side1, side)) {
                map |= 1 << face * 2;
                continue;
            }
            if (this.canConnect(world, new Object3D(x, y, z).getFromSide(ForgeDirection.getOrientation((int)side1)), side0, side)) continue;
            map |= 1 << face * 2;
        }
        return this.glassMap.get(map);
    }

    private boolean canConnect(IBlockAccess access, Object3D obj, int side, int face) {
        Object3D block = obj.getFromSide(ForgeDirection.getOrientation((int)side));
        Object3D blockabove = obj.getFromSide(ForgeDirection.getOrientation((int)face));
        return block.getBlockId(access) == this.blockID && block.getMetadata(access) == this.metadata && (blockabove.getBlockId(access) != this.blockID || blockabove.getMetadata(access) != this.metadata);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderSide(IBlockAccess world, int x, int y, int z, int side) {
        Object3D obj = new Object3D(x, y, z).getFromSide(ForgeDirection.getOrientation((int)side).getOpposite());
        return obj.getBlockId(world) != this.blockID || obj.getMetadata(world) != this.metadata;
    }
}

