/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import ic2.api.energy.tile.IEnergySink;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import mekanism.api.Object3D;
import mekanism.api.energy.IStrictEnergyAcceptor;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.ITransmitter;
import mekanism.api.transmitters.ITransmitterNetwork;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.tileentity.TileEntityUniversalCable;
import mekanism.common.util.CableUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import universalelectricity.core.block.IElectrical;
import universalelectricity.core.electricity.ElectricityPack;

public class EnergyNetwork
extends DynamicNetwork<TileEntity, EnergyNetwork> {
    private double lastPowerScale = 0.0;
    private double joulesTransmitted = 0.0;
    private double joulesLastTick = 0.0;
    public double clientEnergyScale = 0.0;

    public EnergyNetwork(ITransmitter<EnergyNetwork> ... varCables) {
        this.transmitters.addAll(Arrays.asList(varCables));
        this.register();
    }

    public EnergyNetwork(Collection<ITransmitter<EnergyNetwork>> collection) {
        this.transmitters.addAll(collection);
        this.register();
    }

    public EnergyNetwork(Set<EnergyNetwork> networks) {
        for (EnergyNetwork net : networks) {
            if (net == null) continue;
            if (net.joulesLastTick > this.joulesLastTick || net.clientEnergyScale > this.clientEnergyScale) {
                this.clientEnergyScale = net.clientEnergyScale;
                this.joulesLastTick = net.joulesLastTick;
                this.joulesTransmitted = net.joulesTransmitted;
                this.lastPowerScale = net.lastPowerScale;
            }
            this.addAllTransmitters(net.transmitters);
            net.deregister();
        }
        this.refresh();
        this.register();
    }

    public synchronized double getEnergyNeeded(List<TileEntity> ignored) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return 0.0;
        }
        double totalNeeded = 0.0;
        for (TileEntity acceptor : this.getAcceptors(new Object[0])) {
            if (this.acceptorDirections.get(acceptor) == null) continue;
            ForgeDirection side = ((ForgeDirection)this.acceptorDirections.get(acceptor)).getOpposite();
            if (ignored.contains(acceptor)) continue;
            if (acceptor instanceof IStrictEnergyAcceptor) {
                totalNeeded += ((IStrictEnergyAcceptor)acceptor).getMaxEnergy() - ((IStrictEnergyAcceptor)acceptor).getEnergy();
                continue;
            }
            if (acceptor instanceof IEnergyHandler) {
                IEnergyHandler handler = (IEnergyHandler)acceptor;
                totalNeeded += (double)handler.receiveEnergy(side, Integer.MAX_VALUE, true) * Mekanism.FROM_TE;
                continue;
            }
            if (acceptor instanceof IEnergySink) {
                totalNeeded += Math.min(((IEnergySink)acceptor).demandedEnergyUnits() * Mekanism.FROM_IC2, (double)((IEnergySink)acceptor).getMaxSafeInput() * Mekanism.FROM_IC2);
                continue;
            }
            if (acceptor instanceof IPowerReceptor && MekanismUtils.useBuildcraft()) {
                totalNeeded += (double)((IPowerReceptor)acceptor).getPowerReceiver(side).powerRequest() * Mekanism.FROM_BC;
                continue;
            }
            if (!(acceptor instanceof IElectrical)) continue;
            totalNeeded += (double)((IElectrical)acceptor).getRequest(side) * Mekanism.FROM_UE;
        }
        return totalNeeded;
    }

    public synchronized double emit(double energyToSend, ArrayList<TileEntity> ignored) {
        boolean tryAgain;
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return energyToSend;
        }
        double prevEnergy = energyToSend;
        energyToSend = this.doEmit(energyToSend, ignored);
        double sent = prevEnergy - energyToSend;
        boolean bl = tryAgain = energyToSend > 0.0 && sent > 0.0;
        while (tryAgain) {
            tryAgain = false;
            prevEnergy = energyToSend;
            sent = 0.0;
            energyToSend -= energyToSend - this.doEmit(energyToSend, ignored);
            sent = prevEnergy - energyToSend;
            if (!(energyToSend > 0.0) || !(sent > 0.0)) continue;
            tryAgain = true;
        }
        return energyToSend;
    }

    public synchronized double doEmit(double energyToSend, ArrayList<TileEntity> ignored) {
        double energyAvailable = energyToSend;
        List<Object> availableAcceptors = Arrays.asList(this.getAcceptors(new Object[0]).toArray());
        Collections.shuffle(availableAcceptors);
        if (!availableAcceptors.isEmpty()) {
            int divider = availableAcceptors.size();
            double remaining = energyToSend % (double)divider;
            double sending = (energyToSend - remaining) / (double)divider;
            for (Object obj : availableAcceptors) {
                if (!(obj instanceof TileEntity) || ignored.contains(obj)) continue;
                TileEntity acceptor = (TileEntity)obj;
                double currentSending = sending + remaining;
                ForgeDirection side = (ForgeDirection)this.acceptorDirections.get(acceptor);
                if (side == null) continue;
                remaining = 0.0;
                if (acceptor instanceof IStrictEnergyAcceptor) {
                    energyToSend -= currentSending - ((IStrictEnergyAcceptor)acceptor).transferEnergyToAcceptor(side.getOpposite(), currentSending);
                    continue;
                }
                if (acceptor instanceof IEnergyHandler) {
                    IEnergyHandler handler = (IEnergyHandler)acceptor;
                    int used = handler.receiveEnergy(side.getOpposite(), (int)Math.round(currentSending * Mekanism.TO_TE), false);
                    energyToSend -= (double)used * Mekanism.FROM_TE;
                    continue;
                }
                if (acceptor instanceof IEnergySink) {
                    double toSend = Math.min(currentSending, (double)((IEnergySink)acceptor).getMaxSafeInput() * Mekanism.FROM_IC2);
                    toSend = Math.min(toSend, ((IEnergySink)acceptor).demandedEnergyUnits() * Mekanism.FROM_IC2);
                    energyToSend -= toSend - ((IEnergySink)acceptor).injectEnergyUnits(side.getOpposite(), toSend * Mekanism.TO_IC2) * Mekanism.FROM_IC2;
                    continue;
                }
                if (acceptor instanceof IPowerReceptor && MekanismUtils.useBuildcraft()) {
                    PowerHandler.PowerReceiver receiver = ((IPowerReceptor)acceptor).getPowerReceiver(side.getOpposite());
                    if (receiver == null) continue;
                    float toSend = receiver.receiveEnergy(PowerHandler.Type.PIPE, (float)Math.min((double)receiver.powerRequest(), currentSending * Mekanism.TO_BC), side.getOpposite());
                    energyToSend -= (double)toSend * Mekanism.FROM_BC;
                    continue;
                }
                if (!(acceptor instanceof IElectrical)) continue;
                double toSend = Math.min(currentSending, (double)((IElectrical)acceptor).getRequest(side.getOpposite()) * Mekanism.FROM_UE);
                ElectricityPack pack = ElectricityPack.getFromWatts((float)(toSend * Mekanism.TO_UE), ((IElectrical)acceptor).getVoltage());
                energyToSend -= (double)((IElectrical)acceptor).receiveElectricity(side.getOpposite(), pack, true) * Mekanism.FROM_UE;
            }
            double sent = energyAvailable - energyToSend;
            this.joulesTransmitted += sent;
        }
        return energyToSend;
    }

    @Override
    public synchronized Set<TileEntity> getAcceptors(Object ... data) {
        HashSet<TileEntity> toReturn = new HashSet<TileEntity>();
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return toReturn;
        }
        Set copy = (Set)this.possibleAcceptors.clone();
        for (TileEntity acceptor : copy) {
            TileEntityUniversalCable cable;
            Object handler;
            ForgeDirection side = (ForgeDirection)this.acceptorDirections.get(acceptor);
            if (side == null) continue;
            if (acceptor instanceof IStrictEnergyAcceptor) {
                handler = (IStrictEnergyAcceptor)acceptor;
                if (!handler.canReceiveEnergy(side.getOpposite()) || !(handler.getMaxEnergy() - handler.getEnergy() > 0.0)) continue;
                toReturn.add(acceptor);
                continue;
            }
            if (acceptor instanceof IEnergyHandler) {
                handler = (IEnergyHandler)acceptor;
                if (!handler.canInterface(side.getOpposite()) || handler.getMaxEnergyStored(side.getOpposite()) - handler.getEnergyStored(side.getOpposite()) <= 0) continue;
                toReturn.add(acceptor);
                continue;
            }
            if (acceptor instanceof IEnergySink) {
                handler = (IEnergySink)acceptor;
                if (!handler.acceptsEnergyFrom(null, side.getOpposite()) || !(Math.min(handler.demandedEnergyUnits() * Mekanism.FROM_IC2, (double)handler.getMaxSafeInput() * Mekanism.FROM_IC2) > 0.0)) continue;
                toReturn.add(acceptor);
                continue;
            }
            if (acceptor instanceof IElectrical) {
                handler = (IElectrical)acceptor;
                if (!handler.canConnect(side.getOpposite()) || !(handler.getRequest(side.getOpposite()) > 0.0f)) continue;
                toReturn.add(acceptor);
                continue;
            }
            if (!(acceptor instanceof IPowerReceptor) || !MekanismUtils.useBuildcraft() || (handler = (IPowerReceptor)acceptor).getPowerReceiver(side.getOpposite()) == null || !((double)handler.getPowerReceiver(side.getOpposite()).powerRequest() * Mekanism.FROM_BC > 0.0) || (cable = (TileEntityUniversalCable)Object3D.get(acceptor).getFromSide(side.getOpposite()).getTileEntity((IBlockAccess)acceptor.field_70331_k)) == null || cable.getBuildCraftIgnored().contains(acceptor)) continue;
            toReturn.add(acceptor);
        }
        return toReturn;
    }

    @Override
    public synchronized void refresh() {
        Set iterCables = (Set)this.transmitters.clone();
        Iterator it = iterCables.iterator();
        this.possibleAcceptors.clear();
        this.acceptorDirections.clear();
        while (it.hasNext()) {
            ITransmitter conductor = (ITransmitter)it.next();
            if (conductor == null || ((TileEntity)conductor).func_70320_p()) {
                it.remove();
                this.transmitters.remove(conductor);
                continue;
            }
            conductor.setTransmitterNetwork(this);
        }
        for (ITransmitter cable : iterCables) {
            TileEntity[] acceptors;
            for (TileEntity acceptor : acceptors = CableUtils.getConnectedEnergyAcceptors((TileEntity)cable)) {
                if (acceptor == null || acceptor instanceof ITransmitter) continue;
                this.possibleAcceptors.add(acceptor);
                this.acceptorDirections.put(acceptor, ForgeDirection.getOrientation((int)Arrays.asList(acceptors).indexOf(acceptor)));
            }
        }
        this.needsUpdate = true;
    }

    @Override
    public synchronized void merge(EnergyNetwork network) {
        if (network != null && network != this) {
            HashSet<EnergyNetwork> networks = new HashSet<EnergyNetwork>();
            networks.add(this);
            networks.add(network);
            ITransmitterNetwork newNetwork = this.create(networks);
            ((EnergyNetwork)newNetwork).refresh();
        }
    }

    public String toString() {
        return "[EnergyNetwork] " + this.transmitters.size() + " transmitters, " + this.possibleAcceptors.size() + " acceptors.";
    }

    @Override
    public void tick() {
        super.tick();
        this.clearJoulesTransmitted();
        double currentPowerScale = this.getPowerScale();
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            if (currentPowerScale != this.lastPowerScale) {
                this.needsUpdate = true;
            }
            this.lastPowerScale = currentPowerScale;
            if (this.needsUpdate) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTransferEvent(this, currentPowerScale));
                this.needsUpdate = false;
            }
        }
    }

    public double getPowerScale() {
        return this.joulesLastTick == 0.0 ? 0.0 : Math.min(Math.ceil(Math.log10(this.getPower()) * 2.0) / 10.0, 1.0);
    }

    public void clearJoulesTransmitted() {
        this.joulesLastTick = this.joulesTransmitted;
        this.joulesTransmitted = 0.0;
    }

    public double getPower() {
        return this.joulesLastTick * 20.0;
    }

    protected EnergyNetwork create(ITransmitter<EnergyNetwork> ... varTransmitters) {
        EnergyNetwork network = new EnergyNetwork(varTransmitters);
        network.clientEnergyScale = this.clientEnergyScale;
        network.joulesLastTick = this.joulesLastTick;
        network.joulesTransmitted = this.joulesTransmitted;
        network.lastPowerScale = this.lastPowerScale;
        return network;
    }

    protected EnergyNetwork create(Collection<ITransmitter<EnergyNetwork>> collection) {
        EnergyNetwork network = new EnergyNetwork(collection);
        network.clientEnergyScale = this.clientEnergyScale;
        network.joulesLastTick = this.joulesLastTick;
        network.joulesTransmitted = this.joulesTransmitted;
        network.lastPowerScale = this.lastPowerScale;
        return network;
    }

    protected EnergyNetwork create(Set<EnergyNetwork> networks) {
        EnergyNetwork network = new EnergyNetwork(networks);
        if (this.joulesLastTick > network.joulesLastTick || this.clientEnergyScale > network.clientEnergyScale) {
            network.clientEnergyScale = this.clientEnergyScale;
            network.joulesLastTick = this.joulesLastTick;
            network.joulesTransmitted = this.joulesTransmitted;
            network.lastPowerScale = this.lastPowerScale;
        }
        return network;
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.ENERGY;
    }

    @Override
    public String getNeeded() {
        return MekanismUtils.getEnergyDisplay(this.getEnergyNeeded(new ArrayList<TileEntity>()));
    }

    @Override
    public String getFlow() {
        return MekanismUtils.getEnergyDisplay(this.getPower());
    }

    public static class EnergyTransferEvent
    extends Event {
        public final EnergyNetwork energyNetwork;
        public final double power;

        public EnergyTransferEvent(EnergyNetwork network, double currentPower) {
            this.energyNetwork = network;
            this.power = currentPower;
        }
    }
}

