/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.ITransmitter;
import mekanism.api.transmitters.ITransmitterNetwork;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.tileentity.TileEntityMechanicalPipe;
import mekanism.common.util.PipeUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class FluidNetwork
extends DynamicNetwork<IFluidHandler, FluidNetwork> {
    public int transferDelay = 0;
    public boolean didTransfer;
    public boolean prevTransfer;
    public float fluidScale;
    public Fluid refFluid = null;

    public FluidNetwork(ITransmitter<FluidNetwork> ... varPipes) {
        this.transmitters.addAll(Arrays.asList(varPipes));
        this.register();
    }

    public FluidNetwork(Collection<ITransmitter<FluidNetwork>> collection) {
        this.transmitters.addAll(collection);
        this.register();
    }

    public FluidNetwork(Set<FluidNetwork> networks) {
        for (FluidNetwork net : networks) {
            if (net == null) continue;
            if (net.refFluid != null && net.fluidScale > this.fluidScale) {
                this.refFluid = net.refFluid;
                this.fluidScale = net.fluidScale;
            }
            this.addAllTransmitters(net.transmitters);
            net.deregister();
        }
        this.refresh();
        this.register();
    }

    public synchronized int getTotalNeeded(List<TileEntity> ignored) {
        int toReturn = 0;
        for (IFluidHandler handler : this.possibleAcceptors) {
            ForgeDirection side = ((ForgeDirection)this.acceptorDirections.get(handler)).getOpposite();
            Iterator i$ = FluidRegistry.getRegisteredFluids().values().iterator();
            if (!i$.hasNext()) continue;
            Fluid fluid = (Fluid)i$.next();
            int filled = handler.fill(side, new FluidStack(fluid, Integer.MAX_VALUE), false);
            toReturn += filled;
        }
        return toReturn;
    }

    public synchronized int emit(FluidStack fluidToSend, boolean doTransfer, TileEntity emitter) {
        if (this.refFluid != null && this.refFluid != fluidToSend.getFluid()) {
            return 0;
        }
        List<Object> availableAcceptors = Arrays.asList(this.getAcceptors(fluidToSend).toArray());
        Collections.shuffle(availableAcceptors);
        int fluidSent = 0;
        if (!availableAcceptors.isEmpty()) {
            int divider = availableAcceptors.size();
            int remaining = fluidToSend.amount % divider;
            int sending = (fluidToSend.amount - remaining) / divider;
            for (Object obj : availableAcceptors) {
                if (!(obj instanceof IFluidHandler) || obj == emitter) continue;
                IFluidHandler acceptor = (IFluidHandler)obj;
                int currentSending = sending;
                if (remaining > 0) {
                    ++currentSending;
                    --remaining;
                }
                fluidSent += acceptor.fill((ForgeDirection)this.acceptorDirections.get(acceptor), new FluidStack(fluidToSend.fluidID, currentSending), doTransfer);
            }
        }
        if (doTransfer && fluidSent > 0 && FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.refFluid = fluidToSend.getFluid();
            this.didTransfer = true;
            this.transferDelay = 2;
            this.transferDelay = 2;
        }
        return fluidSent;
    }

    @Override
    public void tick() {
        super.tick();
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            if (this.transferDelay == 0) {
                this.didTransfer = false;
            } else {
                --this.transferDelay;
            }
            if (this.didTransfer != this.prevTransfer || this.needsUpdate) {
                MinecraftForge.EVENT_BUS.post((Event)new FluidTransferEvent(this, this.refFluid != null ? this.refFluid.getID() : -1, this.didTransfer));
                this.needsUpdate = false;
            }
            this.prevTransfer = this.didTransfer;
        }
    }

    @Override
    public void clientTick() {
        super.clientTick();
        if (this.didTransfer && this.fluidScale < 1.0f) {
            this.fluidScale = Math.min(1.0f, this.fluidScale + 0.02f);
        } else if (!this.didTransfer && this.fluidScale > 0.0f) {
            this.fluidScale = Math.max(0.0f, this.fluidScale - 0.02f);
            if (this.fluidScale == 0.0f) {
                this.refFluid = null;
            }
        }
    }

    @Override
    public synchronized Set<IFluidHandler> getAcceptors(Object ... data) {
        FluidStack fluidToSend = (FluidStack)data[0];
        HashSet<IFluidHandler> toReturn = new HashSet<IFluidHandler>();
        for (IFluidHandler acceptor : this.possibleAcceptors) {
            if (!acceptor.canFill(((ForgeDirection)this.acceptorDirections.get(acceptor)).getOpposite(), fluidToSend.getFluid())) continue;
            toReturn.add(acceptor);
        }
        return toReturn;
    }

    @Override
    public synchronized void refresh() {
        Set iterPipes = (Set)this.transmitters.clone();
        Iterator it = iterPipes.iterator();
        this.possibleAcceptors.clear();
        this.acceptorDirections.clear();
        while (it.hasNext()) {
            ITransmitter conductor = (ITransmitter)it.next();
            if (conductor == null || ((TileEntity)conductor).func_70320_p()) {
                it.remove();
                this.transmitters.remove(conductor);
                continue;
            }
            conductor.setTransmitterNetwork(this);
        }
        for (ITransmitter pipe : iterPipes) {
            IFluidHandler[] acceptors;
            if (pipe instanceof TileEntityMechanicalPipe && ((TileEntityMechanicalPipe)pipe).isActive) continue;
            for (IFluidHandler acceptor : acceptors = PipeUtils.getConnectedAcceptors((TileEntity)pipe)) {
                if (acceptor == null || acceptor instanceof ITransmitter) continue;
                this.possibleAcceptors.add(acceptor);
                this.acceptorDirections.put(acceptor, ForgeDirection.getOrientation((int)Arrays.asList(acceptors).indexOf(acceptor)));
            }
        }
    }

    @Override
    public synchronized void merge(FluidNetwork network) {
        if (network != null && network != this) {
            HashSet<FluidNetwork> networks = new HashSet<FluidNetwork>();
            networks.add(this);
            networks.add(network);
            ITransmitterNetwork newNetwork = this.create(networks);
            ((FluidNetwork)newNetwork).refresh();
        }
    }

    public String toString() {
        return "[FluidNetwork] " + this.transmitters.size() + " transmitters, " + this.possibleAcceptors.size() + " acceptors.";
    }

    protected FluidNetwork create(ITransmitter<FluidNetwork> ... varTransmitters) {
        FluidNetwork network = new FluidNetwork(varTransmitters);
        network.refFluid = this.refFluid;
        network.fluidScale = this.fluidScale;
        return network;
    }

    protected FluidNetwork create(Collection<ITransmitter<FluidNetwork>> collection) {
        FluidNetwork network = new FluidNetwork(collection);
        network.refFluid = this.refFluid;
        network.fluidScale = this.fluidScale;
        return network;
    }

    protected FluidNetwork create(Set<FluidNetwork> networks) {
        FluidNetwork network = new FluidNetwork(networks);
        if (this.refFluid != null && this.fluidScale > network.fluidScale) {
            network.refFluid = this.refFluid;
            network.fluidScale = this.fluidScale;
        }
        return network;
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.FLUID;
    }

    @Override
    public String getNeeded() {
        return "Fluid needed (any type): " + (float)this.getTotalNeeded(new ArrayList<TileEntity>()) / 1000.0f + " buckets";
    }

    @Override
    public String getFlow() {
        return "Not defined yet for Fluid networks";
    }

    public static class FluidTransferEvent
    extends Event {
        public final FluidNetwork fluidNetwork;
        public final int fluidType;
        public final boolean didTransfer;

        public FluidTransferEvent(FluidNetwork network, int type, boolean did) {
            this.fluidNetwork = network;
            this.fluidType = type;
            this.didTransfer = did;
        }
    }
}

