/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import mekanism.api.EnumColor;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatMessageComponent;

public final class HolidayManager {
    private static Calendar calendar = Calendar.getInstance();
    private static Minecraft mc = Minecraft.func_71410_x();
    public static List<Holiday> holidays = new ArrayList<Holiday>();
    private static List<Holiday> holidaysNotified = new ArrayList<Holiday>();

    public static void init() {
        holidays.add(new Christmas());
        holidays.add(new NewYear());
        System.out.println("[Mekanism] Initialized HolidayManager.");
    }

    public static void check() {
        try {
            YearlyDate date = HolidayManager.getDate();
            for (Holiday holiday : holidays) {
                if (holidaysNotified.contains(holiday) || !holiday.getDate().equals(date)) continue;
                holiday.onEvent((EntityPlayer)HolidayManager.mc.field_71439_g);
                holidaysNotified.add(holiday);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static YearlyDate getDate() {
        return new YearlyDate(calendar.get(2) + 1, calendar.get(5));
    }

    private static String getThemedLines(EnumColor[] colors, int amount) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < amount; ++i) {
            builder.append((Object)((Object)colors[i % colors.length]) + "-");
        }
        return builder.toString();
    }

    public static class YearlyDate {
        public Month month;
        public int day;

        public YearlyDate(Month m, int d) {
            this.month = m;
            this.day = d;
        }

        public YearlyDate(int m, int d) {
            this(Month.values()[m - 1], d);
        }

        public boolean equals(Object obj) {
            return obj instanceof YearlyDate && ((YearlyDate)obj).month == this.month && ((YearlyDate)obj).day == this.day;
        }

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.month.ordinal();
            code = 31 * code + this.day;
            return code;
        }
    }

    public static enum Month {
        JANUARY("January"),
        FEBRUARY("February"),
        MARCH("March"),
        APRIL("April"),
        MAY("May"),
        JUNE("June"),
        JULY("July"),
        AUGUST("August"),
        SEPTEMBER("September"),
        OCTOBER("October"),
        NOVEMBER("November"),
        DECEMBER("December");

        private final String name;

        private Month(String n2) {
            this.name = n2;
        }

        public String getName() {
            return this.name;
        }

        public int month() {
            return this.ordinal() + 1;
        }
    }

    private static class NewYear
    extends Holiday {
        private NewYear() {
        }

        @Override
        public YearlyDate getDate() {
            return new YearlyDate(1, 1);
        }

        @Override
        public void onEvent(EntityPlayer player) {
            String themedLines = HolidayManager.getThemedLines(new EnumColor[]{EnumColor.WHITE, EnumColor.YELLOW}, 13);
            player.func_70006_a(ChatMessageComponent.func_111066_d((String)(themedLines + (Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + themedLines)));
            player.func_70006_a(ChatMessageComponent.func_111066_d((String)((Object)((Object)EnumColor.AQUA) + "Happy New Year, " + (Object)((Object)EnumColor.DARK_BLUE) + player.field_71092_bJ + (Object)((Object)EnumColor.RED) + "!")));
            player.func_70006_a(ChatMessageComponent.func_111066_d((String)((Object)((Object)EnumColor.AQUA) + "Best wishes to you as we enter this")));
            player.func_70006_a(ChatMessageComponent.func_111066_d((String)((Object)((Object)EnumColor.AQUA) + "new and exciting year of 2014! :)")));
            player.func_70006_a(ChatMessageComponent.func_111066_d((String)((Object)((Object)EnumColor.DARK_GREY) + "-aidancbrady")));
            player.func_70006_a(ChatMessageComponent.func_111066_d((String)(themedLines + (Object)((Object)EnumColor.DARK_BLUE) + "[=======]" + themedLines)));
        }
    }

    private static class Christmas
    extends Holiday {
        private Christmas() {
        }

        @Override
        public YearlyDate getDate() {
            return new YearlyDate(12, 25);
        }

        @Override
        public void onEvent(EntityPlayer player) {
            String themedLines = HolidayManager.getThemedLines(new EnumColor[]{EnumColor.DARK_GREEN, EnumColor.DARK_RED}, 13);
            player.func_70006_a(ChatMessageComponent.func_111066_d((String)(themedLines + (Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + themedLines)));
            player.func_70006_a(ChatMessageComponent.func_111066_d((String)((Object)((Object)EnumColor.RED) + "Merry Christmas, " + (Object)((Object)EnumColor.DARK_BLUE) + player.field_71092_bJ + (Object)((Object)EnumColor.RED) + "!")));
            player.func_70006_a(ChatMessageComponent.func_111066_d((String)((Object)((Object)EnumColor.RED) + "May you have plenty of Christmas cheer")));
            player.func_70006_a(ChatMessageComponent.func_111066_d((String)((Object)((Object)EnumColor.RED) + "and have a relaxing holiday with your")));
            player.func_70006_a(ChatMessageComponent.func_111066_d((String)((Object)((Object)EnumColor.RED) + "family :)")));
            player.func_70006_a(ChatMessageComponent.func_111066_d((String)((Object)((Object)EnumColor.DARK_GREY) + "-aidancbrady")));
            player.func_70006_a(ChatMessageComponent.func_111066_d((String)(themedLines + (Object)((Object)EnumColor.DARK_BLUE) + "[=======]" + themedLines)));
        }
    }

    public static abstract class Holiday {
        public abstract YearlyDate getDate();

        public abstract void onEvent(EntityPlayer var1);
    }
}

