/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import mekanism.common.RecipeHandler;
import mekanism.common.block.BlockMachine;
import mekanism.common.tileentity.TileEntityAdvancedElectricMachine;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;

public interface IFactory {
    public int getRecipeType(ItemStack var1);

    public void setRecipeType(int var1, ItemStack var2);

    public static enum RecipeType {
        SMELTING("smelting", "Smelter.ogg", BlockMachine.MachineType.ENERGIZED_SMELTER.getStack(), false),
        ENRICHING("enriching", "Chamber.ogg", BlockMachine.MachineType.ENRICHMENT_CHAMBER.getStack(), false),
        CRUSHING("crushing", "Crusher.ogg", BlockMachine.MachineType.CRUSHER.getStack(), false),
        COMPRESSING("compressing", "Compressor.ogg", BlockMachine.MachineType.OSMIUM_COMPRESSOR.getStack(), true),
        COMBINING("combining", "Combiner.ogg", BlockMachine.MachineType.COMBINER.getStack(), true),
        PURIFYING("purifying", "PurificationChamber.ogg", BlockMachine.MachineType.PURIFICATION_CHAMBER.getStack(), true);

        private String name;
        private String sound;
        private ItemStack stack;
        private boolean usesFuel;

        public ItemStack getCopiedOutput(ItemStack input, boolean stackDecrease) {
            if (input == null) {
                return null;
            }
            if (this == SMELTING) {
                if (FurnaceRecipes.func_77602_a().getSmeltingResult(input) != null) {
                    ItemStack toReturn = FurnaceRecipes.func_77602_a().getSmeltingResult(input).func_77946_l();
                    if (stackDecrease) {
                        --input.field_77994_a;
                    }
                    return toReturn;
                }
            } else {
                if (this == ENRICHING) {
                    return RecipeHandler.getOutput(input, stackDecrease, RecipeHandler.Recipe.ENRICHMENT_CHAMBER.get());
                }
                if (this == CRUSHING) {
                    return RecipeHandler.getOutput(input, stackDecrease, RecipeHandler.Recipe.CRUSHER.get());
                }
                if (this == COMPRESSING) {
                    return RecipeHandler.getOutput(input, stackDecrease, RecipeHandler.Recipe.OSMIUM_COMPRESSOR.get());
                }
                if (this == COMBINING) {
                    return RecipeHandler.getOutput(input, stackDecrease, RecipeHandler.Recipe.COMBINER.get());
                }
                if (this == PURIFYING) {
                    return RecipeHandler.getOutput(input, stackDecrease, RecipeHandler.Recipe.PURIFICATION_CHAMBER.get());
                }
            }
            return null;
        }

        public int getFuelTicks(ItemStack itemstack) {
            if (this.usesFuel) {
                BlockMachine.MachineType type = BlockMachine.MachineType.get(this.getStack().field_77993_c, this.getStack().func_77960_j());
                TileEntityAdvancedElectricMachine machine = (TileEntityAdvancedElectricMachine)type.create();
                return machine.getFuelTicks(itemstack);
            }
            return 0;
        }

        public int getSecondaryEnergyPerTick() {
            if (this.usesFuel) {
                BlockMachine.MachineType type = BlockMachine.MachineType.get(this.getStack().field_77993_c, this.getStack().func_77960_j());
                TileEntityAdvancedElectricMachine machine = (TileEntityAdvancedElectricMachine)type.create();
                return machine.SECONDARY_ENERGY_PER_TICK;
            }
            return 0;
        }

        public int getMaxSecondaryEnergy() {
            if (this.usesFuel) {
                BlockMachine.MachineType type = BlockMachine.MachineType.get(this.getStack().field_77993_c, this.getStack().func_77960_j());
                TileEntityAdvancedElectricMachine machine = (TileEntityAdvancedElectricMachine)type.create();
                return machine.MAX_SECONDARY_ENERGY;
            }
            return 200;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public String getName() {
            return MekanismUtils.localize("gui.factory." + this.name);
        }

        public String getSound() {
            return this.sound;
        }

        public boolean usesFuel() {
            return this.usesFuel;
        }

        private RecipeType(String s, String s1, ItemStack is, boolean b) {
            this.name = s;
            this.sound = s1;
            this.stack = is;
            this.usesFuel = b;
        }
    }
}

