/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Object3D;
import mekanism.common.Mekanism;
import mekanism.common.network.IMekanismPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;

public class PacketHandler
implements IPacketHandler {
    public static List<Class<? extends IMekanismPacket>> packets = new ArrayList<Class<? extends IMekanismPacket>>();

    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
        ByteArrayDataInput dataStream = ByteStreams.newDataInput((byte[])packet.field_73629_c);
        EntityPlayer entityplayer = (EntityPlayer)player;
        if (packet.field_73630_a.equals("MEK")) {
            try {
                int packetIndex = dataStream.readInt();
                if (packets.get(packetIndex) == null) {
                    System.err.println("[Mekanism] Received unknown packet identifier '" + packetIndex + ".' Ignorning!");
                    return;
                }
                IMekanismPacket packetType = packets.get(packetIndex).newInstance();
                if (packetType == null) {
                    System.err.println("[Mekanism] Unable to create instance of packet type '" + packetIndex + ".' Ignoring!");
                    return;
                }
                try {
                    packetType.read(dataStream, entityplayer, entityplayer.field_70170_p);
                }
                catch (Exception e) {
                    System.err.println("[Mekanism] Error while reading '" + packetType.getName() + "' packet.");
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                System.err.println("[Mekanism] Error while handling packet.");
                e.printStackTrace();
            }
        }
    }

    public static void registerPacket(Class<? extends IMekanismPacket> packetClass) {
        if (!packets.contains(packetClass)) {
            packets.add(packetClass);
        }
    }

    public static void encode(Object[] dataValues, DataOutputStream output) {
        try {
            for (Object data : dataValues) {
                if (data instanceof Integer) {
                    output.writeInt((Integer)data);
                    continue;
                }
                if (data instanceof Boolean) {
                    output.writeBoolean((Boolean)data);
                    continue;
                }
                if (data instanceof Double) {
                    output.writeDouble((Double)data);
                    continue;
                }
                if (data instanceof Float) {
                    output.writeFloat(((Float)data).floatValue());
                    continue;
                }
                if (data instanceof String) {
                    output.writeUTF((String)data);
                    continue;
                }
                if (data instanceof Byte) {
                    output.writeByte(((Byte)data).byteValue());
                    continue;
                }
                if (data instanceof int[]) {
                    for (int i : (int[])data) {
                        output.writeInt(i);
                    }
                    continue;
                }
                if (data instanceof byte[]) {
                    for (byte b : (byte[])data) {
                        output.writeByte(b);
                    }
                    continue;
                }
                if (!(data instanceof ArrayList)) continue;
                PacketHandler.encode(((ArrayList)data).toArray(), output);
            }
        }
        catch (Exception e) {
            System.err.println("[Mekanism] Error while encoding packet data.");
            e.printStackTrace();
        }
    }

    public static void sendPacket(Transmission trans, IMekanismPacket packetType, Object ... transParams) {
        if (packetType == null) {
            System.err.println("[Mekanism] Attempted to send null packet, ignoring!");
            return;
        }
        if (!packets.contains(packetType.getClass())) {
            System.err.println("[Mekanism] Attempted to send unregistered packet '" + packetType.getName() + ",' ignoring!");
            return;
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeInt(packets.indexOf(packetType.getClass()));
            packetType.write(data);
        }
        catch (Exception e) {
            System.err.println("[Mekanism] Error while encoding packet data.");
            e.printStackTrace();
        }
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = "MEK";
        packet.field_73629_c = bytes.toByteArray();
        packet.field_73628_b = packet.field_73629_c.length;
        switch (trans) {
            case SERVER: {
                PacketDispatcher.sendPacketToServer((Packet)packet);
                break;
            }
            case ALL_CLIENTS: {
                PacketDispatcher.sendPacketToAllPlayers((Packet)packet);
                break;
            }
            case CLIENTS_RANGE: {
                Object3D obj = (Object3D)transParams[0];
                PacketDispatcher.sendPacketToAllAround((double)obj.xCoord, (double)obj.yCoord, (double)obj.zCoord, (double)((Double)transParams[1]), (int)obj.dimensionId, (Packet)packet);
                break;
            }
            case CLIENTS_DIM: {
                PacketDispatcher.sendPacketToAllInDimension((Packet)packet, (int)((Integer)transParams[0]));
                break;
            }
            case SINGLE_CLIENT: {
                ((EntityPlayerMP)transParams[0]).field_71135_a.func_72567_b((Packet)packet);
            }
        }
        PacketHandler.log(trans, packetType, transParams);
    }

    private static void log(Transmission trans, IMekanismPacket packetType, Object[] transParams) {
        if (Mekanism.logPackets) {
            switch (trans) {
                case SERVER: {
                    System.out.println("[Mekanism] Sent '" + packetType.getName() + "' packet to server.");
                    break;
                }
                case ALL_CLIENTS: {
                    System.out.println("[Mekanism] Sent '" + packetType.getName() + "' packet to all clients.");
                    break;
                }
                case CLIENTS_RANGE: {
                    System.out.println("[Mekanism] Sent '" + packetType.getName() + "' packet to clients in a " + (Double)transParams[1] + " block range.");
                    break;
                }
                case CLIENTS_DIM: {
                    System.out.println("[Mekanism] Sent '" + packetType.getName() + "' packet to clients in dimension ID " + (Integer)transParams[0] + ".");
                    break;
                }
                case SINGLE_CLIENT: {
                    System.out.println("[Mekanism] Sent '" + packetType.getName() + "' packet to " + ((EntityPlayer)transParams[0]).field_71092_bJ);
                }
            }
        }
    }

    public static enum Transmission {
        SERVER(0),
        ALL_CLIENTS(0),
        CLIENTS_RANGE(2),
        CLIENTS_DIM(1),
        SINGLE_CLIENT(1);

        public int parameters;

        private Transmission(int params) {
            this.parameters = params;
        }
    }
}

