/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import java.util.HashMap;
import java.util.Map;
import mekanism.api.gas.GasStack;
import mekanism.api.infuse.InfusionInput;
import mekanism.api.infuse.InfusionOutput;
import mekanism.common.ChemicalInput;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;

public final class RecipeHandler {
    public static void addRecipe(Recipe recipe, Object input, Object output) {
        recipe.put(input, output);
    }

    public static void addEnrichmentChamberRecipe(ItemStack input, ItemStack output) {
        Recipe.ENRICHMENT_CHAMBER.put(input, output);
    }

    public static void addOsmiumCompressorRecipe(ItemStack input, ItemStack output) {
        Recipe.OSMIUM_COMPRESSOR.put(input, output);
    }

    public static void addCombinerRecipe(ItemStack input, ItemStack output) {
        Recipe.COMBINER.put(input, output);
    }

    public static void addCrusherRecipe(ItemStack input, ItemStack output) {
        Recipe.CRUSHER.put(input, output);
    }

    public static void addPurificationChamberRecipe(ItemStack input, ItemStack output) {
        Recipe.PURIFICATION_CHAMBER.put(input, output);
    }

    public static void addMetallurgicInfuserRecipe(InfusionInput input, ItemStack output) {
        Recipe.METALLURGIC_INFUSER.put(input, InfusionOutput.getInfusion(input, output));
    }

    public static void addChemicalInfuserRecipe(ChemicalInput input, GasStack output) {
        Recipe.CHEMICAL_INFUSER.put(input, output);
    }

    public static void addChemicalFormulatorRecipe(ItemStack input, GasStack output) {
        Recipe.CHEMICAL_FORMULATOR.put(input, output);
    }

    public static InfusionOutput getMetallurgicInfuserOutput(InfusionInput infusion, boolean stackDecrease) {
        if (infusion != null && infusion.inputStack != null) {
            HashMap recipes = Recipe.METALLURGIC_INFUSER.get();
            for (Map.Entry entry : recipes.entrySet()) {
                InfusionInput input = (InfusionInput)entry.getKey();
                if (!StackUtils.equalsWildcard(input.inputStack, infusion.inputStack) || infusion.inputStack.field_77994_a < input.inputStack.field_77994_a || infusion.infusionType != input.infusionType) continue;
                if (stackDecrease) {
                    infusion.inputStack.field_77994_a -= ((InfusionInput)entry.getKey()).inputStack.field_77994_a;
                }
                return ((InfusionOutput)entry.getValue()).copy();
            }
        }
        return null;
    }

    public static GasStack getChemicalInfuserOutput(ChemicalInput input) {
        if (input != null && input.isValid()) {
            HashMap recipes = Recipe.CHEMICAL_INFUSER.get();
            return (GasStack)recipes.get(input);
        }
        return null;
    }

    public static GasStack getChemicalFormulatorOutput(ItemStack itemstack, boolean stackDecrease) {
        if (itemstack != null) {
            HashMap recipes = Recipe.CHEMICAL_FORMULATOR.get();
            for (Map.Entry entry : recipes.entrySet()) {
                ItemStack stack = (ItemStack)entry.getKey();
                if (!StackUtils.equalsWildcard(stack, itemstack) || itemstack.field_77994_a < stack.field_77994_a) continue;
                if (stackDecrease) {
                    itemstack.field_77994_a -= stack.field_77994_a;
                }
                return ((GasStack)entry.getValue()).copy();
            }
        }
        return null;
    }

    public static ItemStack getOutput(ItemStack itemstack, boolean stackDecrease, Map<ItemStack, ItemStack> recipes) {
        if (itemstack != null) {
            for (Map.Entry<ItemStack, ItemStack> entry : recipes.entrySet()) {
                ItemStack stack = entry.getKey();
                if (!StackUtils.equalsWildcard(stack, itemstack) || itemstack.field_77994_a < stack.field_77994_a) continue;
                if (stackDecrease) {
                    itemstack.field_77994_a -= stack.field_77994_a;
                }
                return entry.getValue().func_77946_l();
            }
        }
        return null;
    }

    public static enum Recipe {
        ENRICHMENT_CHAMBER(new HashMap<K, V>()),
        OSMIUM_COMPRESSOR(new HashMap<K, V>()),
        COMBINER(new HashMap<K, V>()),
        CRUSHER(new HashMap<K, V>()),
        PURIFICATION_CHAMBER(new HashMap<K, V>()),
        METALLURGIC_INFUSER(new HashMap<K, V>()),
        CHEMICAL_INFUSER(new HashMap<K, V>()),
        CHEMICAL_FORMULATOR(new HashMap<K, V>());

        private HashMap recipes;

        private Recipe(HashMap map) {
            this.recipes = map;
        }

        public void put(Object input, Object output) {
            this.recipes.put(input, output);
        }

        public boolean containsRecipe(ItemStack input) {
            for (Map.Entry obj : this.get().entrySet()) {
                Map.Entry entry;
                if (!(obj instanceof Map.Entry) || !((entry = obj).getKey() instanceof ItemStack) || !((ItemStack)entry.getKey()).func_77969_a(input)) continue;
                return true;
            }
            return false;
        }

        public HashMap get() {
            return this.recipes;
        }
    }
}

