/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import java.util.HashSet;
import java.util.Set;
import mekanism.api.Object3D;
import mekanism.common.DynamicTankCache;
import mekanism.common.Mekanism;
import mekanism.common.SynchronizedTankData;
import mekanism.common.tileentity.TileEntityDynamicTank;
import mekanism.common.tileentity.TileEntityDynamicValve;
import mekanism.common.util.MekanismUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class TankUpdateProtocol {
    public static final int FLUID_PER_TANK = 16000;
    public Set<TileEntityDynamicTank> iteratedNodes = new HashSet<TileEntityDynamicTank>();
    public SynchronizedTankData structureFound = null;
    public TileEntity pointer;

    public TankUpdateProtocol(TileEntity tileEntity) {
        this.pointer = tileEntity;
    }

    public void loopThrough(TileEntity tile) {
        World worldObj = tile.field_70331_k;
        int origX = tile.field_70329_l;
        int origY = tile.field_70330_m;
        int origZ = tile.field_70327_n;
        boolean isCorner = true;
        boolean isHollow = true;
        boolean rightBlocks = true;
        boolean rightFrame = true;
        HashSet<Object3D> locations = new HashSet<Object3D>();
        int xmin = 0;
        int xmax = 0;
        int ymin = 0;
        int ymax = 0;
        int zmin = 0;
        int zmax = 0;
        int x = 0;
        int y = 0;
        int z = 0;
        int volume = 0;
        if (this.isViableNode(origX + 1, origY, origZ) && this.isViableNode(origX - 1, origY, origZ) || this.isViableNode(origX, origY + 1, origZ) && this.isViableNode(origX, origY - 1, origZ) || this.isViableNode(origX, origY, origZ + 1) && this.isViableNode(origX, origY, origZ - 1)) {
            isCorner = false;
        }
        if (isCorner) {
            if (this.isViableNode(origX + 1, origY, origZ)) {
                xmin = 0;
                while (this.isViableNode(origX + x + 1, origY, origZ)) {
                    ++x;
                }
                xmax = x;
            } else {
                xmax = 0;
                while (this.isViableNode(origX + x - 1, origY, origZ)) {
                    --x;
                }
                xmin = x;
            }
            if (this.isViableNode(origX, origY + 1, origZ)) {
                ymin = 0;
                while (this.isViableNode(origX, origY + y + 1, origZ)) {
                    ++y;
                }
                ymax = y;
            } else {
                ymax = 0;
                while (this.isViableNode(origX, origY + y - 1, origZ)) {
                    --y;
                }
                ymin = y;
            }
            if (this.isViableNode(origX, origY, origZ + 1)) {
                zmin = 0;
                while (this.isViableNode(origX, origY, origZ + z + 1)) {
                    ++z;
                }
                zmax = z;
            } else {
                zmax = 0;
                while (this.isViableNode(origX, origY, origZ + z - 1)) {
                    --z;
                }
                zmin = z;
            }
            for (x = xmin; x <= xmax; ++x) {
                for (y = ymin; y <= ymax; ++y) {
                    for (z = zmin; z <= zmax; ++z) {
                        if (x == xmin || x == xmax || y == ymin || y == ymax || z == zmin || z == zmax) {
                            if (!this.isViableNode(origX + x, origY + y, origZ + z)) {
                                rightBlocks = false;
                                break;
                            }
                            if (this.isFrame(Object3D.get(tile).translate(x, y, z), origX + xmin, origX + xmax, origY + ymin, origY + ymax, origZ + zmin, origZ + zmax) && !this.isValidFrame(origX + x, origY + y, origZ + z)) {
                                rightFrame = false;
                                break;
                            }
                            locations.add(Object3D.get(tile).translate(x, y, z));
                            continue;
                        }
                        if (!this.isAir(origX + x, origY + y, origZ + z)) {
                            isHollow = false;
                            break;
                        }
                        ++volume;
                    }
                    if (!isHollow || !rightBlocks || !rightFrame) break;
                }
                if (!isHollow || !rightBlocks || !rightFrame) break;
            }
        }
        if ((volume += locations.size()) >= 27 && volume <= 5832 && locations.size() >= 26 && rightBlocks && rightFrame && isHollow && isCorner) {
            SynchronizedTankData structure = new SynchronizedTankData();
            structure.locations = locations;
            structure.volLength = Math.abs(xmax - xmin) + 1;
            structure.volHeight = Math.abs(ymax - ymin) + 1;
            structure.volWidth = Math.abs(zmax - zmin) + 1;
            structure.volume = volume;
            structure.renderLocation = Object3D.get(tile).translate(0, 1, 0);
            for (Object3D obj : structure.locations) {
                if (!(obj.getTileEntity((IBlockAccess)this.pointer.field_70331_k) instanceof TileEntityDynamicValve)) continue;
                SynchronizedTankData.ValveData data = new SynchronizedTankData.ValveData();
                data.location = obj;
                data.side = this.getSide(obj, origX + xmin, origX + xmax, origY + ymin, origY + ymax, origZ + zmin, origZ + zmax);
                structure.valves.add(data);
            }
            if (structure.locations.contains(Object3D.get(this.pointer)) && this.isCorrectCorner(Object3D.get(tile), origX + xmin, origY + ymin, origZ + zmin)) {
                this.structureFound = structure;
                return;
            }
        }
        this.iteratedNodes.add((TileEntityDynamicTank)tile);
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity = Object3D.get(tile).getFromSide(side).getTileEntity((IBlockAccess)tile.field_70331_k);
            if (!(tileEntity instanceof TileEntityDynamicTank) || this.iteratedNodes.contains(tileEntity)) continue;
            this.loopThrough(tileEntity);
        }
    }

    public ForgeDirection getSide(Object3D obj, int xmin, int xmax, int ymin, int ymax, int zmin, int zmax) {
        if (obj.xCoord == xmin) {
            return ForgeDirection.WEST;
        }
        if (obj.xCoord == xmax) {
            return ForgeDirection.EAST;
        }
        if (obj.yCoord == ymin) {
            return ForgeDirection.DOWN;
        }
        if (obj.yCoord == ymax) {
            return ForgeDirection.UP;
        }
        if (obj.zCoord == zmin) {
            return ForgeDirection.NORTH;
        }
        if (obj.zCoord == zmax) {
            return ForgeDirection.SOUTH;
        }
        return ForgeDirection.UNKNOWN;
    }

    private boolean isAir(int x, int y, int z) {
        return this.pointer.field_70331_k.func_72799_c(x, y, z);
    }

    private boolean isViableNode(int x, int y, int z) {
        return this.pointer.field_70331_k.func_72796_p(x, y, z) instanceof TileEntityDynamicTank;
    }

    private boolean isCorrectCorner(Object3D obj, int xmin, int ymin, int zmin) {
        return obj.xCoord == xmin && obj.yCoord == ymin && obj.zCoord == zmin;
    }

    private boolean isFrame(Object3D obj, int xmin, int xmax, int ymin, int ymax, int zmin, int zmax) {
        if (obj.xCoord == xmin && obj.yCoord == ymin) {
            return true;
        }
        if (obj.xCoord == xmax && obj.yCoord == ymin) {
            return true;
        }
        if (obj.xCoord == xmin && obj.yCoord == ymax) {
            return true;
        }
        if (obj.xCoord == xmax && obj.yCoord == ymax) {
            return true;
        }
        if (obj.xCoord == xmin && obj.zCoord == zmin) {
            return true;
        }
        if (obj.xCoord == xmax && obj.zCoord == zmin) {
            return true;
        }
        if (obj.xCoord == xmin && obj.zCoord == zmax) {
            return true;
        }
        if (obj.xCoord == xmax && obj.zCoord == zmax) {
            return true;
        }
        if (obj.yCoord == ymin && obj.zCoord == zmin) {
            return true;
        }
        if (obj.yCoord == ymax && obj.zCoord == zmin) {
            return true;
        }
        if (obj.yCoord == ymin && obj.zCoord == zmax) {
            return true;
        }
        return obj.yCoord == ymax && obj.zCoord == zmax;
    }

    private boolean isValidFrame(int x, int y, int z) {
        return this.pointer.field_70331_k.func_72798_a(x, y, z) == Mekanism.basicBlockID && this.pointer.field_70331_k.func_72805_g(x, y, z) == 9;
    }

    /*
     * WARNING - void declaration
     */
    public void updateTanks() {
        this.loopThrough(this.pointer);
        if (this.structureFound != null) {
            void var2_8;
            for (TileEntityDynamicTank tileEntityDynamicTank : this.iteratedNodes) {
                if (this.structureFound.locations.contains(Object3D.get(tileEntityDynamicTank))) continue;
                for (TileEntity tileEntity : this.iteratedNodes) {
                    tileEntityDynamicTank.structure = null;
                }
                return;
            }
            int idFound = -1;
            for (Object3D obj : this.structureFound.locations) {
                TileEntityDynamicTank tileEntityDynamicTank = (TileEntityDynamicTank)obj.getTileEntity((IBlockAccess)this.pointer.field_70331_k);
                if (tileEntityDynamicTank.inventoryID == -1) continue;
                idFound = tileEntityDynamicTank.inventoryID;
                break;
            }
            DynamicTankCache dynamicTankCache = new DynamicTankCache();
            if (idFound != -1) {
                if (Mekanism.dynamicInventories.get(idFound) != null) {
                    DynamicTankCache dynamicTankCache2 = MekanismUtils.pullInventory(this.pointer.field_70331_k, idFound);
                }
            } else {
                idFound = MekanismUtils.getUniqueInventoryID();
            }
            this.structureFound.fluidStored = var2_8.fluid;
            this.structureFound.inventory = var2_8.inventory;
            if (this.structureFound.fluidStored != null) {
                this.structureFound.fluidStored.amount = Math.min(this.structureFound.fluidStored.amount, this.structureFound.volume * 16000);
            }
            for (Object3D object3D : this.structureFound.locations) {
                TileEntityDynamicTank tileEntity = (TileEntityDynamicTank)object3D.getTileEntity((IBlockAccess)this.pointer.field_70331_k);
                tileEntity.inventoryID = idFound;
                tileEntity.structure = this.structureFound;
                tileEntity.cachedFluid = this.structureFound.fluidStored;
                tileEntity.inventory = this.structureFound.inventory;
            }
        } else {
            for (TileEntity tileEntity : this.iteratedNodes) {
                ((TileEntityDynamicTank)tileEntity).structure = null;
            }
        }
    }
}

