/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import mekanism.api.EnumColor;
import net.minecraft.util.ResourceLocation;

public final class Tier {

    public static enum FactoryTier {
        BASIC("Basic", 3, new ResourceLocation("mekanism", "gui/factory/GuiBasicFactory.png")),
        ADVANCED("Advanced", 5, new ResourceLocation("mekanism", "gui/factory/GuiAdvancedFactory.png")),
        ELITE("Elite", 7, new ResourceLocation("mekanism", "gui/factory/GuiEliteFactory.png"));

        public int processes;
        public ResourceLocation guiLocation;
        public String name;

        public static FactoryTier getFromName(String tierName) {
            for (FactoryTier tier : FactoryTier.values()) {
                if (!tierName.contains(tier.name)) continue;
                return tier;
            }
            System.out.println("[Mekanism] Invalid tier identifier when retrieving with name.");
            return BASIC;
        }

        private FactoryTier(String s, int process, ResourceLocation gui) {
            this.name = s;
            this.processes = process;
            this.guiLocation = gui;
        }
    }

    public static enum EnergyCubeTier {
        BASIC("Basic", EnumColor.BRIGHT_GREEN, 2000000.0, 120.0f, 800),
        ADVANCED("Advanced", EnumColor.DARK_RED, 8000000.0, 240.0f, 3200),
        ELITE("Elite", EnumColor.DARK_BLUE, 3.2E7, 240.0f, 12800),
        ULTIMATE("Ultimate", EnumColor.PURPLE, 1.28E8, 480.0f, 51200);

        public double MAX_ELECTRICITY;
        public float VOLTAGE;
        public double OUTPUT;
        public String name;
        public EnumColor color;

        public static EnergyCubeTier getFromName(String tierName) {
            for (EnergyCubeTier tier : EnergyCubeTier.values()) {
                if (!tierName.contains(tier.name)) continue;
                return tier;
            }
            System.out.println("[Mekanism] Invalid tier identifier when retrieving with name.");
            return BASIC;
        }

        private EnergyCubeTier(String s, EnumColor c, double maxEnergy, float voltage, int out) {
            this.name = s;
            this.color = c;
            this.MAX_ELECTRICITY = maxEnergy;
            this.VOLTAGE = voltage;
            this.OUTPUT = out;
        }
    }
}

