/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import com.google.common.io.ByteArrayDataInput;
import java.util.ArrayList;
import mekanism.common.ITileComponent;
import mekanism.common.Mekanism;
import mekanism.common.tileentity.TileEntityContainerBlock;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileComponentUpgrade
implements ITileComponent {
    public static int UPGRADE_TICKS_REQUIRED = 40;
    private int upgradeSlot;
    public int upgradeTicks;
    public int speedMultiplier;
    public int energyMultiplier;
    public TileEntityContainerBlock tileEntity;

    public TileComponentUpgrade(TileEntityContainerBlock tile, int slot) {
        this.tileEntity = tile;
        this.upgradeSlot = slot;
        tile.components.add(this);
    }

    @Override
    public void tick() {
        if (!this.tileEntity.field_70331_k.field_72995_K) {
            if (this.tileEntity.inventory[this.upgradeSlot] != null) {
                if (this.tileEntity.inventory[this.upgradeSlot].func_77969_a(new ItemStack(Mekanism.EnergyUpgrade)) && this.energyMultiplier < 8) {
                    if (this.upgradeTicks < UPGRADE_TICKS_REQUIRED) {
                        ++this.upgradeTicks;
                    } else if (this.upgradeTicks == UPGRADE_TICKS_REQUIRED) {
                        this.upgradeTicks = 0;
                        ++this.energyMultiplier;
                        --this.tileEntity.inventory[this.upgradeSlot].field_77994_a;
                        if (this.tileEntity.inventory[this.upgradeSlot].field_77994_a == 0) {
                            this.tileEntity.inventory[this.upgradeSlot] = null;
                        }
                        MekanismUtils.saveChunk(this.tileEntity);
                    }
                } else if (this.tileEntity.inventory[this.upgradeSlot].func_77969_a(new ItemStack(Mekanism.SpeedUpgrade)) && this.speedMultiplier < 8) {
                    if (this.upgradeTicks < UPGRADE_TICKS_REQUIRED) {
                        ++this.upgradeTicks;
                    } else if (this.upgradeTicks == UPGRADE_TICKS_REQUIRED) {
                        this.upgradeTicks = 0;
                        ++this.speedMultiplier;
                        --this.tileEntity.inventory[this.upgradeSlot].field_77994_a;
                        if (this.tileEntity.inventory[this.upgradeSlot].field_77994_a == 0) {
                            this.tileEntity.inventory[this.upgradeSlot] = null;
                        }
                        MekanismUtils.saveChunk(this.tileEntity);
                    }
                } else {
                    this.upgradeTicks = 0;
                }
            } else {
                this.upgradeTicks = 0;
            }
        }
    }

    public int getScaledUpgradeProgress(int i) {
        return this.upgradeTicks * i / UPGRADE_TICKS_REQUIRED;
    }

    @Override
    public void read(NBTTagCompound nbtTags) {
        this.speedMultiplier = nbtTags.func_74762_e("speedMultiplier");
        this.energyMultiplier = nbtTags.func_74762_e("energyMultiplier");
    }

    @Override
    public void read(ByteArrayDataInput dataStream) {
        this.speedMultiplier = dataStream.readInt();
        this.energyMultiplier = dataStream.readInt();
        this.upgradeTicks = dataStream.readInt();
    }

    @Override
    public void write(NBTTagCompound nbtTags) {
        nbtTags.func_74768_a("speedMultiplier", this.speedMultiplier);
        nbtTags.func_74768_a("energyMultiplier", this.energyMultiplier);
    }

    @Override
    public void write(ArrayList data) {
        data.add(this.speedMultiplier);
        data.add(this.energyMultiplier);
        data.add(this.upgradeTicks);
    }
}

