/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block;

import buildcraft.api.tools.IToolWrench;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.List;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.ITubeConnection;
import mekanism.api.transmitters.ITransmitter;
import mekanism.client.ClientProxy;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.network.PacketTransmitterUpdate;
import mekanism.common.tileentity.TileEntityDiversionTransporter;
import mekanism.common.tileentity.TileEntityLogisticalTransporter;
import mekanism.common.tileentity.TileEntityMechanicalPipe;
import mekanism.common.tileentity.TileEntityPressurizedTube;
import mekanism.common.tileentity.TileEntityUniversalCable;
import mekanism.common.transporter.TransporterStack;
import mekanism.common.util.CableUtils;
import mekanism.common.util.PipeUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockTransmitter
extends Block {
    public static final float SMALL_MIN_BOUND = 0.3125f;
    public static final float SMALL_MAX_BOUND = 0.6875f;
    public static final float LARGE_MIN_BOUND = 0.25f;
    public static final float LARGE_MAX_BOUND = 0.75f;

    public BlockTransmitter(int id) {
        super(id, Material.field_76245_d);
        this.func_71848_c(2.0f);
        this.func_71894_b(5.0f);
        this.func_71849_a(Mekanism.tabMekanism);
    }

    public float getMinBound(IBlockAccess world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata < 2) {
            return 0.3125f;
        }
        return 0.25f;
    }

    public float getMaxBound(IBlockAccess world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata < 2) {
            return 0.6875f;
        }
        return 0.75f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister register) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int i, CreativeTabs creativetabs, List list) {
        list.add(new ItemStack(i, 1, 0));
        list.add(new ItemStack(i, 1, 1));
        list.add(new ItemStack(i, 1, 2));
        list.add(new ItemStack(i, 1, 3));
        list.add(new ItemStack(i, 1, 4));
        list.add(new ItemStack(i, 1, 5));
    }

    public int func_71899_b(int i) {
        return i;
    }

    public void func_71871_a(World world, int x, int y, int z, AxisAlignedBB axisalignedbb, List list, Entity entity) {
        boolean[] connectable = this.getConnectable((IBlockAccess)world, x, y, z);
        this.func_71905_a(this.getMinBound((IBlockAccess)world, x, y, z), this.getMinBound((IBlockAccess)world, x, y, z), this.getMinBound((IBlockAccess)world, x, y, z), this.getMaxBound((IBlockAccess)world, x, y, z), this.getMaxBound((IBlockAccess)world, x, y, z), this.getMaxBound((IBlockAccess)world, x, y, z));
        super.func_71871_a(world, x, y, z, axisalignedbb, list, entity);
        if (connectable[4]) {
            this.func_71905_a(0.0f, this.getMinBound((IBlockAccess)world, x, y, z), this.getMinBound((IBlockAccess)world, x, y, z), this.getMaxBound((IBlockAccess)world, x, y, z), this.getMaxBound((IBlockAccess)world, x, y, z), this.getMaxBound((IBlockAccess)world, x, y, z));
            super.func_71871_a(world, x, y, z, axisalignedbb, list, entity);
        }
        if (connectable[5]) {
            this.func_71905_a(this.getMinBound((IBlockAccess)world, x, y, z), this.getMinBound((IBlockAccess)world, x, y, z), this.getMinBound((IBlockAccess)world, x, y, z), 1.0f, this.getMaxBound((IBlockAccess)world, x, y, z), this.getMaxBound((IBlockAccess)world, x, y, z));
            super.func_71871_a(world, x, y, z, axisalignedbb, list, entity);
        }
        if (connectable[0]) {
            this.func_71905_a(this.getMinBound((IBlockAccess)world, x, y, z), 0.0f, this.getMinBound((IBlockAccess)world, x, y, z), this.getMaxBound((IBlockAccess)world, x, y, z), this.getMaxBound((IBlockAccess)world, x, y, z), this.getMaxBound((IBlockAccess)world, x, y, z));
            super.func_71871_a(world, x, y, z, axisalignedbb, list, entity);
        }
        if (connectable[1]) {
            this.func_71905_a(this.getMinBound((IBlockAccess)world, x, y, z), this.getMinBound((IBlockAccess)world, x, y, z), this.getMinBound((IBlockAccess)world, x, y, z), this.getMaxBound((IBlockAccess)world, x, y, z), 1.0f, this.getMaxBound((IBlockAccess)world, x, y, z));
            super.func_71871_a(world, x, y, z, axisalignedbb, list, entity);
        }
        if (connectable[2]) {
            this.func_71905_a(this.getMinBound((IBlockAccess)world, x, y, z), this.getMinBound((IBlockAccess)world, x, y, z), 0.0f, this.getMaxBound((IBlockAccess)world, x, y, z), this.getMaxBound((IBlockAccess)world, x, y, z), this.getMaxBound((IBlockAccess)world, x, y, z));
            super.func_71871_a(world, x, y, z, axisalignedbb, list, entity);
        }
        if (connectable[3]) {
            this.func_71905_a(this.getMinBound((IBlockAccess)world, x, y, z), this.getMinBound((IBlockAccess)world, x, y, z), this.getMinBound((IBlockAccess)world, x, y, z), this.getMaxBound((IBlockAccess)world, x, y, z), this.getMaxBound((IBlockAccess)world, x, y, z), 1.0f);
            super.func_71871_a(world, x, y, z, axisalignedbb, list, entity);
        }
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public AxisAlignedBB func_71911_a_(World world, int x, int y, int z) {
        boolean[] connectable = this.getConnectable((IBlockAccess)world, x, y, z);
        if (connectable != null) {
            float minX = this.getMinBound((IBlockAccess)world, x, y, z);
            float minY = this.getMinBound((IBlockAccess)world, x, y, z);
            float minZ = this.getMinBound((IBlockAccess)world, x, y, z);
            float maxX = this.getMaxBound((IBlockAccess)world, x, y, z);
            float maxY = this.getMaxBound((IBlockAccess)world, x, y, z);
            float maxZ = this.getMaxBound((IBlockAccess)world, x, y, z);
            if (connectable[0]) {
                minY = 0.0f;
            }
            if (connectable[1]) {
                maxY = 1.0f;
            }
            if (connectable[2]) {
                minZ = 0.0f;
            }
            if (connectable[3]) {
                maxZ = 1.0f;
            }
            if (connectable[4]) {
                minX = 0.0f;
            }
            if (connectable[5]) {
                maxX = 1.0f;
            }
            return AxisAlignedBB.func_72330_a((double)((float)x + minX), (double)((float)y + minY), (double)((float)z + minZ), (double)((float)x + maxX), (double)((float)y + maxY), (double)((float)z + maxZ));
        }
        return super.func_71911_a_(world, x, y, z);
    }

    public boolean[] getConnectable(IBlockAccess world, int x, int y, int z) {
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        boolean[] connectable = null;
        if (tileEntity != null) {
            connectable = new boolean[]{false, false, false, false, false, false};
            if (world.func_72805_g(x, y, z) == 0) {
                ITubeConnection[] connections;
                for (ITubeConnection connection : connections = GasTransmission.getConnections(tileEntity)) {
                    int side;
                    if (connection == null || !connection.canTubeConnect(ForgeDirection.getOrientation((int)(side = Arrays.asList(connections).indexOf(connection))).getOpposite())) continue;
                    connectable[side] = true;
                }
            } else if (world.func_72805_g(x, y, z) == 1) {
                connectable = CableUtils.getConnections(tileEntity);
            } else if (world.func_72805_g(x, y, z) == 2) {
                connectable = PipeUtils.getConnections(tileEntity);
            } else if (world.func_72805_g(x, y, z) == 3 || world.func_72805_g(x, y, z) == 4 || world.func_72805_g(x, y, z) == 5) {
                connectable = TransporterUtils.getConnections((TileEntityLogisticalTransporter)tileEntity);
            }
        }
        return connectable;
    }

    public void func_71902_a(IBlockAccess world, int x, int y, int z) {
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        float minX = this.getMinBound(world, x, y, z);
        float minY = this.getMinBound(world, x, y, z);
        float minZ = this.getMinBound(world, x, y, z);
        float maxX = this.getMaxBound(world, x, y, z);
        float maxY = this.getMaxBound(world, x, y, z);
        float maxZ = this.getMaxBound(world, x, y, z);
        boolean[] connectable = this.getConnectable(world, x, y, z);
        if (connectable != null) {
            if (connectable[0]) {
                minY = 0.0f;
            }
            if (connectable[1]) {
                maxY = 1.0f;
            }
            if (connectable[2]) {
                minZ = 0.0f;
            }
            if (connectable[3]) {
                maxZ = 1.0f;
            }
            if (connectable[4]) {
                minX = 0.0f;
            }
            if (connectable[5]) {
                maxX = 1.0f;
            }
            this.func_71905_a(minX, minY, minZ, maxX, maxY, maxZ);
        }
    }

    public void func_71863_a(World world, int x, int y, int z, int blockID) {
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (!world.field_72995_K && tileEntity instanceof ITransmitter) {
            ((ITransmitter)tileEntity).refreshTransmitterNetwork();
            PacketHandler.sendPacket(PacketHandler.Transmission.CLIENTS_DIM, new PacketTransmitterUpdate().setParams(new Object[]{PacketTransmitterUpdate.PacketType.UPDATE, tileEntity}), world.field_73011_w.field_76574_g);
        }
    }

    public void func_71861_g(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (!world.field_72995_K && tileEntity instanceof ITransmitter) {
            ((ITransmitter)tileEntity).refreshTransmitterNetwork();
            PacketHandler.sendPacket(PacketHandler.Transmission.CLIENTS_DIM, new PacketTransmitterUpdate().setParams(new Object[]{PacketTransmitterUpdate.PacketType.UPDATE, tileEntity}), world.field_73011_w.field_76574_g);
            if (tileEntity instanceof TileEntityUniversalCable) {
                ((TileEntityUniversalCable)tileEntity).register();
            }
        }
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71857_b() {
        return ClientProxy.TRANSMITTER_RENDER_ID;
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        switch (metadata) {
            case 0: {
                return new TileEntityPressurizedTube();
            }
            case 1: {
                return new TileEntityUniversalCable();
            }
            case 2: {
                return new TileEntityMechanicalPipe();
            }
            case 3: {
                return new TileEntityLogisticalTransporter();
            }
            case 4: {
                return new TileEntityLogisticalTransporter();
            }
            case 5: {
                return new TileEntityDiversionTransporter();
            }
        }
        return null;
    }

    public void func_71852_a(World world, int x, int y, int z, int i1, int i2) {
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (!world.field_72995_K && tileEntity instanceof TileEntityLogisticalTransporter) {
            TileEntityLogisticalTransporter transporter = (TileEntityLogisticalTransporter)world.func_72796_p(x, y, z);
            for (TransporterStack stack : transporter.transit) {
                TransporterUtils.drop(transporter, stack);
            }
        }
        super.func_71852_a(world, x, y, z, i1, i2);
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer entityplayer, int facing, float playerX, float playerY, float playerZ) {
        Item tool;
        if (world.field_72995_K) {
            return true;
        }
        if (entityplayer.func_71045_bC() != null && (tool = entityplayer.func_71045_bC().func_77973_b()) instanceof IToolWrench && ((IToolWrench)tool).canWrench(entityplayer, x, y, z)) {
            if (entityplayer.func_70093_af()) {
                this.dismantleBlock(world, x, y, z, false);
            }
            return true;
        }
        return false;
    }

    public ItemStack dismantleBlock(World world, int x, int y, int z, boolean returnBlock) {
        int meta = world.func_72805_g(x, y, z);
        ItemStack itemStack = new ItemStack(this.field_71990_ca, 1, meta);
        world.func_94571_i(x, y, z);
        if (!returnBlock) {
            float motion = 0.3f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)x + motionX, (double)y + motionY, (double)z + motionZ, itemStack);
            world.func_72838_d((Entity)entityItem);
        }
        return itemStack;
    }
}

