/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration;

import ic2.api.item.IElectricItemManager;
import mekanism.api.energy.IEnergizedItem;
import mekanism.common.Mekanism;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;

public class IC2ItemManager
implements IElectricItemManager {
    public IEnergizedItem energizedItem;

    public static IC2ItemManager getManager(IEnergizedItem item) {
        IC2ItemManager manager = new IC2ItemManager();
        manager.energizedItem = item;
        return manager;
    }

    @Override
    public int charge(ItemStack itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        if (this.energizedItem.canReceive(itemStack)) {
            double energyNeeded = this.energizedItem.getMaxEnergy(itemStack) - this.energizedItem.getEnergy(itemStack);
            double energyToStore = Math.min(Math.min((double)amount * Mekanism.FROM_IC2, this.energizedItem.getMaxEnergy(itemStack) * 0.01), energyNeeded);
            if (!simulate) {
                this.energizedItem.setEnergy(itemStack, this.energizedItem.getEnergy(itemStack) + energyToStore);
            }
            return (int)Math.round(energyToStore * Mekanism.TO_IC2);
        }
        return 0;
    }

    @Override
    public int discharge(ItemStack itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        if (this.energizedItem.canSend(itemStack)) {
            double energyWanted = (double)amount * Mekanism.FROM_IC2;
            double energyToGive = Math.min(Math.min(energyWanted, this.energizedItem.getMaxEnergy(itemStack) * 0.01), this.energizedItem.getEnergy(itemStack));
            if (!simulate) {
                this.energizedItem.setEnergy(itemStack, this.energizedItem.getEnergy(itemStack) - energyToGive);
            }
            return (int)Math.round(energyToGive * Mekanism.TO_IC2);
        }
        return 0;
    }

    @Override
    public boolean canUse(ItemStack itemStack, int amount) {
        return this.energizedItem.getEnergy(itemStack) >= (double)amount * Mekanism.FROM_IC2;
    }

    @Override
    public int getCharge(ItemStack itemStack) {
        return (int)Math.round(this.energizedItem.getEnergy(itemStack) * Mekanism.TO_IC2);
    }

    @Override
    public boolean use(ItemStack itemStack, int amount, EntityLivingBase entity) {
        return false;
    }

    @Override
    public void chargeFromArmor(ItemStack itemStack, EntityLivingBase entity) {
    }

    @Override
    public String getToolTip(ItemStack itemStack) {
        return null;
    }
}

