/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory;

import mekanism.common.item.ItemBlockBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class InventoryBin {
    public final int MAX_STORAGE = 4096;
    public ItemStack bin;

    public InventoryBin(ItemStack stack) {
        this.bin = stack;
    }

    public ItemStack getStack() {
        if (this.getItemCount() > 0) {
            ItemStack ret = this.getItemType().func_77946_l();
            ret.field_77994_a = Math.min(this.getItemType().func_77976_d(), this.getItemCount());
            return ret;
        }
        return null;
    }

    public ItemStack removeStack() {
        ItemStack stack = this.getStack();
        if (stack == null) {
            return null;
        }
        this.setItemCount(this.getItemCount() - stack.field_77994_a);
        return stack.func_77946_l();
    }

    public ItemStack add(ItemStack stack) {
        if (this.isValid(stack) && this.getItemCount() != 4096) {
            if (this.getItemType() == null) {
                this.setItemType(stack);
            }
            if (this.getItemCount() + stack.field_77994_a <= 4096) {
                this.setItemCount(this.getItemCount() + stack.field_77994_a);
                return null;
            }
            ItemStack rejects = this.getItemType().func_77946_l();
            rejects.field_77994_a = this.getItemCount() + stack.field_77994_a - 4096;
            this.setItemCount(4096);
            return rejects;
        }
        return stack;
    }

    public boolean isValid(ItemStack stack) {
        if (stack == null || stack.field_77994_a <= 0) {
            return false;
        }
        if (stack.func_77984_f() && stack.func_77951_h()) {
            return false;
        }
        if (stack.func_77973_b() instanceof ItemBlockBasic && stack.func_77960_j() == 6) {
            return false;
        }
        if (this.getItemType() == null) {
            return true;
        }
        return stack.func_77969_a(this.getItemType()) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)this.getItemType());
    }

    public int getItemCount() {
        if (this.bin.field_77990_d == null) {
            return 0;
        }
        return this.bin.field_77990_d.func_74762_e("itemCount");
    }

    public void setItemCount(int count) {
        if (this.bin.field_77990_d == null) {
            this.bin.func_77982_d(new NBTTagCompound());
        }
        this.bin.field_77990_d.func_74768_a("itemCount", Math.max(0, count));
        if (this.getItemCount() == 0) {
            this.setItemType(null);
        }
    }

    public ItemStack getItemType() {
        if (this.bin.field_77990_d == null || this.getItemCount() == 0) {
            return null;
        }
        int id = this.bin.field_77990_d.func_74762_e("itemID");
        int meta = this.bin.field_77990_d.func_74762_e("itemMeta");
        if (this.getItemCount() == 0 || id == 0) {
            this.setItemType(null);
            return null;
        }
        return new ItemStack(id, 1, meta);
    }

    public void setItemType(ItemStack stack) {
        if (this.bin.field_77990_d == null) {
            this.bin.func_77982_d(new NBTTagCompound());
        }
        if (stack == null) {
            this.bin.field_77990_d.func_82580_o("itemID");
            this.bin.field_77990_d.func_82580_o("itemMeta");
            return;
        }
        ItemStack ret = stack.func_77946_l();
        ret.field_77994_a = 1;
        this.bin.field_77990_d.func_74768_a("itemID", stack.field_77993_c);
        this.bin.field_77990_d.func_74768_a("itemMeta", stack.func_77960_j());
    }
}

