/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import mekanism.api.EnumColor;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasItem;
import mekanism.common.ISustainedInventory;
import mekanism.common.Mekanism;
import mekanism.common.tileentity.TileEntityGasTank;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class ItemBlockGasTank
extends ItemBlock
implements IGasItem,
ISustainedInventory {
    public Block metaBlock;
    public int MAX_GAS = 96000;
    public static final int TRANSFER_RATE = 16;

    public ItemBlockGasTank(int id, Block block) {
        super(id);
        this.metaBlock = block;
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.func_77656_e(100);
        this.setNoRepair();
        this.func_77637_a(Mekanism.tabMekanism);
    }

    public int func_77647_b(int i) {
        return i;
    }

    public Icon func_77617_a(int i) {
        return this.metaBlock.func_71858_a(2, i);
    }

    public String func_77667_c(ItemStack itemstack) {
        return this.func_77658_a() + "." + "GasTank";
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        boolean place = super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata);
        if (place) {
            TileEntityGasTank tileEntity = (TileEntityGasTank)world.func_72796_p(x, y, z);
            tileEntity.gasStored = this.getGas(stack);
            tileEntity.setInventory(this.getInventory(stack), new Object[0]);
        }
        return place;
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        GasStack gasStack = this.getGas(itemstack);
        if (gasStack == null) {
            list.add("No gas stored.");
        } else {
            list.add("Stored " + gasStack.getGas().getLocalizedName() + ": " + gasStack.amount);
        }
        if (!Keyboard.isKeyDown((int)42)) {
            list.add("Hold " + (Object)((Object)EnumColor.AQUA) + "shift" + (Object)((Object)EnumColor.GREY) + " for more details.");
        } else {
            list.add((Object)((Object)EnumColor.AQUA) + "Inventory: " + (Object)((Object)EnumColor.GREY) + (this.getInventory(itemstack) != null && this.getInventory(itemstack).func_74745_c() != 0));
        }
    }

    public void func_77622_d(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        itemstack = this.getEmptyItem();
    }

    @Override
    public GasStack getGas(Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemstack = (ItemStack)data[0];
            if (itemstack.field_77990_d == null) {
                return null;
            }
            GasStack stored = GasStack.readFromNBT(itemstack.field_77990_d.func_74775_l("stored"));
            if (stored == null) {
                itemstack.func_77964_b(100);
            } else {
                itemstack.func_77964_b((int)Math.max(1.0f, Math.abs((float)stored.amount / (float)this.getMaxGas(itemstack) * 100.0f - 100.0f)));
            }
            return stored;
        }
        return null;
    }

    @Override
    public void setGas(GasStack stack, Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemstack = (ItemStack)data[0];
            if (itemstack.field_77990_d == null) {
                itemstack.func_77982_d(new NBTTagCompound());
            }
            if (stack == null || stack.amount == 0) {
                itemstack.func_77964_b(100);
                itemstack.field_77990_d.func_82580_o("stored");
            } else {
                int amount = Math.max(0, Math.min(stack.amount, this.getMaxGas(itemstack)));
                GasStack gasStack = new GasStack(stack.getGas(), amount);
                itemstack.func_77964_b((int)Math.max(1.0f, Math.abs((float)amount / (float)this.getMaxGas(itemstack) * 100.0f - 100.0f)));
                itemstack.field_77990_d.func_74766_a("stored", gasStack.write(new NBTTagCompound()));
            }
        }
    }

    public ItemStack getEmptyItem() {
        ItemStack empty = new ItemStack((Item)this);
        this.setGas(null, empty);
        empty.func_77964_b(100);
        return empty;
    }

    public void func_77633_a(int i, CreativeTabs tabs, List list) {
        ItemStack empty = new ItemStack((Item)this);
        this.setGas(null, empty);
        empty.func_77964_b(100);
        list.add(empty);
        for (Gas type : GasRegistry.getRegisteredGasses()) {
            ItemStack filled = new ItemStack((Item)this);
            this.setGas(new GasStack(type, ((IGasItem)filled.func_77973_b()).getMaxGas(filled)), filled);
            list.add(filled);
        }
    }

    @Override
    public int getMaxGas(Object ... data) {
        if (data[0] instanceof ItemStack) {
            return this.MAX_GAS;
        }
        return 0;
    }

    @Override
    public int getRate(ItemStack itemstack) {
        return 16;
    }

    @Override
    public int addGas(ItemStack itemstack, GasStack stack) {
        if (this.getGas(itemstack) != null && this.getGas(itemstack).getGas() != stack.getGas()) {
            return 0;
        }
        int toUse = Math.min(this.getMaxGas(itemstack) - this.getStored(itemstack), Math.min(this.getRate(itemstack), stack.amount));
        this.setGas(new GasStack(stack.getGas(), this.getStored(itemstack) + toUse), itemstack);
        return toUse;
    }

    @Override
    public GasStack removeGas(ItemStack itemstack, int amount) {
        if (this.getGas(itemstack) == null) {
            return null;
        }
        Gas type = this.getGas(itemstack).getGas();
        int gasToUse = Math.min(this.getStored(itemstack), Math.min(this.getRate(itemstack), amount));
        this.setGas(new GasStack(type, this.getStored(itemstack) - gasToUse), itemstack);
        return new GasStack(type, gasToUse);
    }

    private int getStored(ItemStack itemstack) {
        return this.getGas(itemstack) != null ? this.getGas((Object[])new Object[]{itemstack}).amount : 0;
    }

    @Override
    public boolean canReceiveGas(ItemStack itemstack, Gas type) {
        return this.getGas(itemstack) == null || this.getGas(itemstack).getGas() == type;
    }

    @Override
    public boolean canProvideGas(ItemStack itemstack, Gas type) {
        return this.getGas(itemstack) != null && (type == null || this.getGas(itemstack).getGas() == type);
    }

    @Override
    public void setInventory(NBTTagList nbtTags, Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            itemStack.field_77990_d.func_74782_a("Items", (NBTBase)nbtTags);
        }
    }

    @Override
    public NBTTagList getInventory(Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                return null;
            }
            return itemStack.field_77990_d.func_74761_m("Items");
        }
        return null;
    }
}

