/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import buildcraft.api.tools.IToolWrench;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mekanism.api.EnumColor;
import mekanism.api.Object3D;
import mekanism.common.IConfigurable;
import mekanism.common.IInvConfiguration;
import mekanism.common.PacketHandler;
import mekanism.common.item.ItemEnergized;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tileentity.TileEntityBasicBlock;
import mekanism.common.tileentity.TileEntityElectricChest;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class ItemConfigurator
extends ItemEnergized
implements IToolWrench {
    public final int ENERGY_PER_CONFIGURE = 400;
    public final int ENERGY_PER_ITEM_DUMP = 8;
    private Random random = new Random();

    public ItemConfigurator(int id) {
        super(id, 60000.0, 120.0f);
    }

    @Override
    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        super.func_77624_a(itemstack, entityplayer, list, flag);
        list.add((Object)((Object)EnumColor.PINK) + MekanismUtils.localize("gui.state") + ": " + (Object)((Object)EnumColor.GREY) + this.getStateDisplay(this.getState(itemstack)));
        if (this.getState(itemstack) == 3) {
            if (this.hasLink(itemstack)) {
                Object3D obj = this.getLink(itemstack);
                list.add((Object)((Object)EnumColor.GREY) + MekanismUtils.localize("tooltip.configurator.linkMsg") + " " + (Object)((Object)EnumColor.INDIGO) + MekanismUtils.getCoordDisplay(obj) + (Object)((Object)EnumColor.GREY) + ", " + MekanismUtils.localize("tooltip.configurator.dim") + " " + (Object)((Object)EnumColor.INDIGO) + obj.dimensionId);
            } else {
                list.add((Object)((Object)EnumColor.GREY) + MekanismUtils.localize("tooltip.configurator.noLink"));
            }
        }
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            Object config;
            TileEntity tile = world.func_72796_p(x, y, z);
            if (tile instanceof IConfigurable) {
                config = (IConfigurable)tile;
                if (player.func_70093_af()) {
                    config.onSneakRightClick(player, side);
                } else {
                    config.onRightClick(player, side);
                }
            }
            if (this.getState(stack) == 0) {
                if (tile instanceof IInvConfiguration) {
                    config = (IInvConfiguration)tile;
                    if (!player.func_70093_af()) {
                        player.func_70006_a(ChatMessageComponent.func_111066_d((String)((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + (Object)((Object)EnumColor.GREY) + " " + MekanismUtils.localize("tooltip.configurator.viewColor") + ": " + config.getSideData().get((int)config.getConfiguration()[MekanismUtils.getBaseOrientation((int)side, (int)config.getOrientation())]).color.getName())));
                        return true;
                    }
                    if (this.getEnergy(stack) >= 400.0) {
                        this.setEnergy(stack, this.getEnergy(stack) - 400.0);
                        MekanismUtils.incrementOutput((IInvConfiguration)config, MekanismUtils.getBaseOrientation(side, config.getOrientation()));
                        player.func_70006_a(ChatMessageComponent.func_111066_d((String)((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + (Object)((Object)EnumColor.GREY) + " " + MekanismUtils.localize("tooltip.configurator.toggleColor") + ": " + config.getSideData().get((int)config.getConfiguration()[MekanismUtils.getBaseOrientation((int)side, (int)config.getOrientation())]).color.getName())));
                        if (config instanceof TileEntityBasicBlock) {
                            TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)config;
                            PacketHandler.sendPacket(PacketHandler.Transmission.CLIENTS_RANGE, new PacketTileEntity().setParams(Object3D.get(tileEntity), tileEntity.getNetworkedData(new ArrayList())), Object3D.get(tileEntity), 50.0);
                        }
                        return true;
                    }
                }
            } else if (this.getState(stack) == 1) {
                if (tile instanceof IInventory) {
                    boolean itemAmount = false;
                    IInventory inv = (IInventory)tile;
                    if (!(inv instanceof TileEntityElectricChest) || ((TileEntityElectricChest)inv).canAccess()) {
                        for (int i = 0; i < inv.func_70302_i_(); ++i) {
                            ItemStack slotStack = inv.func_70301_a(i);
                            if (slotStack == null) continue;
                            if (this.getEnergy(stack) < 8.0) break;
                            float xRandom = this.random.nextFloat() * 0.8f + 0.1f;
                            float yRandom = this.random.nextFloat() * 0.8f + 0.1f;
                            float zRandom = this.random.nextFloat() * 0.8f + 0.1f;
                            while (slotStack.field_77994_a > 0) {
                                int j = this.random.nextInt(21) + 10;
                                if (j > slotStack.field_77994_a) {
                                    j = slotStack.field_77994_a;
                                }
                                slotStack.field_77994_a -= j;
                                EntityItem item = new EntityItem(world, (double)((float)x + xRandom), (double)((float)y + yRandom), (double)((float)z + zRandom), new ItemStack(slotStack.field_77993_c, j, slotStack.func_77960_j()));
                                if (slotStack.func_77942_o()) {
                                    item.func_92059_d().func_77982_d((NBTTagCompound)slotStack.func_77978_p().func_74737_b());
                                }
                                float k = 0.05f;
                                item.field_70159_w = this.random.nextGaussian() * (double)k;
                                item.field_70181_x = this.random.nextGaussian() * (double)k + (double)0.2f;
                                item.field_70179_y = this.random.nextGaussian() * (double)k;
                                world.func_72838_d((Entity)item);
                                inv.func_70299_a(i, null);
                                this.setEnergy(stack, this.getEnergy(stack) - 8.0);
                            }
                        }
                        return true;
                    }
                    player.func_71035_c((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism] " + (Object)((Object)EnumColor.GREY) + MekanismUtils.localize("tooltip.configurator.unauth"));
                    return true;
                }
            } else if (this.getState(stack) == 2) {
                if (tile instanceof TileEntityBasicBlock) {
                    TileEntityBasicBlock basicBlock = (TileEntityBasicBlock)tile;
                    int newSide = basicBlock.facing;
                    newSide = !player.func_70093_af() ? side : ForgeDirection.OPPOSITES[side];
                    if (basicBlock.canSetFacing(newSide)) {
                        basicBlock.setFacing((short)newSide);
                        world.func_72908_a((double)x, (double)y, (double)z, "random.click", 1.0f, 1.0f);
                    }
                    return true;
                }
            } else if (this.getState(stack) == 3 && !world.field_72995_K && player.func_70093_af()) {
                Object3D obj = new Object3D(x, y, z, world.field_73011_w.field_76574_g);
                player.func_71035_c((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + (Object)((Object)EnumColor.GREY) + " Set link to block " + (Object)((Object)EnumColor.INDIGO) + MekanismUtils.getCoordDisplay(obj) + (Object)((Object)EnumColor.GREY) + ", dimension " + (Object)((Object)EnumColor.INDIGO) + obj.dimensionId);
                this.setLink(stack, obj);
                return true;
            }
        }
        return false;
    }

    public String getStateDisplay(int state) {
        switch (state) {
            case 0: {
                return MekanismUtils.localize("tooltip.configurator.modify");
            }
            case 1: {
                return MekanismUtils.localize("tooltip.configurator.empty");
            }
            case 2: {
                return MekanismUtils.localize("tooltip.configurator.wrench");
            }
            case 3: {
                return MekanismUtils.localize("tooltip.configurator.link");
            }
        }
        return "unknown";
    }

    public EnumColor getColor(int state) {
        switch (state) {
            case 0: {
                return EnumColor.BRIGHT_GREEN;
            }
            case 1: {
                return EnumColor.AQUA;
            }
            case 2: {
                return EnumColor.YELLOW;
            }
            case 3: {
                return EnumColor.PINK;
            }
        }
        return EnumColor.GREY;
    }

    public void setState(ItemStack itemstack, byte state) {
        if (itemstack.field_77990_d == null) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        itemstack.field_77990_d.func_74774_a("state", state);
    }

    public byte getState(ItemStack itemstack) {
        if (itemstack.field_77990_d == null) {
            return 0;
        }
        byte state = 0;
        if (itemstack.field_77990_d.func_74781_a("state") != null) {
            state = itemstack.field_77990_d.func_74771_c("state");
        }
        return state;
    }

    public boolean hasLink(ItemStack itemStack) {
        return this.getLink(itemStack) != null;
    }

    public Object3D getLink(ItemStack itemStack) {
        if (itemStack.field_77990_d == null || !itemStack.func_77978_p().func_74764_b("position")) {
            return null;
        }
        return Object3D.read(itemStack.func_77978_p().func_74775_l("position"));
    }

    public void setLink(ItemStack itemStack, Object3D obj) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.func_77978_p().func_74766_a("position", obj.write(new NBTTagCompound()));
    }

    public void clearLink(ItemStack itemStack) {
        itemStack.func_77978_p().func_82580_o("position");
    }

    @Override
    public boolean canSend(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean canWrench(EntityPlayer player, int x, int y, int z) {
        return true;
    }

    @Override
    public void wrenchUsed(EntityPlayer player, int x, int y, int z) {
    }
}

